/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.worker;

import com.uber.cadence.PollForActivityTaskResponse;
import com.uber.cadence.internal.worker.Poller;
import com.uber.cadence.internal.worker.SingleWorkerOptions;
import com.uber.m3.tally.Scope;
import com.uber.m3.util.Duration;
import com.uber.m3.util.ImmutableMap;
import java.util.Map;
import org.apache.thrift.TException;

abstract class ActivityPollTaskBase
implements Poller.PollTask<PollForActivityTaskResponse> {
    protected final SingleWorkerOptions options;

    public ActivityPollTaskBase(SingleWorkerOptions options) {
        this.options = options;
    }

    @Override
    public PollForActivityTaskResponse poll() throws TException {
        PollForActivityTaskResponse result = this.pollTask();
        if (result == null || result.getTaskToken() == null) {
            return null;
        }
        Scope metricsScope = this.options.getMetricsScope().tagged((Map)ImmutableMap.of((Object)"ActivityType", (Object)result.getActivityType().getName(), (Object)"WorkflowType", (Object)result.getWorkflowType().getName()));
        metricsScope.counter("cadence-activity-poll-succeed").inc(1L);
        metricsScope.timer("cadence-activity-scheduled-to-start-latency").record(Duration.ofNanos((long)(result.getStartedTimestamp() - result.getScheduledTimestampOfThisAttempt())));
        return result;
    }

    protected abstract PollForActivityTaskResponse pollTask() throws TException;
}

