/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.worker;

import com.uber.cadence.context.ContextPropagator;
import com.uber.cadence.converter.DataConverter;
import com.uber.cadence.converter.JsonDataConverter;
import com.uber.cadence.internal.metrics.NoopScope;
import com.uber.cadence.internal.worker.PollerOptions;
import com.uber.m3.tally.Scope;
import java.time.Duration;
import java.util.List;

public final class SingleWorkerOptions {
    private final String identity;
    private final DataConverter dataConverter;
    private final int taskExecutorThreadPoolSize;
    private final double taskListActivitiesPerSecond;
    private final PollerOptions pollerOptions;
    private final Scope metricsScope;
    private final boolean enableLoggingInReplay;
    private List<ContextPropagator> contextPropagators;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(SingleWorkerOptions options) {
        return new Builder(options);
    }

    private SingleWorkerOptions(String identity, DataConverter dataConverter, int taskExecutorThreadPoolSize, double taskListActivitiesPerSecond, PollerOptions pollerOptions, Scope metricsScope, boolean enableLoggingInReplay, List<ContextPropagator> contextPropagators) {
        this.identity = identity;
        this.dataConverter = dataConverter;
        this.taskExecutorThreadPoolSize = taskExecutorThreadPoolSize;
        this.taskListActivitiesPerSecond = taskListActivitiesPerSecond;
        this.pollerOptions = pollerOptions;
        this.metricsScope = metricsScope;
        this.enableLoggingInReplay = enableLoggingInReplay;
        this.contextPropagators = contextPropagators;
    }

    public String getIdentity() {
        return this.identity;
    }

    public DataConverter getDataConverter() {
        return this.dataConverter;
    }

    int getTaskExecutorThreadPoolSize() {
        return this.taskExecutorThreadPoolSize;
    }

    PollerOptions getPollerOptions() {
        return this.pollerOptions;
    }

    public double getTaskListActivitiesPerSecond() {
        return this.taskListActivitiesPerSecond;
    }

    public Scope getMetricsScope() {
        return this.metricsScope;
    }

    public boolean getEnableLoggingInReplay() {
        return this.enableLoggingInReplay;
    }

    public List<ContextPropagator> getContextPropagators() {
        return this.contextPropagators;
    }

    public static final class Builder {
        private String identity;
        private DataConverter dataConverter;
        private int taskExecutorThreadPoolSize = 100;
        private double taskListActivitiesPerSecond;
        private PollerOptions pollerOptions;
        private Scope metricsScope;
        private boolean enableLoggingInReplay;
        private List<ContextPropagator> contextPropagators;

        private Builder() {
        }

        public Builder(SingleWorkerOptions options) {
            this.identity = options.getIdentity();
            this.dataConverter = options.getDataConverter();
            this.pollerOptions = options.getPollerOptions();
            this.taskListActivitiesPerSecond = options.getTaskListActivitiesPerSecond();
            this.taskExecutorThreadPoolSize = options.getTaskExecutorThreadPoolSize();
            this.metricsScope = options.getMetricsScope();
            this.enableLoggingInReplay = options.getEnableLoggingInReplay();
            this.contextPropagators = options.getContextPropagators();
        }

        public Builder setIdentity(String identity) {
            this.identity = identity;
            return this;
        }

        public Builder setDataConverter(DataConverter dataConverter) {
            this.dataConverter = dataConverter;
            return this;
        }

        public Builder setTaskExecutorThreadPoolSize(int taskExecutorThreadPoolSize) {
            this.taskExecutorThreadPoolSize = taskExecutorThreadPoolSize;
            return this;
        }

        public Builder setPollerOptions(PollerOptions pollerOptions) {
            this.pollerOptions = pollerOptions;
            return this;
        }

        public Builder setMetricsScope(Scope metricsScope) {
            this.metricsScope = metricsScope;
            return this;
        }

        public Builder setEnableLoggingInReplay(boolean enableLoggingInReplay) {
            this.enableLoggingInReplay = enableLoggingInReplay;
            return this;
        }

        public Builder setTaskListActivitiesPerSecond(double taskListActivitiesPerSecond) {
            this.taskListActivitiesPerSecond = taskListActivitiesPerSecond;
            return this;
        }

        public Builder setContextPropagators(List<ContextPropagator> contextPropagators) {
            this.contextPropagators = contextPropagators;
            return this;
        }

        public SingleWorkerOptions build() {
            if (this.pollerOptions == null) {
                this.pollerOptions = PollerOptions.newBuilder().setPollBackoffInitialInterval(Duration.ofMillis(200L)).setPollBackoffMaximumInterval(Duration.ofSeconds(20L)).setPollThreadCount(1).build();
            }
            if (this.dataConverter == null) {
                this.dataConverter = JsonDataConverter.getInstance();
            }
            if (this.metricsScope == null) {
                this.metricsScope = NoopScope.getInstance();
            }
            return new SingleWorkerOptions(this.identity, this.dataConverter, this.taskExecutorThreadPoolSize, this.taskListActivitiesPerSecond, this.pollerOptions, this.metricsScope, this.enableLoggingInReplay, this.contextPropagators);
        }
    }
}

