/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.worker;

import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class WorkflowRunLockManager {
    private final Lock mapLock = new ReentrantLock();
    private final HashMap<String, CountableLock> perRunLock = new HashMap();

    WorkflowRunLockManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Lock getLockForLocking(String runId) {
        this.mapLock.lock();
        try {
            CountableLock cl = this.perRunLock.get(runId);
            if (cl == null) {
                cl = new CountableLock();
                this.perRunLock.put(runId, cl);
            } else {
                cl.incrementCount();
            }
            Lock lock = cl.getLock();
            return lock;
        }
        finally {
            this.mapLock.unlock();
        }
    }

    void unlock(String runId) {
        this.mapLock.lock();
        try {
            CountableLock cl = this.perRunLock.get(runId);
            if (cl == null) {
                throw new RuntimeException("lock for run " + runId + " does not exist.");
            }
            cl.decrementCount();
            if (cl.getCount() == 0) {
                this.perRunLock.remove(runId);
            }
            cl.getLock().unlock();
        }
        finally {
            this.mapLock.unlock();
        }
    }

    int totalLocks() {
        this.mapLock.lock();
        try {
            int n = this.perRunLock.size();
            return n;
        }
        finally {
            this.mapLock.unlock();
        }
    }

    private static class CountableLock {
        private final Lock lock = new ReentrantLock();
        private int count = 1;

        private CountableLock() {
        }

        void incrementCount() {
            ++this.count;
        }

        void decrementCount() {
            --this.count;
        }

        int getCount() {
            return this.count;
        }

        Lock getLock() {
            return this.lock;
        }
    }
}

