/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.worker;

import com.google.common.base.Preconditions;
import java.time.Duration;

public class WorkerFactoryOptions {
    private static final WorkerFactoryOptions DEFAULT_INSTANCE;
    private static final int DEFAULT_STICKY_POLLER_COUNT = 5;
    private static final int DEFAULT_STICKY_CACHE_SIZE = 600;
    private static final Duration DEFAULT_STICKY_TASK_SCHEDULE_TO_START_TIMEOUT;
    private static final int DEFAULT_MAX_WORKFLOW_THREAD_COUNT = 600;
    private final boolean disableStickyExecution;
    private final int cacheMaximumSize;
    private final int maxWorkflowThreadCount;
    private Duration stickyTaskScheduleToStartTimeout;
    private boolean enableLoggingInReplay;
    private int stickyPollerCount;

    public static Builder newBuilder() {
        return new Builder();
    }

    static WorkerFactoryOptions defaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private WorkerFactoryOptions(boolean disableStickyExecution, int cacheMaximumSize, int maxWorkflowThreadCount, Duration stickyTaskScheduleToStartTimeout, int stickyPollerCount, boolean enableLoggingInReplay) {
        Preconditions.checkArgument((cacheMaximumSize > 0 ? 1 : 0) != 0, (Object)"cacheMaximumSize should be greater than 0");
        Preconditions.checkArgument((maxWorkflowThreadCount > 0 ? 1 : 0) != 0, (Object)"maxWorkflowThreadCount should be greater than 0");
        this.disableStickyExecution = disableStickyExecution;
        this.cacheMaximumSize = cacheMaximumSize;
        this.maxWorkflowThreadCount = maxWorkflowThreadCount;
        this.stickyPollerCount = stickyPollerCount;
        this.enableLoggingInReplay = enableLoggingInReplay;
        this.stickyTaskScheduleToStartTimeout = stickyTaskScheduleToStartTimeout;
    }

    public int getMaxWorkflowThreadCount() {
        return this.maxWorkflowThreadCount;
    }

    public boolean isDisableStickyExecution() {
        return this.disableStickyExecution;
    }

    public int getCacheMaximumSize() {
        return this.cacheMaximumSize;
    }

    public boolean isEnableLoggingInReplay() {
        return this.enableLoggingInReplay;
    }

    public int getStickyPollerCount() {
        return this.stickyPollerCount;
    }

    public Duration getStickyTaskScheduleToStartTimeout() {
        return this.stickyTaskScheduleToStartTimeout;
    }

    static /* synthetic */ Duration access$100() {
        return DEFAULT_STICKY_TASK_SCHEDULE_TO_START_TIMEOUT;
    }

    static {
        DEFAULT_STICKY_TASK_SCHEDULE_TO_START_TIMEOUT = Duration.ofSeconds(5L);
        DEFAULT_INSTANCE = new Builder().build();
    }

    public static class Builder {
        private boolean disableStickyExecution;
        private Duration stickyTaskScheduleToStartTimeout = WorkerFactoryOptions.access$100();
        private int stickyCacheSize = 600;
        private int maxWorkflowThreadCount = 600;
        private boolean enableLoggingInReplay;
        private int stickyPollerCount = 5;

        private Builder() {
        }

        public Builder setDisableStickyExecution(boolean disableStickyExecution) {
            this.disableStickyExecution = disableStickyExecution;
            return this;
        }

        public Builder setStickyCacheSize(int stickyCacheSize) {
            this.stickyCacheSize = stickyCacheSize;
            return this;
        }

        public Builder setMaxWorkflowThreadCount(int maxWorkflowThreadCount) {
            this.maxWorkflowThreadCount = maxWorkflowThreadCount;
            return this;
        }

        public Builder setStickyTaskScheduleToStartTimeout(Duration stickyTaskScheduleToStartTimeout) {
            this.stickyTaskScheduleToStartTimeout = stickyTaskScheduleToStartTimeout;
            return this;
        }

        public Builder setStickyPollerCount(int stickyPollerCount) {
            this.stickyPollerCount = stickyPollerCount;
            return this;
        }

        public Builder setEnableLoggingInReplay(boolean enableLoggingInReplay) {
            this.enableLoggingInReplay = enableLoggingInReplay;
            return this;
        }

        public WorkerFactoryOptions build() {
            return new WorkerFactoryOptions(this.disableStickyExecution, this.stickyCacheSize, this.maxWorkflowThreadCount, this.stickyTaskScheduleToStartTimeout, this.stickyPollerCount, this.enableLoggingInReplay);
        }
    }
}

