/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.iam.domain.app.SysCascade;
import com.digiwin.dap.middleware.iam.domain.org.RequestParameterVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.service.sys.SysQueryService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/boss/v1/app"})
public class AppController {
    @Autowired
    private SysQueryService sysQueryService;
    @Autowired
    private TenantCrudService tenantCrudService;

    @PostMapping(value={""})
    public ResponseEntity<?> getApp(@RequestBody RequestParameterVO requestParameterVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.notNull((Object)requestParameterVO.getTenantSid(), (String)"\u53c2\u6570\u9519\u8bef: tenantSid\u4e0d\u80fd\u4e3a\u7a7a");
        String appId = requestParameterVO.getId();
        long appSid = requestParameterVO.getSid();
        if (appSid == 0L && StringUtils.isEmpty((Object)appId)) {
            throw new IllegalArgumentException("id\u548csid\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(requestParameterVO.getTenantSid().longValue());
        Assert.notNull((Object)tenant, (String)"\u6839\u636etenantSid\u67e5\u8be2\u79df\u6237\u4e3a\u7a7a!");
        SysCascade sysCascade = this.sysQueryService.getSysCascadeBySid(tenant.getSid(), tenant.getId(), appSid, appId, tenant.isDealer(), tenant.isEoc());
        sysCascade.setApps(this.sysQueryService.getPlatFormSysCascadeBySid(tenant.getSid(), tenant.getId(), appSid, appId, tenant.isDealer(), tenant.isEoc()));
        return ResponseEntity.ok((Object)sysCascade);
    }
}

