/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.api;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.iam.domain.form.IntellyExperienceExcelVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyExperiencePageVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyExperienceVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyIdentityVO;
import com.digiwin.dap.middleware.iam.mapper.IntellyMapper;
import com.digiwin.dap.middleware.iam.service.intelly.IntellyService;
import com.github.pagehelper.PageSerializable;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/boss/v1/intelly"})
public class BossIntellyController {
    @Autowired
    private IntellyService intellyService;
    @Autowired
    private IntellyMapper intellyMapper;

    @PostMapping(value={"/identity/confirm"})
    public StdData<?> completeApplicationConfirm(@RequestBody IntellyIdentityVO body) {
        this.intellyService.confirmIdentityApplication(body);
        return StdData.ok().build();
    }

    @PostMapping(value={"/identity/reject"})
    public StdData<?> completeApplicationReject(@RequestBody IntellyIdentityVO body) {
        this.intellyService.rejectIdentityApplication(body);
        return StdData.ok().build();
    }

    @GetMapping(value={"/identity/user/get"})
    public StdData<?> getIntellyIdentityByUserSid(@RequestParam String userId) {
        return StdData.ok((Object)this.intellyService.getIntellyIdentityByUserId(userId));
    }

    @PostMapping(value={"/experience/confirm"})
    public StdData<?> experienceApplicationConfirm(@RequestBody IntellyExperienceVO body) {
        this.intellyService.confirmExperienceApplication(body);
        return StdData.ok().build();
    }

    @PostMapping(value={"/experience/auth"})
    public StdData<?> experienceApplicationAuth(@RequestBody IntellyExperienceVO body) {
        this.intellyService.authExperienceApplication(body);
        return StdData.ok().build();
    }

    @PostMapping(value={"/experience/reject"})
    public StdData<?> experienceApplicationReject(@RequestBody IntellyExperienceVO body) {
        this.intellyService.rejectExperienceApplication(body);
        return StdData.ok().build();
    }

    @PostMapping(value={"/experience/batch/reject"})
    public StdData<?> experienceApplicationBatchReject(@RequestBody List<IntellyExperienceVO> body) {
        this.intellyService.batchRejectExperienceApplication("status", body);
        return StdData.ok().build();
    }

    @PostMapping(value={"/experience/all"})
    public StdData<?> experienceApplicationAdd(@RequestBody IntellyExperiencePageVO body) {
        List resultVOS = this.intellyService.queryOMExperienceApplications(body);
        return StdData.ok((Object)new PageSerializable(resultVOS));
    }

    @PostMapping(value={"/experience/detail"})
    public StdData<?> experienceApplicationDetail(@RequestBody IntellyExperiencePageVO body) {
        return StdData.ok(this.intellyService.queryOMExperienceApplications(body).get(0));
    }

    @PostMapping(value={"/experience/extension/batch/reject"})
    public StdData<?> batchRejectExperienceExtension(@RequestBody List<IntellyExperienceVO> body) {
        this.intellyService.batchRejectExperienceApplication("extensionStatus", body);
        return StdData.ok().build();
    }

    @PostMapping(value={"/experience/extension/reject"})
    public StdData<?> experienceExtensionReject(@RequestBody IntellyExperienceVO body) {
        this.intellyService.rejectExperienceExtension(body);
        return StdData.ok().build();
    }

    @PostMapping(value={"/experience/extension/confirm"})
    public StdData<?> experienceExtensionConfirm(@RequestBody IntellyExperienceVO body) {
        this.intellyService.confirmExperienceExtension(body);
        return StdData.ok().build();
    }

    @PostMapping(value={"/experience/excel/export"})
    public void exportLine(@RequestBody IntellyExperiencePageVO vo, HttpServletResponse response) throws Exception {
        List list = this.intellyMapper.queryOMExperienceApplications(vo);
        List accountOrders = list.stream().map(IntellyExperienceExcelVO::new).collect(Collectors.toList());
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        String fileName = URLEncoder.encode("\u7533\u8bf7\u4f53\u9a8c\u660e\u7ec6", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), IntellyExperienceExcelVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet("Sheet1").doWrite(accountOrders);
    }
}

