/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.api;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.domain.SourceTypeVO;
import com.digiwin.dap.middleware.iam.entity.SourceType;
import com.digiwin.dap.middleware.iam.repository.SourceTypeRepository;
import com.digiwin.dap.middleware.iam.service.source.SourceTypeCrudService;
import com.digiwin.dap.middleware.language.service.LanguageCrudService;
import java.util.HashMap;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Deprecated
@RestController
@RequestMapping(value={"/api/boss/v1/config"})
public class ConfigController {
    @Autowired
    private SourceTypeCrudService sourceTypeCrudService;
    @Autowired
    private SourceTypeRepository sourceTypeRepository;
    @Autowired
    private LanguageCrudService languageCrudService;

    @GetMapping(value={"/source/types"})
    public StdData getSourceTypes() {
        List sourceTypeVOS = this.sourceTypeCrudService.findAllSource();
        return StdData.ok((Object)sourceTypeVOS);
    }

    @PostMapping(value={"/source/type/add"})
    @Transactional(rollbackFor={Exception.class})
    public StdData<?> addSourceTypes(@RequestBody @Valid SourceTypeVO sourceTypeVO) {
        SourceType sourceType = sourceTypeVO.createEntity();
        long sid = this.sourceTypeCrudService.create((BaseEntity)sourceType);
        HashMap<String, String> languageContents = new HashMap<String, String>();
        languageContents.put("zh-CN", sourceType.getName());
        if (!StringUtils.isEmpty((Object)sourceTypeVO.getNameTW())) {
            languageContents.put("zh-TW", sourceTypeVO.getNameTW());
        }
        if (!StringUtils.isEmpty((Object)sourceTypeVO.getNameUS())) {
            languageContents.put("en-US", sourceTypeVO.getNameUS());
        }
        this.languageCrudService.save(sid, "name", languageContents);
        return StdData.ok((Object)sid);
    }

    @PostMapping(value={"/source/type/update"})
    @Transactional(rollbackFor={Exception.class})
    public StdData<?> updateSourceTypes(@RequestBody @Valid SourceTypeVO sourceTypeVO) {
        SourceType sourceType = sourceTypeVO.createEntity();
        this.sourceTypeCrudService.update((BaseEntity)sourceType);
        HashMap<String, String> languageContents = new HashMap<String, String>();
        languageContents.put("zh-CN", sourceType.getName());
        if (!StringUtils.isEmpty((Object)sourceTypeVO.getNameTW())) {
            languageContents.put("zh-TW", sourceTypeVO.getNameTW());
        }
        if (!StringUtils.isEmpty((Object)sourceTypeVO.getNameUS())) {
            languageContents.put("en-US", sourceTypeVO.getNameUS());
        }
        this.languageCrudService.save(sourceType.getSid(), "name", languageContents);
        return StdData.ok((Object)sourceTypeVO.getSid());
    }

    @PostMapping(value={"/source/type/delete"})
    @Transactional(rollbackFor={Exception.class})
    public StdData<?> deleteSourceTypes(@RequestBody SourceTypeVO sourceTypeVO) {
        SourceType sourceType = this.sourceTypeRepository.findById(sourceTypeVO.getId());
        if (sourceType != null) {
            this.sourceTypeCrudService.deleteById(sourceType.getSid());
            this.languageCrudService.deleteByDataSid(sourceType.getSid());
        }
        return StdData.ok((Object)sourceTypeVO.getSid());
    }
}

