/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.tenant.CopyAppAuthVO;
import com.digiwin.dap.middleware.iam.service.WhiteListService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantService;
import java.util.List;
import javax.transaction.Transactional;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ConsoleController {
    @Autowired
    private WhiteListService whiteListService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private TenantService tenantService;

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/api/boss/v1/auth/copy/auth/source/app"})
    public StdData initialize(@RequestBody @Valid CopyAppAuthVO tenantCopyAuthVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        List operations = this.whiteListService.getWhiteList("BOSS_TENANT_OPERATION_ADMINS");
        if (0 == this.envProperties.getCloud() && !operations.isEmpty()) {
            if (operations.contains(authoredUser.getUserId())) {
                this.tenantService.copyAuthFromSourceApp(tenantCopyAuthVO);
            } else {
                throw new BusinessException((ErrorHandler)I18nError.CURRENT_USER_NO_PERMISSION, new Object[]{authoredUser.getUserId()});
            }
        }
        return StdData.ok().build();
    }
}

