/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.api;

import com.digiwin.dap.middleware.boss.domain.TenantParameterVO;
import com.digiwin.dap.middleware.boss.mapper.BossUserMapper;
import com.digiwin.dap.middleware.boss.service.user.UserEmailService;
import com.digiwin.dap.middleware.iam.domain.MessageTargetVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"api/boss/v1/contact"})
public class ContactController {
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private BossUserMapper bossUserMapper;
    @Autowired
    private UserEmailService userEmailService;

    @PostMapping(value={"/emails"})
    public ResponseEntity<?> getEmail(@RequestBody MessageTargetVO target) {
        User user;
        Tenant tenant;
        HashSet<String> emails = new HashSet<String>();
        if (null != target.getTenantId() && null != (tenant = (Tenant)this.tenantCrudService.findById(target.getTenantId())) && null != tenant.getEmail() && tenant.getEmail().contains("@")) {
            emails.add(tenant.getEmail());
        }
        if (null != target.getUserId() && null != (user = (User)this.userCrudService.findById(target.getUserId())) && null != user.getEmail() && user.getEmail().contains("@")) {
            emails.add(user.getEmail());
        }
        if (null != target.getUserSid() && null != (user = (User)this.userCrudService.findBySid(target.getUserSid().longValue())) && null != user.getEmail() && user.getEmail().contains("@")) {
            emails.add(user.getEmail());
        }
        return ResponseEntity.ok(emails);
    }

    @GetMapping(value={"/email/user/{userId:.+}"})
    public ResponseEntity<?> userEmail(@PathVariable(value="userId") String userId) {
        HashSet<String> emails = new HashSet<String>();
        User user = (User)this.userCrudService.findById(userId);
        if (null != user && null != user.getEmail() && user.getEmail().contains("@")) {
            emails.add(user.getEmail());
        }
        return ResponseEntity.ok(emails);
    }

    @GetMapping(value={"/email/tenant/{tenantId:.+}"})
    public ResponseEntity<?> tenantEmail(@PathVariable(value="tenantId") String tenantId) {
        HashSet<String> emails = new HashSet<String>();
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (null != tenant && null != tenant.getEmail() && tenant.getEmail().contains("@")) {
            emails.add(tenant.getEmail());
        }
        return ResponseEntity.ok(emails);
    }

    @PostMapping(value={"/emails/superadmin"})
    public ResponseEntity<?> getTenantsSuperAdminEmail(@RequestBody TenantParameterVO tenantParameterVO) {
        List emailList = new ArrayList();
        if (tenantParameterVO.getTenantIds().size() > 0) {
            emailList = this.userEmailService.getSuperAdminEmail(tenantParameterVO.getTenantIds());
        }
        return ResponseEntity.ok(emailList);
    }

    @GetMapping(value={"/emails/tenant/{tenantId:.+}/superadmin"})
    public ResponseEntity<?> getTenantSuperAdminEmail(@PathVariable(value="tenantId") String tenantId) {
        List emails = new ArrayList();
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (null != tenant) {
            emails = this.userEmailService.getSuperAdminEmail(tenantId);
        }
        return ResponseEntity.ok(emails);
    }
}

