/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.api;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.iam.domain.datapolicy.DataPolicyVO;
import com.digiwin.dap.middleware.iam.domain.permission.DataPermission;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionDataDTO;
import com.digiwin.dap.middleware.iam.entity.DataPolicy;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicyService;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataStatementCrudService;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/boss/v1/datapolicy"})
public class DataPolicyController {
    @Autowired
    private DataPolicyService dataPolicyService;
    @Autowired
    private DataStatementCrudService dataStatementCrudService;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/data"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> updatePolicyData(@RequestBody @Valid DataPolicyVO input) {
        Assert.isTrue((input.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u79df\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.dataPolicyService.updateDataPolicy(input.getTenantSid().longValue(), input);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @GetMapping(value={"/data"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> getDataPolicy(@NotBlank @RequestParam String type, @NotNull @RequestParam Long targetSid, @NotNull @RequestParam Long sysSid, @NotNull @RequestParam Long actionSid, @NotNull @RequestParam Long tenantSid) {
        DataPermission dataPermission = this.dataPolicyService.getDataPolicy(tenantSid.longValue(), type, targetSid.longValue(), sysSid.longValue(), actionSid.longValue(), Boolean.valueOf(false));
        return ResponseEntity.ok((Object)dataPermission);
    }

    @Transactional(rollbackFor={Exception.class})
    @DeleteMapping(value={"/data"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> deleteDataPolicy(@NotBlank @RequestParam String type, @NotNull @RequestParam Long targetSid, @NotNull @RequestParam Long sysSid, @NotNull @RequestParam Long actionSid, @NotNull @RequestParam Long tenantSid) {
        DataPolicy dataPolicy = this.dataPolicyService.getDataPolicy(tenantSid.longValue(), type, targetSid.longValue(), sysSid.longValue());
        if (dataPolicy != null) {
            this.dataStatementCrudService.deleteByUnionKey(new Object[]{dataPolicy.getSid(), actionSid});
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/dev/data"}, produces={"application/json; charset=utf-8"})
    public StdData updateDataPolicyForDev(@RequestBody @Valid PermissionDataDTO dataPolicyDTO) {
        this.dataPolicyService.updateDataPolicyForDev(dataPolicyDTO.getTenantSid(), dataPolicyDTO);
        return StdData.ok().build();
    }
}

