/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.api;

import cn.hutool.core.lang.Assert;
import com.digiwin.dap.middleware.domain.Page;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.domain.dev.DevSysDTO;
import com.digiwin.dap.middleware.iam.domain.dev.DevSysNoDefaultConditionDTO;
import com.digiwin.dap.middleware.iam.domain.dev.DevelopSys;
import com.digiwin.dap.middleware.iam.domain.dev.RemoveDevSysVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.mapper.DevSysMapper;
import com.digiwin.dap.middleware.iam.repository.SysInTenantRepository;
import com.digiwin.dap.middleware.iam.repository.SysRepository;
import com.digiwin.dap.middleware.iam.service.WhiteListService;
import com.digiwin.dap.middleware.iam.service.dev.sys.DevSysService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.github.pagehelper.PageSerializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/boss/v1"})
public class DevSysController {
    @Autowired
    private DevSysMapper devSysMapper;
    @Autowired
    private DevSysService devSysService;
    @Autowired
    private SysInTenantRepository sysInTenantRepository;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private WhiteListService whiteListService;
    @Autowired
    private SysRepository sysRepository;

    @GetMapping(value={"/dev/app"})
    public StdData findDevSyses(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="ds.create_date desc") String orderBy, @RequestParam(name="params", required=false) String params) {
        DevSysDTO devSysDTO = DevSysDTO.getSelf((String)params);
        List devSysVOS = new ArrayList();
        if (devSysDTO != null) {
            devSysVOS = devSysDTO.isLandingApp() ? this.devSysMapper.findLandingSyses(pageNum.intValue(), pageSize.intValue(), orderBy, devSysDTO) : this.devSysMapper.findDevSysList(pageNum.intValue(), pageSize.intValue(), orderBy, devSysDTO);
        }
        PageSerializable result = new PageSerializable(devSysVOS);
        return StdData.ok((Object)result);
    }

    @PostMapping(value={"/dev/app/landing/binding"})
    public StdData bindingLandingSys(@RequestBody DevSysDTO devSysDTO) {
        Assert.notNull((Object)devSysDTO.getSid(), (String)"\u5e94\u7528\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)devSysDTO.getTenantId(), (String)"\u7ed1\u5b9a\u7684\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)devSysDTO.getTenantName(), (String)"\u7ed1\u5b9a\u7684\u79df\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.devSysService.bindingLandingSys(devSysDTO);
        return StdData.ok().build();
    }

    @PostMapping(value={"/dev/app/landing/unbind"})
    public StdData unbindLandingSys(@RequestBody DevSysDTO devSysDTO) {
        Assert.notNull((Object)devSysDTO.getSid(), (String)"\u5e94\u7528\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.devSysService.unbindLandingSys(devSysDTO);
        return StdData.ok().build();
    }

    @PostMapping(value={"/remove/dev"})
    public StdData<?> removeDevSys(@RequestBody RemoveDevSysVO vo) {
        Tenant tenant;
        Assert.notNull((Object)vo.getTenantId(), (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if ("dev".equals(vo.getScenario())) {
            ArrayList<String> appIds = new ArrayList<String>();
            if (StringUtils.hasLength((String)vo.getGoodsCode())) {
                appIds.add(vo.getGoodsCode());
            } else {
                List sysByTenantId = this.devSysMapper.findSysByTenantId(vo.getTenantId(), Integer.valueOf(1));
                appIds.addAll(sysByTenantId.stream().map(DevelopSys::getId).collect(Collectors.toList()));
            }
            appIds.forEach(a -> this.devSysService.deleteIntellySys(a));
        } else if ("auth".equals(vo.getScenario()) && (tenant = (Tenant)this.tenantCrudService.findById(vo.getTenantId())) != null) {
            List byTenantSid = this.sysInTenantRepository.findByTenantSid(tenant.getSid());
            List appIdList = this.whiteListService.getWhiteList("WHITE_LIST_AUTO_AUTH_TENANT_APPS");
            Set defaultSys = this.sysRepository.findByIdIn(appIdList).stream().map(BaseEntity::getSid).collect(Collectors.toSet());
            byTenantSid.removeIf(a -> defaultSys.contains(a.getSysSid()));
            this.sysInTenantRepository.deleteAll((Iterable)byTenantSid);
        }
        return StdData.ok().build();
    }

    @GetMapping(value={"/dev/app/unrestricted"})
    public StdData<?> findDevSysesNoPolicy(DevSysNoDefaultConditionDTO devSysDTO, Page page) {
        List devSysVOS = this.devSysMapper.findDevSysListNonePolicy(page.getPageNum().intValue(), page.getPageSize().intValue(), page.getOrderBy(), devSysDTO);
        return StdData.ok((Object)new PageSerializable(devSysVOS));
    }
}

