/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.boss.service.excel.ExcelDataModelService;
import com.digiwin.dap.middleware.boss.service.excel.ExcelDataService;
import com.digiwin.dap.middleware.boss.service.sys.SysInAuthorService;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.tenant.ImportExcelResultVO;
import com.digiwin.dap.middleware.iam.domain.user.UserConditionVO;
import com.digiwin.dap.middleware.iam.domain.user.UserCorpWechatVO;
import com.digiwin.dap.middleware.iam.service.WhiteListService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.support.excel.IExcelService;
import com.digiwin.dap.middleware.iam.support.excel.ImportUserInfoByExcelService;
import com.digiwin.dap.middleware.iam.support.remote.domain.TenantApplicationVO;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/boss/v1/excel"})
public class ExcelController {
    private static ObjectMapper objectMapper = JsonUtils.createObjectMapper();
    @Autowired
    private SysInAuthorService bossSysQueryService;
    @Autowired
    private ExcelDataService excelDataService;
    @Autowired
    private ExcelDataModelService excelDataModelService;
    @Autowired
    private WhiteListService whiteListService;
    @Autowired
    private IExcelService excelService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private ImportUserInfoByExcelService importUserInfoByExcelService;

    @GetMapping(value={"/tenant/{tenantSid}/user/export"})
    public void userExport(@PathVariable(value="tenantSid") long tenantSid, @RequestParam(name="params", required=false) String params, HttpServletResponse response) throws Exception {
        UserConditionVO userConditionVO = (UserConditionVO)objectMapper.readValue(params, UserConditionVO.class);
        String[] split = userConditionVO.getLanguage().split("-");
        LocaleContextHolder.setLocale((Locale)new Locale(split[0], split[1]));
        List userData = this.excelDataService.getUserData(tenantSid, userConditionVO);
        this.excelDataModelService.getUserExcels(userData, response, tenantSid);
    }

    @GetMapping(value={"/sys/tenant/{tenantSid}/application/export"})
    public void tenantApplicationExport(@PathVariable(value="tenantSid") long tenantSid, @RequestParam(name="params", required=false) String params, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="9999") Integer pageSize, HttpServletResponse response) throws Exception {
        TenantApplicationVO tenantApplicationVO = (TenantApplicationVO)objectMapper.readValue(params, TenantApplicationVO.class);
        String[] split = tenantApplicationVO.getLanguage().split("-");
        LocaleContextHolder.setLocale((Locale)new Locale(split[0], split[1]));
        List tenantApplications = this.bossSysQueryService.getTenantApplicationByTenant(tenantSid, UserUtils.getToken(), tenantApplicationVO, Boolean.valueOf(true), pageSize, pageNum);
        List tenantApplicationExcels = this.excelDataService.getApplicationLanguage(tenantApplications, tenantApplicationVO.getBackModules().booleanValue());
        this.excelDataModelService.getTenantApplicationExcels(tenantApplicationExcels, response, tenantSid, tenantApplicationVO);
    }

    @PostMapping(value={"/tenantid/{tenantId:.+}/user/join/fileid/{fileId}/import"})
    public StdData importUserJoinTenant(@PathVariable String tenantId, @PathVariable String fileId, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        List whiteList = this.whiteListService.getWhiteList("BOSS_TENANT_OPERATION_ADMINS");
        if (0 == this.envProperties.getCloud() && !whiteList.contains(authoredUser.getUserId())) {
            throw new BusinessException((ErrorHandler)I18nError.CURRENT_USER_NO_PERMISSION, new Object[]{authoredUser.getUserId()});
        }
        return StdData.ok((Object)this.excelService.importUserJoinTenant(tenantId, fileId));
    }

    @PostMapping(value={"/tenants/update/{fileId}/import"})
    public StdData batchUpdateTenantInfo(@PathVariable String fileId, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        List whiteList = this.whiteListService.getWhiteList("BOSS_TENANT_OPERATION_ADMINS");
        if (0 == this.envProperties.getCloud() && !whiteList.contains(authoredUser.getUserId())) {
            throw new BusinessException((ErrorHandler)I18nError.CURRENT_USER_NO_PERMISSION, new Object[]{authoredUser.getUserId()});
        }
        return StdData.ok((Object)this.excelService.batchUpdateTenants(fileId));
    }

    @PostMapping(value={"/{tenantId:.+}/fileid/{fileId}"})
    public ResponseEntity<?> importUserInfo(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="fileId") String fileId, @RequestBody(required=false) UserCorpWechatVO userCorpWechatVO) {
        long tenantSid;
        boolean hasCorpWechat = false;
        if (null != userCorpWechatVO) {
            hasCorpWechat = userCorpWechatVO.isHasCorpWechat();
        }
        if ((tenantSid = this.tenantCrudService.getSidById(tenantId)) == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantSid});
        }
        ImportExcelResultVO importExcelResultVO = this.importUserInfoByExcelService.checkAndImportUserExcel(fileId, tenantSid, hasCorpWechat);
        return new ResponseEntity((Object)importExcelResultVO, HttpStatus.OK);
    }
}

