/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.api;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.invoiceinfo.InvoiceInfoVO;
import com.digiwin.dap.middleware.iam.domain.invoiceinfo.InvoiceReceiversVO;
import com.digiwin.dap.middleware.iam.entity.InvoiceInfo;
import com.digiwin.dap.middleware.iam.entity.InvoiceReceivers;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.repository.InvoiceInfoRepository;
import com.digiwin.dap.middleware.iam.service.invoiceinfo.InvoiceInfoCrudService;
import com.digiwin.dap.middleware.iam.service.invoiceinfo.InvoiceInfoService;
import com.digiwin.dap.middleware.iam.service.invoiceinfo.InvoiceReceiversCrudService;
import com.digiwin.dap.middleware.iam.service.invoiceinfo.InvoiceReceiversService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/boss/v1/invoice"})
public class InvoiceManagementController {
    @Autowired
    TenantCrudService tenantCrudService;
    @Autowired
    InvoiceInfoService invoiceInfoService;
    @Autowired
    InvoiceInfoRepository invoiceInfoRepository;
    @Autowired
    InvoiceInfoCrudService invoiceInfoCrudService;
    @Autowired
    InvoiceReceiversService invoiceReceiversService;
    @Autowired
    InvoiceReceiversCrudService invoiceReceiversCrudService;
    @Autowired
    UserCrudService userCrudService;
    @Autowired
    UserInTenantQueryService userInTenantQueryService;

    @PostMapping(value={""})
    public ResponseEntity<?> saveInvoiceInfo(@RequestBody InvoiceInfo invoiceInfo) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(invoiceInfo.getTenantSid().longValue());
        Assert.notNull((Object)tenant, (String)String.format("\u79df\u6237[%s]\u4e0d\u5b58\u5728", invoiceInfo.getTenantSid()));
        if (StringUtils.isEmpty((Object)invoiceInfo.getSid()) || invoiceInfo.getSid() == 0L) {
            if (this.invoiceInfoRepository.existsByTenantSid(invoiceInfo.getTenantSid())) {
                throw new BusinessException((ErrorHandler)I18nError.INVOICE_INFO_HAS_EXIST);
            }
            this.invoiceInfoCrudService.create((BaseEntity)invoiceInfo);
            return ResponseEntity.ok((Object)HttpStatus.OK);
        }
        this.invoiceInfoCrudService.update((BaseEntity)invoiceInfo, true);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @GetMapping(value={"/{tenantSid}"})
    public ResponseEntity<?> getInvoiceInfo(@PathVariable(value="tenantSid") long tenantSid) {
        InvoiceInfo invoiceInfo = this.invoiceInfoRepository.getByTenantSid(Long.valueOf(tenantSid));
        return ResponseEntity.ok((Object)invoiceInfo);
    }

    @GetMapping(value={"/{tenantSid}/containreceiver"})
    public ResponseEntity<?> getInvoiceInfoContainReceiver(@PathVariable(value="tenantSid") long tenantSid) {
        InvoiceInfoVO invoiceInfoVO = this.invoiceInfoService.getInvoiceInfoContainReceiver(tenantSid);
        return ResponseEntity.ok((Object)invoiceInfoVO);
    }

    @PostMapping(value={"/{tenantSid}/receiver"})
    public ResponseEntity<?> saveInvoiceInfo(@PathVariable long tenantSid, @RequestBody InvoiceReceiversVO invoiceReceiversVO) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        Assert.notNull((Object)tenant, (String)String.format("\u79df\u6237[%s]\u4e0d\u5b58\u5728", tenantSid));
        if (!this.invoiceInfoService.checkTenantHavePermission(invoiceReceiversVO.getInvoiceSid().longValue(), tenantSid)) {
            throw new BusinessException((ErrorHandler)I18nError.INVOICE_INFO_NOT_BELONG_TENANT, new Object[]{tenantSid});
        }
        if (StringUtils.isEmpty((Object)invoiceReceiversVO.getSid()) || invoiceReceiversVO.getSid() == 0L) {
            this.invoiceReceiversCrudService.create((BaseEntity)invoiceReceiversVO.generateInvoiceReceivers());
        } else {
            this.invoiceReceiversCrudService.update((BaseEntity)invoiceReceiversVO.generateInvoiceReceivers(), true);
        }
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @GetMapping(value={"/{tenantSid}/{invoiceSid}/receiver"})
    public ResponseEntity<?> getInvoiceReceivers(@PathVariable(value="tenantSid") long tenantSid, @PathVariable long invoiceSid) {
        if (!this.invoiceInfoService.checkTenantHavePermission(invoiceSid, tenantSid)) {
            throw new BusinessException((ErrorHandler)I18nError.INVOICE_INFO_NOT_BELONG_TENANT, new Object[]{tenantSid});
        }
        return ResponseEntity.ok((Object)this.invoiceReceiversService.getInvoiceReceiversVOs(invoiceSid));
    }

    @PostMapping(value={"/{tenantSid}/receiver/{receiverSid}/setpreset"})
    public ResponseEntity<?> setPresetReceiver(@PathVariable long tenantSid, @PathVariable long receiverSid) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        Assert.notNull((Object)tenant, (String)String.format("\u79df\u6237[%s]\u4e0d\u5b58\u5728", tenantSid));
        InvoiceReceivers invoiceReceivers = (InvoiceReceivers)this.invoiceReceiversCrudService.findBySid(receiverSid);
        if (invoiceReceivers == null) {
            throw new BusinessException((ErrorHandler)I18nError.INVOICE_RECEIVERS_NOT_EXISTS, new Object[]{receiverSid});
        }
        if (!this.invoiceInfoService.checkTenantHavePermission(invoiceReceivers.getInvoiceSid(), tenantSid)) {
            throw new BusinessException((ErrorHandler)I18nError.INVOICE_INFO_NOT_BELONG_TENANT, new Object[]{tenantSid});
        }
        this.invoiceReceiversService.setPresetReceiver(receiverSid, invoiceReceivers.getInvoiceSid());
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @PostMapping(value={"/{tenantSid}/receiver/{receiverSid}"})
    public ResponseEntity<?> deleteReceiver(@PathVariable long tenantSid, @PathVariable long receiverSid) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        Assert.notNull((Object)tenant, (String)String.format("\u79df\u6237[%s]\u4e0d\u5b58\u5728", tenantSid));
        InvoiceReceivers invoiceReceivers = (InvoiceReceivers)this.invoiceReceiversCrudService.findBySid(receiverSid);
        if (invoiceReceivers == null) {
            throw new BusinessException((ErrorHandler)I18nError.INVOICE_RECEIVERS_NOT_EXISTS, new Object[]{receiverSid});
        }
        if (!this.invoiceInfoService.checkTenantHavePermission(invoiceReceivers.getInvoiceSid(), tenantSid)) {
            throw new BusinessException((ErrorHandler)I18nError.INVOICE_INFO_NOT_BELONG_TENANT, new Object[]{tenantSid});
        }
        this.invoiceReceiversCrudService.deleteById(receiverSid);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }
}

