/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.domain.migration.MigrateAppVO;
import com.digiwin.dap.middleware.iam.domain.migration.TenantAuthUpgradeDTO;
import com.digiwin.dap.middleware.iam.service.migration.MigrationService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/boss/v2/migration"})
public class MigrationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationController.class);
    private static final List<String> ALLOW_USER_IDS = Arrays.asList("yanyn@digiwin.com", "chenzhuang@digiwin.com", "zhouxiao@digiwin.com");
    @Resource
    private MigrationService migrationService;

    @PostMapping(value={"/app"})
    public StdData<Long> app(@RequestBody MigrateAppVO body) {
        if (!ALLOW_USER_IDS.contains(UserUtils.getUserId())) {
            throw new BusinessException("\u7981\u6b62\u4f7f\u7528");
        }
        this.migrationService.migrateApp(body);
        return StdData.ok().build();
    }

    @PostMapping(value={"/policy"})
    public StdData<Long> policy(@RequestBody MigrateAppVO body) {
        if (!ALLOW_USER_IDS.contains(UserUtils.getUserId())) {
            throw new BusinessException("\u7981\u6b62\u4f7f\u7528");
        }
        this.migrationService.migratePolicy(body);
        return StdData.ok().build();
    }

    @PostMapping(value={"/expire/modules"})
    public StdData<Long> expireOldModules(@RequestBody MigrateAppVO body) {
        if (!ALLOW_USER_IDS.contains(UserUtils.getUserId())) {
            throw new BusinessException("\u7981\u6b62\u4f7f\u7528");
        }
        this.migrationService.expireOldModules(body);
        return StdData.ok().build();
    }

    @PostMapping(value={"/tenant/auth/app"})
    public StdData<?> updateTenantAuthWithApp(@RequestBody TenantAuthUpgradeDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        LOGGER.info("\u5f00\u59cb \u540c\u6b65\u6307\u5b9a\u4e91\u533a\u7684\u79df\u6237\u5e76\u6388\u6743\u6307\u5b9a\u7684\u5e94\u7528\uff0c\u6267\u884c\u4eba = {}\uff0c\u5165\u53c2\n {}", (Object)authoredUser.getUserId(), (Object)dto);
        if (!ALLOW_USER_IDS.contains(authoredUser.getUserId())) {
            throw new BusinessException("\u8fc1\u79fb\u9700\u6c42\u5df2\u5b8c\u6210\uff0c\u7981\u6b62\u4f7f\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u4eba\u5458");
        }
        Assert.hasLength((String)dto.getSourceCloudArea(), (String)"\u6765\u6e90\u4e91\u533a\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasLength((String)dto.getUserToken(), (String)"\u6765\u6e90\u4e91\u533auserToken\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasLength((String)dto.getAppId(), (String)"\u6388\u6743\u7684\u5e94\u7528\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Collection)dto.getTenantIds(), (String)"\u79df\u6237id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        String msg = this.migrationService.updateTenantAuthWithApp(dto);
        LOGGER.info("\u5b8c\u6210 \u540c\u6b65\u6307\u5b9a\u4e91\u533a\u7684\u79df\u6237\u5e76\u6388\u6743\u6307\u5b9a\u7684\u5e94\u7528");
        return StdData.ok((Object)msg);
    }
}

