/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.api;

import com.digiwin.dap.middleware.boss.service.tenant.MultiTenantsService;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.org.RequestParameterVO;
import com.digiwin.dap.middleware.iam.domain.tenant.MultiTenantsVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.TenantMapper;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/boss/v1/multi/tenants"})
public class MultiTenantsController {
    private static final Logger log = LoggerFactory.getLogger(MultiTenantsController.class);
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private TenantQueryService tenantQueryService;
    @Autowired
    private MultiTenantsService multiTenantsService;

    @Transactional(rollbackFor={Exception.class})
    @GetMapping(value={"/{sid}/subtenants"})
    public ResponseEntity<?> getSubTenantBySid(@PathVariable Long sid, @RequestParam(required=false) boolean test) {
        return ResponseEntity.ok((Object)StdData.ok((Object)this.tenantQueryService.findSubTenantBySid(sid.longValue(), test)));
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/{sid}/{sourceTenantSid}"})
    public StdData<?> addSourceTenantSid(@PathVariable(value="sid") long sid, @PathVariable(value="sourceTenantSid") long sourceTenantSid) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(sid);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{sid});
        }
        Tenant sourceTenant = (Tenant)this.tenantCrudService.findBySid(sourceTenantSid);
        if (sourceTenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.SOURCE_TENANT_NOT_EXIST, new Object[]{sourceTenantSid});
        }
        if (tenant.getSourceTenantSid() != 0L) {
            throw new BusinessException((ErrorHandler)I18nError.CURRENT_TENANT_HAS_SOURCE_TENANT, new Object[]{sid, tenant.getSourceTenantSid()});
        }
        this.tenantMapper.addSourceTenantSid(sid, sourceTenantSid);
        return StdData.ok().build();
    }

    @Transactional(rollbackFor={Exception.class})
    @DeleteMapping(value={"/{sid}/sourceTenant"})
    public StdData<?> deleteSourceTenantSid(@PathVariable(value="sid") long sid) {
        this.tenantMapper.deleteSourceTenantSid(sid);
        return StdData.ok().build();
    }

    @GetMapping(value={"/{sid}/check/customerid"})
    public ResponseEntity<?> checkTenantCustomerId(@PathVariable Long sid) {
        return ResponseEntity.ok((Object)StdData.ok((Object)this.tenantQueryService.checkTenantCustomerId(sid.longValue())));
    }

    @PostMapping(value={"/authoriation"})
    public StdData<?> multiTenantsAuthorization(@RequestBody MultiTenantsVO multiTenantsVO) {
        Tenant sourceTenant = (Tenant)this.tenantCrudService.findBySid(multiTenantsVO.getSid().longValue());
        if (sourceTenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.SOURCE_TENANT_NOT_EXIST, new Object[]{multiTenantsVO.getSid()});
        }
        User user = (User)this.userCrudService.findBySid(sourceTenant.getOwnerUserSid());
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{sourceTenant.getOwnerUserSid()});
        }
        this.multiTenantsService.checkMissingPlatform(sourceTenant, user, multiTenantsVO);
        this.multiTenantsService.creatSubTenantsBySource(sourceTenant, user, multiTenantsVO);
        this.multiTenantsService.copyAppAuth(sourceTenant, user, multiTenantsVO);
        this.multiTenantsService.createPendingPreOrders(sourceTenant, user, multiTenantsVO);
        return StdData.ok((Object)StdData.ok().build());
    }

    @GetMapping(value={"/source"})
    public StdData getSourceTenant(@RequestParam(value="tenantId") String tenantId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("existed", false);
        Tenant tenant = this.tenantMapper.findSourceTenant(tenantId);
        if (null != tenant) {
            result.put("existed", true);
            result.put("sid", tenant.getSid());
            result.put("id", tenant.getId());
            result.put("customerId", tenant.getCustomerId());
        }
        return StdData.ok(result);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/authoriation/maxtenantid"})
    public StdData<String> getMaxMultiTenantId(@RequestBody RequestParameterVO requestParameterVO) {
        Integer max = this.multiTenantsService.getMaxSubTenantNumber(requestParameterVO.getTenantSid());
        return StdData.ok((Object)String.format("%03d", max));
    }
}

