/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.api;

import com.digiwin.dap.middleware.boss.service.org.OrgUpdateService;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.OperateException;
import com.digiwin.dap.middleware.iam.domain.org.OrgVO;
import com.digiwin.dap.middleware.iam.entity.OrgType;
import com.digiwin.dap.middleware.iam.service.org.OrgAspectCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgQueryService;
import com.digiwin.dap.middleware.iam.service.org.OrgTypeCrudService;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/boss/v1/orgs"})
public class OrgController {
    @Autowired
    private OrgCatalogCrudService orgCatalogCrudService;
    @Autowired
    private OrgAspectCrudService orgAspectCrudService;
    @Autowired
    private OrgQueryService orgQueryService;
    @Autowired
    private OrgUpdateService bossOrgCrudService;
    @Autowired
    private OrgCrudService orgCrudService;
    @Autowired
    private OrgTypeCrudService orgTypeCrudService;

    @GetMapping(value={"/tenant/{tenantSid}"})
    public ResponseEntity<?> queryOrg(@PathVariable(value="tenantSid") long tenantSid, @RequestParam(value="orgCatalogId") String orgCatalogId, @RequestParam(value="orgAspectId") String orgAspectId) {
        long orgCatalogSid = this.orgQueryService.getCatalogSid(orgCatalogId, tenantSid);
        long orgAspectSid = this.orgQueryService.getAspectSid(tenantSid, orgCatalogSid, orgAspectId);
        List orgResultVOS = this.orgQueryService.getAspect(Long.valueOf(tenantSid), orgAspectSid);
        return ResponseEntity.ok((Object)orgResultVOS);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/tenant/{tenantSid}"})
    public ResponseEntity<?> updateOrg(@PathVariable(value="tenantSid") long tenantSid, @RequestBody OrgVO orgVO) {
        String orgCatalogId = orgVO.getOrgCatalogId();
        long orgCatalogSid = orgVO.getOrgCatalogSid();
        if (StringUtils.isEmpty((Object)orgCatalogId) && orgCatalogSid == 0L) {
            throw new OperateException("orgCatalogId is null or orgCatalogSid is 0");
        }
        if (!StringUtils.isEmpty((Object)orgCatalogId)) {
            orgCatalogSid = this.orgQueryService.getCatalogSid(orgCatalogId, tenantSid);
            orgVO.setOrgCatalogSid(orgCatalogSid);
        }
        String orgAspectId = orgVO.getOrgAspectId();
        long orgAspectSid = orgVO.getOrgAspectSid();
        if (StringUtils.isEmpty((Object)orgAspectId) && orgAspectSid == 0L) {
            throw new OperateException("orgAspectId is null or orgAspectSid is 0");
        }
        if (!StringUtils.isEmpty((Object)orgAspectId)) {
            orgAspectSid = this.orgQueryService.getAspectSid(tenantSid, orgCatalogSid, orgAspectId);
            orgVO.setOrgAspectSid(orgAspectSid);
        }
        String orgTypeId = orgVO.getOrgTypeId();
        long orgTypeSid = orgVO.getOrgTypeSid();
        if (StringUtils.isEmpty((Object)orgTypeId) && orgTypeSid == 0L) {
            throw new OperateException("orgTypeId is null or orgTypeSid is 0");
        }
        if (!StringUtils.isEmpty((Object)orgTypeId)) {
            orgTypeSid = this.getTypeSid(tenantSid, orgCatalogSid, orgTypeId);
            orgVO.setOrgTypeSid(orgTypeSid);
        }
        if (orgVO.getSid() == 0L) {
            long orgSid = this.bossOrgCrudService.addOrg(tenantSid, orgVO);
            return ResponseEntity.ok((Object)orgSid);
        }
        this.bossOrgCrudService.updateOrg(tenantSid, orgVO);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @DeleteMapping(value={"/{orgSid}"})
    public ResponseEntity<?> deleteOrg(@PathVariable(value="orgSid") long orgSid) {
        this.orgCrudService.deleteById(orgSid);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @GetMapping(value={"/cascade/{tenantSid}"})
    public StdData getOrgCascadeInTenant(@PathVariable long tenantSid) {
        Map orgRoleTrees = this.orgQueryService.findOrgRoleTreeByTenantSid(tenantSid);
        return StdData.ok((Object)orgRoleTrees);
    }

    private long getTypeSid(long tenantSid, long orgCatalogSid, String orgTypeId) {
        long sid = 0L;
        if (orgTypeId != null) {
            if (!StringUtil.checkId((String)orgTypeId)) {
                throw new OperateException("orgTypeId\u586b\u5199\u9519\u8bef");
            }
            OrgType orgType = this.orgTypeCrudService.findByUnionKey(tenantSid, orgCatalogSid, orgTypeId);
            if (orgType != null) {
                sid = orgType.getSid();
            } else {
                throw new OperateException("\u6ca1\u6709" + orgTypeId + "\u7ec4\u7ec7\u7c7b\u578b");
            }
        }
        return sid;
    }
}

