/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.api;

import com.digiwin.dap.middleware.boss.service.org.OrgTypeUpdateService;
import com.digiwin.dap.middleware.exception.OperateException;
import com.digiwin.dap.middleware.iam.domain.org.OrgTypeVO;
import com.digiwin.dap.middleware.iam.entity.OrgCatalog;
import com.digiwin.dap.middleware.iam.service.org.OrgCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgTypeCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgTypeQueryService;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/boss/v1/orgTypes"})
public class OrgTypeController {
    @Autowired
    OrgTypeCrudService orgTypeCrudService;
    @Autowired
    OrgCatalogCrudService orgCatalogCrudService;
    @Autowired
    OrgTypeQueryService orgTypeQueryService;
    @Autowired
    OrgTypeUpdateService bossOrgTypeCrudService;

    @GetMapping(value={"/tenant/{tenantSid}"})
    public ResponseEntity<?> getOrgType(@PathVariable(value="tenantSid") long tenantSid, @RequestParam(value="orgCatalogId") String orgCatalogId) {
        long orgCatalogSid = this.getCatalogSid(orgCatalogId, tenantSid);
        List orgTypeResultVOS = this.orgTypeQueryService.findOrgTypeInOrgCatalog(orgCatalogSid);
        return ResponseEntity.ok((Object)orgTypeResultVOS);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/tenant/{tenantSid}"})
    public ResponseEntity<?> updateOrgType(@PathVariable(value="tenantSid") long tenantSid, @RequestBody OrgTypeVO orgTypeVO) {
        String orgCatalogId = orgTypeVO.getOrgCatalogId();
        long orgCatalogSid = orgTypeVO.getOrgCatalogSid();
        if (StringUtils.isEmpty((Object)orgCatalogId) && orgCatalogSid == 0L) {
            throw new OperateException("orgCatalogId is null or orgCatalogSid is 0");
        }
        if (!StringUtils.isEmpty((Object)orgCatalogId)) {
            orgCatalogSid = this.getCatalogSid(orgCatalogId, tenantSid);
            orgTypeVO.setOrgCatalogSid(orgCatalogSid);
        }
        if (orgTypeVO.getSid() == 0L) {
            long orgTypeSid = this.bossOrgTypeCrudService.addOrgType(tenantSid, orgTypeVO);
            return ResponseEntity.ok((Object)orgTypeSid);
        }
        this.bossOrgTypeCrudService.updateOrgType(tenantSid, orgTypeVO);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @DeleteMapping(value={"/{orgTypeSid}"})
    public ResponseEntity<?> deleteOrgType(@PathVariable(value="orgTypeSid") long orgTypeSid) {
        this.orgTypeCrudService.deleteById(orgTypeSid);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    private long getCatalogSid(String orgCatalogId, long tenantSid) {
        long sid = 0L;
        if (orgCatalogId != null) {
            if (!StringUtil.checkId((String)orgCatalogId)) {
                throw new OperateException("catalogId\u586b\u5199\u9519\u8bef");
            }
            OrgCatalog catalog = (OrgCatalog)this.orgCatalogCrudService.findByTenantSidAndId(tenantSid, orgCatalogId);
            if (catalog != null) {
                sid = catalog.getSid();
            } else {
                throw new OperateException("\u6ca1\u6709" + orgCatalogId + "\u7ec4\u7ec7\u5206\u7c7b");
            }
        }
        return sid;
    }
}

