/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.api;

import com.digiwin.dap.middleware.boss.domain.FieldValueTargetVO;
import com.digiwin.dap.middleware.boss.service.metadata.SchemaService;
import com.digiwin.dap.middleware.boss.util.JsonUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionDataDTO;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicySchemaService;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/permission"})
public class PermissionController {
    @Autowired
    private List<SchemaService> schemaServices;
    @Autowired
    private DataPolicySchemaService dataPolicySchemaService;

    @GetMapping(value={"/data/schemas"})
    public ResponseEntity<?> getDataSchemas(@RequestParam String actionId) {
        List schemas = this.dataPolicySchemaService.getSchemas(actionId);
        return ResponseEntity.ok((Object)schemas);
    }

    @Transactional(rollbackFor={Exception.class}, readOnly=true)
    @PostMapping(value={"/data/values"})
    public ResponseEntity<?> getDataValues(@Valid @RequestBody FieldValueTargetVO input) {
        if (input.getParams() == null) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_MISS);
        }
        for (SchemaService schemaService : this.schemaServices) {
            if (!schemaService.support(input.getActionId())) continue;
            return ResponseEntity.ok((Object)schemaService.getValues(input));
        }
        return ResponseEntity.ok(Collections.emptyList());
    }

    @GetMapping(value={"/data/notifier/app"})
    public ResponseEntity<?> getPermission() {
        return ResponseEntity.ok((Object)this.dataPolicySchemaService.getAppsByActionId("boss-message-center", "notifier", "appId", "BOSS", "boss-operations"));
    }

    @PostMapping(value={"/data/app"})
    public StdData<?> getDataApp(@RequestBody PermissionDataDTO permissionDataDTO) {
        return StdData.ok((Object)this.dataPolicySchemaService.getAppsByActionId(permissionDataDTO.getActionId(), permissionDataDTO.getTableId(), permissionDataDTO.getId(), permissionDataDTO.getSysId(), permissionDataDTO.getModuleId()));
    }

    @GetMapping(value={"/data/field"})
    public ResponseEntity<?> getNotifierAppId(@RequestParam String actionId) {
        return ResponseEntity.ok((Object)JsonUtil.getFields());
    }

    @PostMapping(value={"/data"})
    public ResponseEntity saveDataSchemas(@RequestBody List<PermissionDataDTO> schemaDatas) {
        this.dataPolicySchemaService.saveDatas(schemaDatas);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }
}

