/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.api;

import com.digiwin.dap.middle.cache.lock.CacheLock;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.iam.domain.permission.DataPermission;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetPolicy;
import com.digiwin.dap.middleware.iam.entity.Policy;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicyService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyCalcService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyHandleService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/boss/v1/policy"})
public class PolicyController {
    @Autowired
    private PolicyCalcService policyCalcService;
    @Autowired
    private PolicyHandleService policyHandleService;
    @Autowired
    private DataPolicyService dataPolicyService;

    @GetMapping(value={"/action/{tenantSid}"})
    public StdData<?> getPolicyAction(@NotBlank @RequestParam String type, @NotNull @RequestParam Long targetSid, @NotNull @RequestParam Long sysSid, @PathVariable long tenantSid) {
        List lists = this.policyCalcService.getPolicyAction(tenantSid, type, targetSid.longValue(), sysSid.longValue());
        return StdData.ok((Object)lists);
    }

    @GetMapping(value={"/data/{tenantSid}"}, produces={"application/json; charset=utf-8"})
    public StdData<?> getDataPolicy(@NotBlank @RequestParam String type, @NotNull @RequestParam Long targetSid, @NotNull @RequestParam Long sysSid, @NotNull @RequestParam Long actionSid, @PathVariable long tenantSid) {
        DataPermission map = this.dataPolicyService.getDataPolicy(tenantSid, type, targetSid.longValue(), sysSid.longValue(), actionSid.longValue(), Boolean.valueOf(false));
        return StdData.ok((Object)map);
    }

    @GetMapping(value={"/action"})
    public ResponseEntity<?> getPolicyAction(@NotBlank @RequestParam String type, @NotNull @RequestParam Long targetSid, @NotNull @RequestParam Long sysSid, @NotNull @RequestParam Long tenantSid) {
        List lists = this.policyHandleService.getPolicyActionAndModule(tenantSid.longValue(), sysSid.longValue(), targetSid.longValue(), type);
        return ResponseEntity.ok((Object)lists);
    }

    @GetMapping(value={"/action/excluded"})
    public ResponseEntity<?> getPolicyActionExcluded(@NotBlank @RequestParam String type, @NotNull @RequestParam Long targetSid, @NotNull @RequestParam Long sysSid, @NotNull @RequestParam Long tenantSid) {
        List lists = this.policyHandleService.getPolicyActionExcluded(tenantSid, sysSid, targetSid, type);
        return ResponseEntity.ok((Object)lists);
    }

    @CacheLock
    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/action/condition"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> savePolicyActionCondition(@RequestBody @Valid TargetPolicy input) {
        if (input.getTenantSid() == null) {
            input.setTenantSid(input.getTenantSid());
        }
        if (input.getConditionValue() != null && input.getConditionValue().size() > 0) {
            Policy policy = this.policyHandleService.savePolicy(input.getTenantSid().longValue(), input.getSysSid().longValue(), input.getTargetSid().longValue(), input.getType());
            this.policyHandleService.saveConditionValue(policy.getSid(), input);
        }
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @PostMapping(value={"/query/action/condition"}, produces={"application/json; charset=utf-8"})
    public StdData<?> getPolicyActionCondition(@RequestBody @Valid TargetPolicy input) {
        Assert.notNull((Object)input.getTenantSid(), (String)"\u53c2\u6570\u9519\u8bef: tenantSid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)input.getActionSid(), (String)"\u53c2\u6570\u9519\u8bef: actionSid\u4e0d\u80fd\u4e3a\u7a7a");
        this.policyHandleService.queryConditionValue(input);
        return StdData.ok((Object)input);
    }
}

