/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.api;

import com.digiwin.dap.middleware.boss.domain.RoleVO;
import com.digiwin.dap.middleware.boss.domain.UserInRoleExpiredTimeVO;
import com.digiwin.dap.middleware.boss.service.role.RoleInTenantQueryService;
import com.digiwin.dap.middleware.boss.service.role.RoleUpdateService;
import com.digiwin.dap.middleware.boss.service.role.UserInRoleUpdateService;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.OperateException;
import com.digiwin.dap.middleware.iam.entity.RoleCatalog;
import com.digiwin.dap.middleware.iam.service.role.RoleCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleQueryService;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.github.pagehelper.PageSerializable;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/boss/v1/roles"})
public class RoleController {
    @Autowired
    private RoleInTenantQueryService bossRoleQueryService;
    @Autowired
    private RoleUpdateService bossRoleCrudService;
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private RoleCatalogCrudService roleCatalogCrudService;
    @Autowired
    private UserInRoleUpdateService userInRoleUpdateService;
    @Autowired
    private RoleQueryService roleQueryService;
    @Autowired
    private RoleInTenantQueryService roleInTenantQueryService;

    @GetMapping(value={"/tenant/{tenantSid}"})
    public ResponseEntity<?> getRole(@PathVariable(value="tenantSid") long tenantSid, @RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(required=false, value="keyword") String keyword) {
        List roleQueryResultVOS = this.bossRoleQueryService.getRoleByTenant(tenantSid, keyword, pageNum, pageSize);
        PageSerializable pageInfo = new PageSerializable(roleQueryResultVOS);
        return ResponseEntity.ok((Object)pageInfo);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/tenant/{tenantSid}"})
    public ResponseEntity<?> updateRole(@PathVariable(value="tenantSid") long tenantSid, @RequestBody RoleVO roleVO) {
        String roleCatalogId = roleVO.getRoleCatalogId();
        long roleCatalogSid = roleVO.getRoleCatalogSid();
        if (StringUtils.isEmpty((Object)roleCatalogId) && roleCatalogSid == 0L) {
            throw new OperateException("orgCatalogId is null or orgCatalogSid is 0");
        }
        if (!StringUtils.isEmpty((Object)roleCatalogId)) {
            roleCatalogSid = this.getRoleCatalogSid(roleCatalogId, tenantSid);
            roleVO.setRoleCatalogSid(roleCatalogSid);
        }
        if (roleVO.getSid() == 0L) {
            long roleSid = this.bossRoleCrudService.addRole(tenantSid, roleVO);
            return ResponseEntity.ok((Object)roleSid);
        }
        this.bossRoleCrudService.updateRole(tenantSid, roleVO);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @DeleteMapping(value={"/{roleSid}"})
    public ResponseEntity<?> deleteRole(@PathVariable(value="roleSid") long roleSid) {
        this.roleCrudService.deleteById(roleSid);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/tenant/{tenantSid}/userInRoleExpiredTime"})
    public ResponseEntity<?> addExperienceUser(@PathVariable(value="tenantSid") long tenantSid, @RequestBody @Valid UserInRoleExpiredTimeVO userInRoleExpiredTimeVO) {
        this.userInRoleUpdateService.updateUserInRole(userInRoleExpiredTimeVO, tenantSid);
        return new ResponseEntity(HttpStatus.OK);
    }

    @GetMapping(value={"/simple/{tenantSid}"})
    public StdData getRoleInTenant(@PathVariable long tenantSid) {
        return StdData.ok((Object)this.roleQueryService.getRoleQueryResultVosByTenant(tenantSid));
    }

    @PostMapping(value={"/userinrole"})
    public StdData<?> getUserNumber(@RequestBody List<Long> tenantSids) {
        return StdData.ok((Object)this.roleInTenantQueryService.getUserInRoleByTenant(tenantSids));
    }

    private long getRoleCatalogSid(String roleCatalogId, long tenantSid) {
        long sid = 0L;
        if (roleCatalogId != null) {
            if (!StringUtil.checkId((String)roleCatalogId)) {
                throw new OperateException("roleCatalogId\u586b\u5199\u9519\u8bef");
            }
            RoleCatalog roleCatalog = this.roleCatalogCrudService.findByTenantSidAndId(tenantSid, roleCatalogId);
            if (roleCatalog != null) {
                sid = roleCatalog.getSid();
            } else {
                throw new OperateException("\u6ca1\u6709" + roleCatalogId + "\u89d2\u8272\u5206\u7c7b");
            }
        }
        return sid;
    }
}

