/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.boss.service.sys.SysInAuthorService;
import com.digiwin.dap.middleware.boss.service.user.BossUserQueryService;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.IamConstants;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.app.SysCascade;
import com.digiwin.dap.middleware.iam.domain.app.SysQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.app.SysVO;
import com.digiwin.dap.middleware.iam.domain.org.RequestParameterVO;
import com.digiwin.dap.middleware.iam.domain.request.MetaUriRequest;
import com.digiwin.dap.middleware.iam.domain.sys.SysWithPlatformVO;
import com.digiwin.dap.middleware.iam.domain.tenant.SysInTenantTokenVO;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.SysInTenant;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysInTenantQueryService;
import com.digiwin.dap.middleware.iam.service.sys.SysQueryService;
import com.digiwin.dap.middleware.iam.service.sys.SysService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.domain.TenantApplicationVO;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/boss/v1/sys"})
public class SysController {
    private static ObjectMapper objectMapper = JsonUtils.createObjectMapper();
    @Autowired
    private SysService sysService;
    @Autowired
    private CacService cacService;
    @Autowired
    private BossUserQueryService bossUserQueryService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private SysInAuthorService bossSysQueryService;
    @Autowired
    private SysQueryService sysQueryService;
    @Autowired
    private SysInTenantQueryService sysInTenantQueryService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private SysInTenantCrudService sysInTenantCrudService;
    @Autowired
    private SysCrudService sysCrudService;

    @GetMapping(value={"/tenant/{tenantSid}"})
    public ResponseEntity<?> getApplication(@PathVariable(value="tenantSid") long tenantSid, HttpServletRequest request, @RequestParam(required=false, value="params") String params, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="9999") Integer pageSize) {
        String userToken = request.getHeader(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY);
        TenantApplicationVO tenantApplicationVO = null;
        if (!StringUtils.isEmpty((Object)params)) {
            try {
                tenantApplicationVO = (TenantApplicationVO)objectMapper.readValue(params, TenantApplicationVO.class);
            }
            catch (IOException o) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
            }
        }
        List roleQueryResultVOS = this.bossSysQueryService.getTenantApplicationByTenant(tenantSid, userToken, tenantApplicationVO, Boolean.valueOf(false), pageSize, pageNum);
        return ResponseEntity.ok((Object)roleQueryResultVOS);
    }

    @GetMapping(value={"/tenant/{tenantId:.+}/{appId}"})
    public ResponseEntity<?> queryAuthorizedUser(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="appId") String appId) {
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantId});
        }
        List userIds = this.cacService.getAuthorizedUserIds(tenant.getId(), appId);
        List users = this.bossUserQueryService.getUsersWhole(tenant.getSid(), userIds);
        return ResponseEntity.ok((Object)users);
    }

    @PostMapping(value={"/tenant/{tenantId:.+}"})
    public StdData<?> getApp(@RequestBody RequestParameterVO requestParameterVO, @PathVariable String tenantId) {
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        String appId = requestParameterVO.getId();
        long appSid = requestParameterVO.getSid();
        if (appSid == 0L && StringUtils.isEmpty((Object)appId)) {
            throw new IllegalArgumentException("id\u548csid\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        SysCascade sysCascade = this.sysQueryService.getSysCascadeBySid(tenant.getSid(), tenant.getId(), appSid, appId, tenant.isDealer(), tenant.isEoc());
        return StdData.ok((Object)sysCascade);
    }

    @PostMapping(value={"/tree"})
    public StdData<?> getSysTree(@RequestBody RequestParameterVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        SysCascade sysCascade = this.sysQueryService.getSysCascadeById(body.getId());
        sysCascade.getApp().setBackUri(sysCascade.getApp().getMetaUri());
        return StdData.ok((Object)sysCascade);
    }

    @PostMapping(value={"/backuri"})
    public StdData<?> updateBackUri(@RequestBody SysWithPlatformVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        MetaUriRequest data = new MetaUriRequest(body);
        this.sysService.updateMetaUri(data);
        return StdData.ok().build();
    }

    @GetMapping(value={"/getSecretKey"})
    public ResponseEntity<?> getSecretKey(@RequestParam(required=true, value="tenantId") String tenantId, @RequestParam(required=true, value="appId") String sysId) {
        String secretKey = "";
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantId});
        }
        SysQueryResultVO sysVO = this.sysInTenantQueryService.getSysVOByIdAndTenantSid(sysId, tenant.getSid());
        if (null != sysVO) {
            secretKey = sysVO.getSecretKey();
        }
        HashMap<String, String> mapResult = new HashMap<String, String>();
        mapResult.put("secretKey", secretKey);
        return ResponseEntity.ok((Object)StdData.ok(mapResult));
    }

    @GetMapping(value={"/token"})
    public StdData<?> getSysTokenById(@RequestParam(required=true, value="appId") String appId) {
        Sys sys = (Sys)this.sysCrudService.findById(appId);
        return StdData.ok(Optional.ofNullable(sys).map(SysVO::new).orElse(null));
    }

    @GetMapping(value={"/tenant/token/list"})
    public StdData<?> getSysInTenantTokenExpireInfo(@RequestParam(required=true, value="tenantId") String tenantId) {
        if (!this.envProperties.getCustomizeTokenExpired().booleanValue()) {
            return StdData.ok(Collections.emptyList());
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantId});
        }
        List sysInTenantTokenVOList = this.sysInTenantQueryService.getSysInTenantTokenInfo(Long.valueOf(tenant.getSid()), Boolean.valueOf(true));
        return StdData.ok((Object)sysInTenantTokenVOList);
    }

    @PostMapping(value={"tenant/token/info/update"})
    public StdData<?> updateSysInTenantTokenExpireInfo(@RequestBody SysInTenantTokenVO sysInTenantTokenVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        Sys sys = (Sys)this.sysCrudService.findById(sysInTenantTokenVO.getSysId());
        if (sys == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{sysInTenantTokenVO.getSysId()});
        }
        if (!sys.isCustomizeTokenExpired()) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_SUPPORT, new Object[]{sysInTenantTokenVO.getSysId()});
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findById(sysInTenantTokenVO.getTenantId());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{sysInTenantTokenVO.getTenantId()});
        }
        SysInTenant sysInTenant = this.sysInTenantCrudService.findByUnionKey(tenant.getSid(), sys.getSid());
        if (sysInTenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_TENANT_NOT_EXIST, new Object[]{sys.getId(), tenant.getId()});
        }
        if (Objects.isNull(sysInTenantTokenVO.getTokenExpireHours()) || sysInTenantTokenVO.getTokenExpireHours() < IamConstants.TOKEN_MIN_HOURS || sysInTenantTokenVO.getTokenExpireHours() > IamConstants.TOKEN_MAX_HOURS) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
        }
        sysInTenant.setTokenExpire(sysInTenantTokenVO.getTokenExpireHours() * 60L);
        sysInTenant.setTokenExpireAdjusted(true);
        this.sysInTenantCrudService.update((BaseEntity)sysInTenant);
        return StdData.ok().build();
    }
}

