/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.domain.BaseVO;
import com.digiwin.dap.middleware.iam.domain.notice.SysNoticeTypeVO;
import com.digiwin.dap.middleware.iam.domain.notice.SysNoticeVO;
import com.digiwin.dap.middleware.iam.entity.SysNotice;
import com.digiwin.dap.middleware.iam.service.notice.SysNoticeCrudService;
import com.digiwin.dap.middleware.iam.service.notice.SysNoticeTypeCrudService;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/boss/v1/sys/notice"})
public class SysNoticeController {
    @Autowired
    private SysNoticeCrudService sysNoticeCrudService;
    @Autowired
    private SysNoticeTypeCrudService sysNoticeTypeCrudService;

    @PostMapping(value={"/type"})
    public StdData<?> type(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        List noticeTypes = this.sysNoticeTypeCrudService.findAll();
        LinkedList types = new LinkedList();
        noticeTypes.forEach(type -> {
            SysNoticeTypeVO typeVO = new SysNoticeTypeVO();
            typeVO.doBackward(type);
            types.add(typeVO);
        });
        return StdData.ok(types);
    }

    @PostMapping(value={"/add"})
    public StdData<?> add(@RequestBody SysNoticeVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        SysNotice sysNotice = (SysNotice)body.doForward();
        this.sysNoticeCrudService.create((BaseEntity)sysNotice);
        return StdData.ok((Object)sysNotice.getSid());
    }

    @PostMapping(value={"/del"})
    public StdData<?> del(@RequestBody SysNoticeVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        this.sysNoticeCrudService.deleteById(body.getSid().longValue());
        return StdData.ok().build();
    }

    @PostMapping(value={"/mod"})
    public StdData<?> mod(@RequestBody SysNoticeVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        SysNotice sysNotice = (SysNotice)this.sysNoticeCrudService.findBySid(body.getSid().longValue());
        if (sysNotice != null) {
            sysNotice.setEnable(body.getEnable().booleanValue());
            sysNotice.setBackUri(body.getBackUri());
            sysNotice.setPathPrefix(body.getPathPrefix());
            this.sysNoticeCrudService.update((BaseEntity)sysNotice);
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/find"})
    public StdData<?> find(@RequestBody BaseVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        List sysNotices = this.sysNoticeCrudService.findBySysId(body.getId());
        LinkedList notices = new LinkedList();
        sysNotices.forEach(sysNotice -> {
            SysNoticeVO sysNoticeVO = new SysNoticeVO();
            sysNoticeVO.doBackward(sysNotice);
            notices.add(sysNoticeVO);
        });
        return StdData.ok(notices);
    }
}

