/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.api;

import com.digiwin.dap.middleware.auth.AppAuthContext;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.boss.domain.TenantParameterVO;
import com.digiwin.dap.middleware.boss.domain.tenant.TenantConditionVO;
import com.digiwin.dap.middleware.boss.service.tenant.BossTenantQueryService;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.TenantDataExportRecordStateEnum;
import com.digiwin.dap.middleware.iam.constant.enums.TenantEnterpriseTypeEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.authorization.DeletePurchaseGoods;
import com.digiwin.dap.middleware.iam.domain.org.RequestParameterVO;
import com.digiwin.dap.middleware.iam.domain.policy.ConsolePolicyExportScopeVO;
import com.digiwin.dap.middleware.iam.domain.tenant.DevTenantInfoVO;
import com.digiwin.dap.middleware.iam.domain.tenant.InvitedUserVO;
import com.digiwin.dap.middleware.iam.domain.tenant.IsvRelationDevVO;
import com.digiwin.dap.middleware.iam.domain.tenant.QueryWechatTenantVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantAuditVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantCopyVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantCorpConfigDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantExportDataVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantIdRequest;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantInfoVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantMetadataVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantSimpleVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantVO;
import com.digiwin.dap.middleware.iam.domain.tenant.UpdateTenantInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryAuthUserPageVO;
import com.digiwin.dap.middleware.iam.domain.user.UserConditionVO;
import com.digiwin.dap.middleware.iam.domain.usermapping.UserMappingVO;
import com.digiwin.dap.middleware.iam.entity.DevCertificationDO;
import com.digiwin.dap.middleware.iam.entity.IsvRelationDev;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.TenantDataExportRecord;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.TenantMapper;
import com.digiwin.dap.middleware.iam.repository.CertificationRepository;
import com.digiwin.dap.middleware.iam.service.authentication.TenantCertificationCrudService;
import com.digiwin.dap.middleware.iam.service.servicer.ServicerService;
import com.digiwin.dap.middleware.iam.service.tenant.IsvRelationDevCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.PurchaseApplicationService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantAuditService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantDataExportRecordService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantQueryService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantRegisterService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantRelationWithUserService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantService;
import com.digiwin.dap.middleware.iam.service.tenant.UpdateTenantService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataUpdateService;
import com.digiwin.dap.middleware.iam.service.user.UserWholeService;
import com.digiwin.dap.middleware.iam.service.usermapping.UserMappingService;
import com.digiwin.dap.middleware.iam.support.DeferredExecutionService;
import com.digiwin.dap.middleware.iam.support.excel.IExcelService;
import com.digiwin.dap.middleware.iam.support.excel.PermissionExcelService;
import com.digiwin.dap.middleware.iam.support.initialize.TenantInitializeService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.GmcService;
import com.digiwin.dap.middleware.iam.support.remote.MessageService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.Goods;
import com.digiwin.dap.middleware.util.AssertUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageSerializable;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/boss/v1/tenants"})
public class TenantController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantController.class);
    private static final ObjectMapper objectMapper = JsonUtils.createObjectMapper();
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private BossTenantQueryService bossTenantQueryService;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private UpdateTenantService updateTenantService;
    @Autowired
    private TenantCertificationCrudService tenantCertificationCrudService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private TenantQueryService tenantQueryService;
    @Autowired
    private TenantRelationWithUserService tenantRelationWithUserService;
    @Autowired
    private PurchaseApplicationService purchaseApplicationService;
    @Autowired
    private IsvRelationDevCrudService isvRelationDevCrudService;
    @Autowired
    private GmcService gmcService;
    @Autowired
    private TenantMetadataUpdateService tenantMetadataUpdateService;
    @Autowired
    private TenantDataExportRecordService tenantDataExportRecordService;
    @Autowired
    private IExcelService excelService;
    @Autowired
    private DMC dmcClient;
    @Autowired
    private RemoteEocService remoteEocService;
    @Autowired
    private ChangeLogService changeLogService;
    @Autowired
    private ServicerService servicerService;
    @Autowired
    private UserMappingService userMappingService;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private CacService cacService;
    @Autowired
    private UserWholeService userWholeService;
    @Autowired
    private CertificationRepository certificationRepository;
    @Autowired
    private TenantAuditService tenantAuditService;
    @Autowired
    private TenantRegisterService tenantRegisterService;
    @Autowired
    private PermissionExcelService permissionExcelService;
    @Autowired
    private TenantInitializeService tenantInitializeService;
    @Autowired
    private DeferredExecutionService deferredExecutionService;

    @GetMapping(value={""})
    public ResponseEntity<?> getTenant(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(name="orderBy", defaultValue="t.create_date desc") String orderBy, @RequestParam(required=false, value="params") String params) {
        TenantConditionVO tenantConditionVO = null;
        if (!StringUtils.isEmpty((Object)params)) {
            try {
                tenantConditionVO = (TenantConditionVO)objectMapper.readValue(params, TenantConditionVO.class);
            }
            catch (IOException o) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
            }
        }
        if (!Objects.isNull(tenantConditionVO) && !CollectionUtils.isEmpty((Collection)tenantConditionVO.getComeFrom()) && tenantConditionVO.getComeFrom().contains("DigiwinCloud")) {
            tenantConditionVO.setContainsFromDigiwin(Boolean.valueOf(true));
        }
        if (!Objects.isNull(tenantConditionVO) && CollectionUtils.isEmpty((Collection)tenantConditionVO.getDevApps())) {
            tenantConditionVO.setDevApps(new ArrayList<String>(Arrays.asList("DAP", "athena-lcdp")));
        }
        List tenantVOS = this.bossTenantQueryService.getBossTenantQueryVos(tenantConditionVO, pageNum, pageSize, orderBy);
        PageSerializable pageInfo = new PageSerializable(tenantVOS);
        return ResponseEntity.ok((Object)pageInfo);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/{tenantSid}/isconfirm"})
    public ResponseEntity<?> audit(@PathVariable(value="tenantSid") long tenantSid) {
        this.tenantService.confirm(tenantSid);
        return new ResponseEntity(HttpStatus.OK);
    }

    @GetMapping(value={"/{tenantSid}"})
    public ResponseEntity<?> getTenantInfo(@PathVariable(value="tenantSid") long tenantSid) {
        com.digiwin.dap.middleware.boss.domain.tenant.TenantInfoVO tenantInfoVO = this.bossTenantQueryService.getTenantInfoBySid(tenantSid);
        return ResponseEntity.ok((Object)tenantInfoVO);
    }

    @GetMapping(value={"/{tenantSid}/tenantcertification/check"})
    public ResponseEntity<?> checkTenantCertification(@PathVariable Long tenantSid) {
        return ResponseEntity.ok((Object)this.tenantCertificationCrudService.existsByTenantSid(tenantSid.longValue()));
    }

    @GetMapping(value={"/matching"})
    public ResponseEntity<?> getTenants(@RequestParam(required=false, value="tenantName") String tenantName, @RequestParam(required=false, value="customerId") String customerId) {
        List tenantInfoVOS = this.bossTenantQueryService.getTenantVos(tenantName, customerId);
        return ResponseEntity.ok((Object)tenantInfoVOS);
    }

    @GetMapping(value={"/app/{appId}"})
    public ResponseEntity<?> getTenantsInApp(@PathVariable(value="appId") String appId, @RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(required=false, value="excludeExpiredTenant") boolean excludeExpiredTenant, @RequestParam(required=false, value="strategySid") Long strategySid, @RequestParam(required=false, value="tenantContent") String tenantContent) {
        PageSerializable pageSerializable = this.bossTenantQueryService.getBossTenantByAppId(tenantContent, appId, pageNum, pageSize, excludeExpiredTenant, strategySid);
        return ResponseEntity.ok((Object)pageSerializable);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={""})
    public ResponseEntity<?> update(@RequestBody UpdateTenantInfoVO updateTenantInfoVO) {
        this.updateTenantService.update(updateTenantInfoVO);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/change/creator"})
    public ResponseEntity<?> updateTenantCreator(@RequestBody UpdateTenantInfoVO updateTenantInfoVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(updateTenantInfoVO.getSid());
        long oldOwnerSid = tenant.getOwnerUserSid();
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{updateTenantInfoVO.getSid()});
        }
        this.updateTenantService.updateTenantCreator(updateTenantInfoVO);
        this.messageService.sendUpdateTenantCreator(updateTenantInfoVO.getSid(), updateTenantInfoVO.getEmail(), authoredUser.getUserId(), Long.valueOf(oldOwnerSid), null, "old");
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/id/check/mod"})
    public StdData<?> updateTenantId(@RequestBody TenantIdRequest req, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        AssertUtils.paramNotNull((Object)req.getSid(), (String)"sid");
        AssertUtils.paramHasText((String)req.getId(), (String)"id");
        LOGGER.info("\u7528\u6237[{}]\u4fee\u6539\u79df\u6237id, \u79df\u6237sid={}, \u65b0\u79df\u6237id={}", new Object[]{authoredUser.getUserId(), req.getSid(), req.getId()});
        this.tenantService.updateTenantId(req.toDTO());
        return StdData.ok().build();
    }

    @GetMapping(value={"/dev/{tenantSid}"})
    public StdData getDevTenantInfo(@PathVariable(value="tenantSid") long tenantSid) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantSid});
        }
        DevTenantInfoVO devTenantInfoVO = this.tenantQueryService.findTenantInfo(tenantSid);
        return StdData.ok((Object)devTenantInfoVO);
    }

    @PutMapping(value={"/dev"})
    public StdData updateDevTenantInfo(@RequestBody DevTenantInfoVO devTenantInfoVO) {
        Assert.notNull((Object)devTenantInfoVO.getSid(), (String)"\u79df\u6237sid\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Long tenantSid = this.updateTenantService.updateDevTenantInfo(devTenantInfoVO);
        return StdData.ok((Object)tenantSid);
    }

    @PostMapping(value={"/clear/warehouse"})
    public StdData<?> clearWarehouse(@RequestBody DevTenantInfoVO devTenantInfoVO) {
        DevCertificationDO devCertificationDO = this.certificationRepository.findByTenantSid(devTenantInfoVO.getSid().longValue());
        if (devCertificationDO != null) {
            devCertificationDO.setWarehouseAccount(null);
            devCertificationDO.setWarehousePassword(null);
            devCertificationDO.setWarehouseProjectName(null);
            this.certificationRepository.save((Object)devCertificationDO);
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/dev"})
    public StdData createDevTenantInfo(@RequestBody DevTenantInfoVO devTenantInfoVO) {
        Assert.notNull((Object)devTenantInfoVO.getSid(), (String)"\u79df\u6237sid\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Long tenantSid = this.updateTenantService.updateDevTenantInfo(devTenantInfoVO);
        this.servicerService.confirmServicer(devTenantInfoVO.getServicer());
        return StdData.ok((Object)tenantSid);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/{tenantSid}/agree/apply"})
    public ResponseEntity<?> agreeUserApply(@PathVariable Long tenantSid, @RequestBody InvitedUserVO body) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid.longValue());
        if (null == tenant) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantSid});
        }
        List authorizationFailureApps = this.tenantRelationWithUserService.tenantAgreeApply(tenant, body);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (authorizationFailureApps.size() > 0) {
            result.put("success", false);
            result.put("authorizationFailureApps", authorizationFailureApps);
        } else {
            result.put("success", true);
        }
        return ResponseEntity.ok(result);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/delete/purchase/goods"})
    public StdData deletePurchaseGoods(@RequestBody DeletePurchaseGoods body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        body.setUserId(authoredUser.getUserId());
        body.setUserName(authoredUser.getUserName());
        body.setDeleteDate(LocalDateTime.now());
        body.setCode(body.getGoodsCode());
        this.purchaseApplicationService.deletePurchaseGoods(body);
        return StdData.ok().build();
    }

    @DeleteMapping(value={"/remove"})
    public StdData removeTenant(@RequestBody TenantParameterVO tenantParameterVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Tenant tenant;
        LOGGER.info("\u5220\u9664\u6307\u5b9a\u79df\u6237[{}]\uff0c\u64cd\u4f5c\u4eba=[{}]", (Object)tenantParameterVO.getTenantId(), (Object)authoredUser.getUserId());
        if (!StringUtils.isEmpty((Object)tenantParameterVO.getTenantId()) && null != (tenant = (Tenant)this.tenantCrudService.findById(tenantParameterVO.getTenantId()))) {
            this.tenantService.delete(tenant);
        }
        return StdData.ok().build();
    }

    @GetMapping(value={"/isv/dev"})
    public StdData<?> getDevByIsvTenantSid(@RequestParam long isvTenantSid, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Tenant isvTenant = (Tenant)this.tenantCrudService.findBySid(isvTenantSid);
        Assert.notNull((Object)isvTenant, (String)"\u670d\u52a1\u5546\u4e0d\u5b58\u5728");
        List isvRelationDevVOList = this.isvRelationDevCrudService.queryDevInfoByIsvTenantSid(isvTenantSid);
        List devTenantIds = isvRelationDevVOList.stream().map(IsvRelationDevVO::getDevTenantId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(devTenantIds)) {
            List goodsList = this.gmcService.getDevIsvGoods(devTenantIds, isvTenant.getId());
            Map<String, List<Goods>> goodMap = goodsList.stream().collect(Collectors.groupingBy(Goods::getDevId));
            isvRelationDevVOList.stream().forEach(isvRelationDevVO -> {
                if (goodMap.containsKey(isvRelationDevVO.getDevTenantId())) {
                    isvRelationDevVO.setGoodsList((List)goodMap.get(isvRelationDevVO.getDevTenantId()));
                }
            });
        }
        return StdData.ok((Object)isvRelationDevVOList);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/isv/dev"})
    public StdData<?> saveDevIsvRelation(@RequestBody IsvRelationDevVO isvRelationDevVO) {
        ArrayList isvRelationDevList = new ArrayList();
        isvRelationDevVO.getDevTenantSids().stream().distinct().forEach(devTenantSid -> {
            IsvRelationDev isvRelationDev = new IsvRelationDev();
            com.digiwin.dap.middleware.commons.util.BeanUtils.mergeDifferentTypeObject((Object)isvRelationDevVO, (Object)isvRelationDev);
            isvRelationDev.setDevTenantSid(devTenantSid);
            if (this.isvRelationDevCrudService.existsByIsvTenantSidAndDevTenantSid(isvRelationDev.getIsvTenantSid().longValue(), isvRelationDev.getDevTenantSid().longValue())) {
                throw new BusinessException((ErrorHandler)I18nError.ISV_DEV_RELA_EXISTED_ERROR);
            }
            isvRelationDevList.add(isvRelationDev);
        });
        this.isvRelationDevCrudService.saveAll(isvRelationDevList);
        return StdData.ok().build();
    }

    @Transactional(rollbackFor={Exception.class})
    @DeleteMapping(value={"/isv/dev/{isvTenantSid}/{devTenantSid}"})
    public StdData<?> removeDevIsvRelation(@PathVariable Long isvTenantSid, @PathVariable Long devTenantSid) {
        this.isvRelationDevCrudService.deleteByIsvTenantSidAndDevTenantSid(isvTenantSid.longValue(), devTenantSid.longValue());
        return StdData.ok().build();
    }

    @PostMapping(value={"/copy"})
    public StdData<?> copyTenant(@RequestBody @Valid com.digiwin.dap.middleware.boss.domain.tenant.TenantInfoVO tenantInfoVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantInfoVO.getSourceTenantSid());
        if (null == tenant) {
            throw new BusinessException((ErrorHandler)I18nError.SOURCE_TENANT_NOT_EXIST, new Object[]{tenantInfoVO.getSourceTenantSid()});
        }
        if (!tenant.isTestTenant()) {
            throw new BusinessException((ErrorHandler)I18nError.SOURCE_TENANT_NOT_TEST, new Object[]{tenant.getId()});
        }
        if (!TenantEnterpriseTypeEnum.contains((Integer)tenant.getEnterpriseType())) {
            throw new BusinessException((ErrorHandler)I18nError.SOURCE_TENANT_NOT_ENTERPRISE, new Object[]{tenant.getId()});
        }
        Tenant copyTenant = (Tenant)this.tenantCrudService.findById(tenantInfoVO.getId());
        if (null != copyTenant) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_HAS_EXIST, new Object[]{tenantInfoVO.getId()});
        }
        copyTenant = new Tenant();
        BeanUtils.copyProperties((Object)tenant, (Object)copyTenant);
        copyTenant.setId(tenantInfoVO.getId());
        copyTenant.setName(tenantInfoVO.getName());
        copyTenant.setExplain(tenantInfoVO.getExplain());
        return StdData.ok((Object)this.tenantService.copy(tenant, copyTenant));
    }

    @PostMapping(value={"/basicdata/copy"})
    public StdData<?> copyTenantBasicData(@RequestBody @Valid TenantCopyVO vo) {
        return StdData.ok((Object)this.tenantService.copyTenantBasicData(vo));
    }

    @PostMapping(value={"/metadata/corpid"})
    public StdData updateTenantMetadataCorpId(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody TenantMetadataVO body) {
        Assert.notNull((Object)body.getTenantSid(), (String)"\u79df\u6237sid\u4e0d\u80fd\u4e3a\u7a7a");
        this.tenantMetadataUpdateService.updateTenantMetadataCorpId(body.getTenantSid().longValue(), body.getCatalogId(), body.getKey(), body.getValue());
        return StdData.ok().build();
    }

    @PostMapping(value={"/permission/export/query"})
    public StdData<?> queryPermissionExportRecord(@RequestBody TenantExportDataVO tenantExportDataVO) {
        List records = this.tenantDataExportRecordService.queryPermissionExportRecord(tenantExportDataVO);
        PageSerializable result = new PageSerializable(records);
        return StdData.ok((Object)result);
    }

    @PostMapping(value={"/data/export/query"})
    public StdData<?> queryExportTenantData(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody TenantExportDataVO tenantExportDataVO) {
        List records = this.tenantDataExportRecordService.queryTenantDataExportRecordList(tenantExportDataVO);
        PageSerializable result = new PageSerializable(records);
        return StdData.ok((Object)result);
    }

    @PostMapping(value={"/data/export"})
    public StdData<?> exportTenantData(@RequestBody TenantExportDataVO tenantExportDataVO) {
        String url = "";
        TenantDataExportRecord tenantDataExportRecord = (TenantDataExportRecord)this.tenantDataExportRecordService.findBySid(tenantExportDataVO.getDataSid().longValue());
        try {
            List userFileInfos;
            File roleFile;
            File orgFile;
            File userFile;
            List fileList;
            if (tenantDataExportRecord.getUser().booleanValue() && (fileList = Stream.of(userFile = this.excelService.exportUserInfo(Long.valueOf(tenantDataExportRecord.getTenantSid())), orgFile = this.excelService.exportUserOrgInfo(Long.valueOf(tenantDataExportRecord.getTenantSid())), roleFile = this.excelService.exportUserRoleInfo(Long.valueOf(tenantDataExportRecord.getTenantSid()))).filter(Objects::nonNull).collect(Collectors.toList())) != null && fileList.size() > 0 && null != (userFileInfos = this.dmcClient.batchUpload(fileList)) && userFileInfos.size() > 0) {
                url = userFileInfos.stream().map(com.digiwin.dap.middleware.dmc.model.BaseEntity::getId).collect(Collectors.joining(","));
            }
            if (tenantDataExportRecord.getEoc().booleanValue()) {
                String eocFileIds = this.remoteEocService.exportAllInfo(Long.valueOf(tenantDataExportRecord.getTenantSid()), AppAuthContextHolder.getContext().getAuthoredUser().getToken());
                url = !StringUtils.isEmpty((Object)url) ? url + "," + eocFileIds : eocFileIds;
            }
            if (StringUtils.hasLength((String)tenantDataExportRecord.getExportParams())) {
                ConsolePolicyExportScopeVO vo = (ConsolePolicyExportScopeVO)JsonUtils.jsonToObj((String)tenantDataExportRecord.getExportParams(), ConsolePolicyExportScopeVO.class);
                url = this.permissionExcelService.exportPermission(vo);
            }
            tenantDataExportRecord.setUrl(url);
            tenantDataExportRecord.setExpireDate(LocalDateTime.now().plusDays(3L));
            tenantDataExportRecord.setState(TenantDataExportRecordStateEnum.COMPLETED.getValue().intValue());
            this.tenantDataExportRecordService.update((BaseEntity)tenantDataExportRecord);
            this.changeLogService.saveTenantExportDataChangeLogs(tenantDataExportRecord, "\u751f\u6210\u6210\u529f", Boolean.valueOf(true));
        }
        catch (Exception e) {
            this.changeLogService.saveTenantExportDataChangeLogs(tenantDataExportRecord, "\u751f\u6210\u5931\u8d25", Boolean.valueOf(false));
            tenantDataExportRecord.setState(TenantDataExportRecordStateEnum.FAILED.getValue().intValue());
            this.tenantDataExportRecordService.update((BaseEntity)tenantDataExportRecord);
            throw new BusinessException((ErrorHandler)I18nError.EXPORT_FAILED);
        }
        return StdData.ok((Object)url);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/tenant/user/auth"})
    public StdData registerByEmail(@RequestBody UserConditionVO userConditionVO) {
        if (StringUtils.isEmpty((Object)userConditionVO.getEmail()) && StringUtils.isEmpty((Object)userConditionVO.getTelephone())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_4);
        }
        if (StringUtils.isEmpty((Object)userConditionVO.getTenantId())) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_NOT_NULL);
        }
        if (StringUtils.isEmpty((Object)userConditionVO.getAppId())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_5, new Object[]{userConditionVO.getEmail(), userConditionVO.getTelephone()});
        }
        if ((userConditionVO.getTenantAuth() == null || !userConditionVO.getTenantAuth().booleanValue()) && StringUtils.isEmpty((Object)userConditionVO.getStrategyCode())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_8, new Object[]{userConditionVO.getAppId()});
        }
        this.tenantService.authApp(userConditionVO);
        return StdData.ok((Object)true);
    }

    @PostMapping(value={"/mapping/query"})
    public ResponseEntity<?> queryMappedUserByCondition(@RequestBody UserMappingVO userMappingVO) {
        if (null == userMappingVO.getTenantSid() || 0L == userMappingVO.getTenantSid()) {
            throw new IllegalArgumentException("tenantSid is null");
        }
        Long tenantSid = userMappingVO.getTenantSid();
        PageSerializable page = PageHelper.startPage((int)userMappingVO.getPageNum(), (int)userMappingVO.getPageSize(), (String)userMappingVO.getOrderBy()).doSelectPageSerializable(() -> this.userMappingService.getMappedByCondition(tenantSid.longValue(), userMappingVO));
        return ResponseEntity.ok((Object)page);
    }

    @PostMapping(value={"/simple"})
    public ResponseEntity<?> getTenantSimple(@RequestBody RequestParameterVO body) {
        if (!com.digiwin.dap.middleware.util.StringUtils.hasText((String)UserUtils.getTenantId())) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_NO_TENANT_PERMISSION_ERROR);
        }
        TenantInfoVO tenant = this.tenantQueryService.getTenantSimpleInfo(body.getId());
        return ResponseEntity.ok((Object)tenant);
    }

    @GetMapping(value={"/metadata/corpid/appconfig/exist"})
    public StdData<?> getTenantCorpIdAndAppConfig(@RequestParam(name="tenantId", required=false) String tenantId) {
        try {
            Assert.hasText((String)tenantId, (String)"tenantId\u4e0d\u80fd\u4e3a\u7a7a");
            Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
            if (null == tenant) {
                throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantId});
            }
            TenantCorpConfigDTO corpIdAndAppConfig = this.tenantQueryService.getTenantCorpIdAndAppConfig(tenant.getSid());
            return StdData.ok((Object)corpIdAndAppConfig);
        }
        catch (Exception ex) {
            return StdData.of((int)500, (String)ex.getMessage());
        }
    }

    @GetMapping(value={"/{tenantSid}/user/apply/query"})
    public ResponseEntity<?> queryNoConfirmAppliedByTenantSid(@PathVariable(value="tenantSid") long tenantSid) {
        List userList = this.tenantRelationWithUserService.tenantGetUnConfirmApplyList(tenantSid);
        return ResponseEntity.ok((Object)userList);
    }

    @GetMapping(value={"/{tenantSid}/user/invite/query"})
    public ResponseEntity<?> queryInvitedByTenantSid(@PathVariable(value="tenantSid") long tenantSid) {
        List userList = this.tenantRelationWithUserService.tenantGetUserList("invited", tenantSid);
        return ResponseEntity.ok((Object)userList);
    }

    @PostMapping(value={"/simples"})
    public StdData<List<TenantSimpleVO>> getTenantSimple(@RequestBody List<String> tenantIds) {
        if (tenantIds.isEmpty()) {
            return StdData.ok(new ArrayList());
        }
        return StdData.ok((Object)this.tenantMapper.findTenantsSimpleByIds(tenantIds));
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/user/invite"})
    public ResponseEntity<?> invitedUserJoinTenant(@RequestBody InvitedUserVO body) {
        if (ObjectUtils.isEmpty((Object)body.getUser())) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_INVITED_USER_EMPTY);
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findById(body.getTenantId());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_INVITED_USER_TENANT_EXISTED, new Object[]{body.getTenantId()});
        }
        AppAuthContext context = AppAuthContextHolder.getContext();
        if (this.envProperties.isAli()) {
            context.getAuthoredUser().setUserName("\u9f0e\u6377\u4e91");
        } else {
            context.getAuthoredUser().setUserName("\u9f0e\u6377\u96f2");
        }
        Long sid = this.tenantRelationWithUserService.invitedUserJoin(tenant.getSid(), body, Boolean.valueOf(false));
        return ResponseEntity.ok((Object)sid);
    }

    @PostMapping(value={"/authorized/user"})
    public StdData<?> queryAuthorizedUserPage(@RequestBody QueryAuthUserPageVO body) {
        Tenant tenant = (Tenant)this.tenantCrudService.findById(body.getTenantId());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_INVITED_USER_TENANT_EXISTED, new Object[]{body.getTenantId()});
        }
        List userIds = this.cacService.getAuthedUserInfo(tenant.getId(), body.getAppId());
        PageSerializable users = this.userWholeService.getAuthUsers(tenant.getSid(), userIds, body);
        return StdData.ok((Object)users);
    }

    @PostMapping(value={"/user/auth"})
    public StdData<?> queryUserWithAuthPage(@RequestBody QueryAuthUserPageVO body) {
        Tenant tenant = (Tenant)this.tenantCrudService.findById(body.getTenantId());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_INVITED_USER_TENANT_EXISTED, new Object[]{body.getTenantId()});
        }
        PageSerializable users = this.userWholeService.getUsersWithAuth(tenant.getSid(), body);
        return StdData.ok((Object)users);
    }

    @PostMapping(value={"/wechat/search"})
    public StdData<?> searchWechatTenant(@RequestBody QueryWechatTenantVO queryWechatTenantVO) {
        PageSerializable tenantList = this.tenantService.findWechatTenant(queryWechatTenantVO);
        return StdData.ok((Object)tenantList);
    }

    @PostMapping(value={"/confirm"})
    public StdData confirmTenant(@RequestBody @Valid TenantAuditVO tenantAuditVO) {
        long sid = tenantAuditVO.getSid();
        if (sid == 0L) {
            throw new IllegalArgumentException("sid is 0");
        }
        this.tenantAuditService.confirm(tenantAuditVO);
        this.messageService.sendConfirmSuccessMessage(tenantAuditVO);
        return StdData.ok().build();
    }

    @Transactional
    @PostMapping(value={"/isv/confirm"})
    public StdData confirmIsvTenant(@RequestBody @Valid TenantAuditVO tenantAuditVO) {
        long sid = tenantAuditVO.getSid();
        if (sid == 0L) {
            throw new IllegalArgumentException("sid is 0");
        }
        tenantAuditVO.setIsvFlag(true);
        this.tenantAuditService.confirm(tenantAuditVO);
        this.tenantAuditService.confirmIsv(tenantAuditVO);
        this.deferredExecutionService.runAfterCommitAsync(() -> this.tenantInitializeService.syncTenantToOtherAreas(Long.valueOf(sid), null));
        this.messageService.sendConfirmSuccessMessage(tenantAuditVO);
        return StdData.ok().build();
    }

    @Transactional
    @PostMapping(value={"/isv/refuse"})
    public StdData refuseISVTenant(@RequestBody @Valid TenantAuditVO tenantAuditVO) {
        long sid = tenantAuditVO.getSid();
        if (sid == 0L) {
            throw new IllegalArgumentException("sid is 0");
        }
        this.tenantAuditService.disConfirm(tenantAuditVO);
        this.tenantAuditService.disConfirmIsv(tenantAuditVO);
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(sid);
        this.messageService.sendIsvRejectMail(tenant, tenantAuditVO.getExplain());
        return StdData.ok().build();
    }

    @PostMapping(value={"/refuse"})
    public StdData refuseTenant(@RequestBody @Valid TenantAuditVO tenantAuditVO) {
        long sid = tenantAuditVO.getSid();
        if (sid == 0L) {
            throw new IllegalArgumentException("sid is 0");
        }
        this.tenantAuditService.disConfirm(tenantAuditVO);
        this.messageService.sendConfirmFailMessage(tenantAuditVO);
        return StdData.ok().build();
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/register/individual"})
    public ResponseEntity<?> registerIndividualTenant(@RequestBody TenantVO tenantVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.notNull((Object)tenantVO.getName(), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)tenantVO.getEmail(), (String)"email\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)tenantVO.getAddress(), (String)"\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)tenantVO.getUserId(), (String)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)tenantVO.getUserSid(), (String)"\u7528\u6237sid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (!User.isADAccount((String)tenantVO.getUserId())) {
            Assert.notNull((Object)tenantVO.getTelephone(), (String)"\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        long tenantSid = this.tenantRegisterService.registerIndividualTenant(tenantVO.getUserSid().longValue(), tenantVO.getUserId(), tenantVO);
        return ResponseEntity.ok((Object)tenantSid);
    }

    @PostMapping(value={"/update/simple"})
    @Transactional(rollbackFor={Exception.class})
    public StdData<?> updateTenantSimple(@RequestBody UpdateTenantInfoVO updateTenantInfoVO) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(updateTenantInfoVO.getSid());
        if (null == tenant) {
            return StdData.of((int)500, (String)String.format("\u79df\u6237%s\u4e0d\u5b58\u5728", updateTenantInfoVO.getSid()));
        }
        if (StringUtils.hasText((String)updateTenantInfoVO.getVersion())) {
            tenant.setVersion(updateTenantInfoVO.getVersion());
            this.tenantCrudService.update((BaseEntity)tenant);
        }
        return StdData.ok().build();
    }
}

