/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.api;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantMetadataVO;
import com.digiwin.dap.middleware.iam.domain.tenant.metadata.TenantMetadataCostVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.service.tenant.AutoEOCService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataUpdateService;
import com.digiwin.dap.middleware.util.AssertUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/boss/v1/tenant"})
public class TenantMetadataController {
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private TenantMetadataCrudService tenantMetadataCrudService;
    @Autowired
    private TenantMetadataUpdateService tenantMetadataUpdateService;
    @Autowired
    private AutoEOCService autoEOCService;

    @PostMapping(value={"/metadata/eoc/save"})
    public StdData<?> updateTenantEocEntrance(@RequestBody TenantMetadataVO body) {
        Assert.notNull((Object)body.getTenantSid(), (String)"\u79df\u6237sid\u4e0d\u80fd\u4e3a\u7a7a");
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(body.getTenantSid().longValue());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21005, new Object[]{body.getTenantSid()});
        }
        this.tenantMetadataUpdateService.updateTenantEocEntrance(body.getTenantSid().longValue(), body.getValue());
        Optional.ofNullable(body.getAutoEOC()).ifPresent(a -> this.tenantMetadataUpdateService.updateTenantAutoEOC(body.getTenantSid().longValue(), a));
        this.autoEOCService.autoEocInit(body.getTenantSid().longValue());
        return StdData.ok().build();
    }

    @GetMapping(value={"/metadata/eoc/get"})
    public StdData<?> getTenantEocEntrance(@RequestParam Long tenantSid) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid.longValue());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21005, new Object[]{tenantSid});
        }
        List list = this.tenantMetadataCrudService.getTenantMetadataValue(tenantSid.longValue(), "basic", Arrays.asList("eocEntrance", "autoEOC"));
        return StdData.ok((Object)list);
    }

    @GetMapping(value={"/metadata/cost/get"})
    public StdData<?> getTenantCost(@RequestParam Long tenantSid) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid.longValue());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21005, new Object[]{tenantSid});
        }
        List list = this.tenantMetadataCrudService.getTenantMetadataValue(tenantSid.longValue(), "resourceCost", Arrays.asList("deptId", "deptName", "empId", "empName"));
        return StdData.ok((Object)list);
    }

    @PostMapping(value={"/metadata/cost/save"})
    public StdData<?> batchSaveTenantMeta(@RequestBody TenantMetadataCostVO body) {
        Assert.notNull((Object)body.getTenantSid(), (String)"\u79df\u6237sid\u4e0d\u80fd\u4e3a\u7a7a");
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(body.getTenantSid().longValue());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21005, new Object[]{body.getTenantSid()});
        }
        this.tenantMetadataUpdateService.updateTenantMetadataValueList(body.getTenantSid().longValue(), body.getTenantMetadataVOList());
        return StdData.ok().build();
    }

    @GetMapping(value={"/metadata/value"})
    public StdData<?> getMetadataValue(TenantMetadataVO body) {
        AssertUtils.paramNotNull((Object)body.getTenantSid(), (String)"tenantSid");
        AssertUtils.paramHasText((String)body.getCatalogId(), (String)"catalogId");
        AssertUtils.paramHasText((String)body.getKey(), (String)"key");
        String value = this.tenantMetadataCrudService.getTenantMetadataValue(body.getTenantSid().longValue(), body.getCatalogId(), body.getKey());
        return StdData.ok((Object)value);
    }
}

