/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.api;

import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.boss.domain.UserInfoVO;
import com.digiwin.dap.middleware.boss.service.user.BossUserQueryService;
import com.digiwin.dap.middleware.boss.service.user.CheckUserService;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.DigestUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.UserTypeEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.form.BatchQueryUserIntellyIdentityResponse;
import com.digiwin.dap.middleware.iam.domain.form.IntellyIdentityVO;
import com.digiwin.dap.middleware.iam.domain.org.RequestParameterVO;
import com.digiwin.dap.middleware.iam.domain.tenant.UpdateTenantInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.ModUserVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryUserAllInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.UpdatePasswordByIdVO;
import com.digiwin.dap.middleware.iam.domain.user.UserAccountPasswordVO;
import com.digiwin.dap.middleware.iam.domain.user.UserBasicInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.UserCondition;
import com.digiwin.dap.middleware.iam.domain.user.UserConditionVO;
import com.digiwin.dap.middleware.iam.domain.user.UserDataVO;
import com.digiwin.dap.middleware.iam.domain.user.UserEnterpriseWithTenantVO;
import com.digiwin.dap.middleware.iam.domain.user.UserInTenantsWithSysAuthInfo;
import com.digiwin.dap.middleware.iam.domain.user.UserTypeVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.WhiteListService;
import com.digiwin.dap.middleware.iam.service.intelly.IntellyService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantRegisterService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantService;
import com.digiwin.dap.middleware.iam.service.user.UpdatePasswordService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantOperationService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserService;
import com.digiwin.dap.middleware.iam.service.user.UserWholeService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.MessageService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.digiwin.dap.middleware.iam.util.vlidator.PasswordValidator;
import com.digiwin.dap.middleware.iam.util.vlidator.UserIdValidator;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.PageSerializable;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/boss/v1/users"})
public class UserController {
    private static final Logger logger = LoggerFactory.getLogger(UserController.class);
    private static ObjectMapper objectMapper = JsonUtils.createObjectMapper();
    @Autowired
    private CacService cacService;
    @Autowired
    private UserService bossUserService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private UserWholeService userWholeService;
    @Autowired
    private CheckUserService checkUserService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private BossUserQueryService bossUserQueryService;
    @Autowired
    private UserInTenantQueryService userInTenantQueryService;
    @Autowired
    private UserInTenantOperationService userInTenantOperationService;
    @Autowired
    private UserQueryService iamUserQueryService;
    @Autowired
    private WhiteListService whiteListService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private TenantRegisterService tenantRegisterService;
    @Autowired
    private UpdatePasswordService updatePasswordService;
    @Autowired
    private AuthValidateService authValidateService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private IntellyService intellyService;
    @Autowired
    private UserRepository userRepository;

    @GetMapping(value={"/tenant/{tenantId:.+}"})
    public ResponseEntity<?> getUsers(@PathVariable(value="tenantId") String tenantId, @RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(required=false, value="keyword") String keyword, @RequestParam(required=false, value="params") String params) {
        UserConditionVO userConditionVO = new UserConditionVO();
        if (!StringUtils.isEmpty((Object)params)) {
            try {
                userConditionVO = (UserConditionVO)objectMapper.readValue(params, UserConditionVO.class);
            }
            catch (IOException o) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
            }
        }
        userConditionVO.setKeyword(keyword);
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantId});
        }
        PageSerializable bossUserInfoResultVO = this.userInTenantQueryService.getUserInfoByTenantWithPage(tenant.getSid(), userConditionVO, pageNum, pageSize);
        return ResponseEntity.ok((Object)bossUserInfoResultVO);
    }

    @GetMapping(value={"/tenant/{tenantId:.+}/simple"})
    public StdData<?> getUser1s(@PathVariable(value="tenantId") String tenantId, @RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(required=false, value="keyword") String keyword, @RequestParam(required=false, value="params") String params) {
        UserConditionVO userConditionVO = UserConditionVO.getSelf((String)params);
        userConditionVO.setKeyword(keyword);
        Tenant tenant = (Tenant)Optional.ofNullable(this.tenantCrudService.findById(tenantId)).orElseThrow(() -> new BusinessException("\u6ca1\u6709\u6b64\u79df\u6237" + tenantId));
        return StdData.ok((Object)this.userInTenantQueryService.getUserInfoByTenantWithPageSimple(tenant.getSid(), userConditionVO, pageNum, pageSize));
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/tenant/{tenantSid}/{userSid}/disable"})
    public ResponseEntity<?> disableUser(@PathVariable(value="tenantSid") long tenantSid, @PathVariable(value="userSid") long userSid) {
        this.bossUserService.disableUser(tenantSid, userSid);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/tenant/{tenantSid}/{userId}/disable"})
    public ResponseEntity<?> disableUser(@PathVariable(value="tenantSid") long tenantSid, @PathVariable(value="userId") String userId) {
        User user = (User)this.userCrudService.findById(userId);
        this.bossUserService.disableUser(tenantSid, user.getSid());
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/tenant/{tenantSid}/{userSid}/enable"})
    public ResponseEntity<?> enableUser(@PathVariable(value="tenantSid") long tenantSid, @PathVariable(value="userSid") long userSid) {
        this.bossUserService.enableUser(tenantSid, userSid);
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/update/usertype"})
    public StdData updateUserType(@RequestBody UserTypeVO vo, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.notNull((Object)vo.getTenantSid(), (String)"\u53c2\u6570\u9519\u8bef: tenantSid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)vo.getUserSid(), (String)"\u53c2\u6570\u9519\u8bef: userSid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)vo.getUserType(), (String)"\u53c2\u6570\u9519\u8bef: userType\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)vo.getDisable(), (String)"\u53c2\u6570\u9519\u8bef: disable\u4e0d\u80fd\u4e3a\u7a7a");
        this.bossUserService.updateUserType(vo, authoredUser);
        return StdData.ok().build();
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/tenant/{tenantSid}/{userSid}"})
    public ResponseEntity<?> updateUser(@PathVariable(value="tenantSid") long tenantSid, @PathVariable(value="userSid") long userSid, @RequestBody UserBasicInfoVO updateBasicInfoVO) {
        this.bossUserService.updateBasicInfo(tenantSid, userSid, updateBasicInfoVO);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/tenant/{tenantSid}/{userSid}/activate"})
    public ResponseEntity<?> activateUser(@PathVariable(value="tenantSid") long tenantSid, @PathVariable(value="userSid") long userSid) {
        this.bossUserService.activateUser(tenantSid, userSid);
        return new ResponseEntity(HttpStatus.OK);
    }

    @DeleteMapping(value={"/tenant/{tenantSid}/{userSid}"})
    public ResponseEntity<?> removeUser(@PathVariable(value="tenantSid") long tenantSid, @PathVariable(value="userSid") long userSid) {
        User user = (User)this.userCrudService.findBySid(userSid);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{userSid});
        }
        this.userInTenantOperationService.exitTenant(Long.valueOf(tenantSid), user);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/tenant/{tenantSid}/{userSid}/admin"})
    public ResponseEntity<?> updateUserByAdmin(@PathVariable(value="tenantSid") long tenantSid, @PathVariable(value="userSid") long userSid) {
        this.bossUserService.updateUserInAdmin(tenantSid, userSid);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/tenant/{tenantSid}/{userSid}/cancleAdmin"})
    public ResponseEntity<?> updateUserCancleAdmin(@PathVariable(value="tenantSid") long tenantSid, @PathVariable(value="userSid") long userSid) {
        this.bossUserService.updateUserCancelAdmin(tenantSid, userSid);
        return new ResponseEntity(HttpStatus.OK);
    }

    @GetMapping(value={"/check/user/tenant/auth"})
    public ResponseEntity<?> checkUserInTenantWithAuth(@RequestParam(required=true, value="tenantId") String tenantId, @RequestParam(required=true, value="appId") String appId, @RequestParam(required=true, value="email") String email) {
        return ResponseEntity.ok((Object)StdData.ok((Object)this.tenantService.checkUserAuth(tenantId, email, Integer.valueOf(1), appId)));
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/enterprise"})
    public ResponseEntity<?> saveEnterpriseUser(@RequestBody @Valid UserEnterpriseWithTenantVO userEnterpriseVO) {
        String tenantId = userEnterpriseVO.getTenantId();
        long userSid = 0L;
        boolean userExist = false;
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (null == tenant) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantId});
        }
        UserCondition userCondition = new UserCondition.Builder().type(UserTypeEnum.INTERNAL.getCode()).email(userEnterpriseVO.getEmail()).build();
        User user = this.userCrudService.queryUserByTenantSidAndCondition(Long.valueOf(tenant.getSid()), userCondition);
        if (null != user) {
            userSid = user.getSid();
            userExist = true;
        } else {
            if (PasswordValidator.validateTenantCustomPassword((String)userEnterpriseVO.getPassword())) {
                throw new BusinessException((ErrorHandler)I18nError.USER_PASSWORD_FORMAT_ERROR, new Object[]{userEnterpriseVO.getPassword()});
            }
            if (this.envProperties.getCheckUserId().booleanValue() && UserIdValidator.validateUserId((String)userEnterpriseVO.getId())) {
                throw new BusinessException((ErrorHandler)I18nError.USER_ID_FORMAT_ERROR, new Object[]{userEnterpriseVO.getPassword()});
            }
            user = new User();
            user.setId(tenantId + "$" + userEnterpriseVO.getId());
            user.setPassword(DigestUtils.sha256((String)userEnterpriseVO.getPassword()));
            user.setChanged(false);
            user.setActivated(true);
            user.setType(Integer.valueOf(1));
            user.setDueDate(userEnterpriseVO.getDueDate());
            if (!Strings.isEmpty((CharSequence)userEnterpriseVO.getName())) {
                user.setName(userEnterpriseVO.getName());
            }
            if (!Strings.isEmpty((CharSequence)userEnterpriseVO.getEmail())) {
                if (!StringUtil.checkEmail((String)userEnterpriseVO.getEmail())) {
                    throw new BusinessException((ErrorHandler)I18nError.USER_EMAIL_FORMAT_ERROR);
                }
                user.setEmail(userEnterpriseVO.getEmail());
            }
            user.setCellphonePrefix(userEnterpriseVO.getCellphonePrefix());
            if (!Strings.isEmpty((CharSequence)userEnterpriseVO.getTelephone())) {
                if (!StringUtil.isInt((String)userEnterpriseVO.getTelephone())) {
                    throw new BusinessException((ErrorHandler)I18nError.USER_TELEPHONE_FORMAT_ERROR);
                }
                user.setTelephone(userEnterpriseVO.getTelephone());
            }
            userSid = this.userCrudService.create((BaseEntity)user);
        }
        if (!this.userInTenantCrudService.existsByUnionKey(tenant.getSid(), userSid)) {
            UserInTenant userInTenant = new UserInTenant();
            userInTenant.setTenantSid(tenant.getSid());
            userInTenant.setUserSid(userSid);
            if (user.getDueDate().isBefore(LocalDateTime.now())) {
                userInTenant.setDisabled(true);
            }
            this.userInTenantCrudService.create((BaseEntity)userInTenant);
        }
        ArrayList authorizationFailureApps = new ArrayList();
        authorizationFailureApps.addAll(this.userInTenantOperationService.initializeUserData(tenant, user, userEnterpriseVO.getRole(), userEnterpriseVO.getOrg(), userEnterpriseVO.getApp(), userEnterpriseVO.getWechat(), Boolean.valueOf(false)));
        if (userEnterpriseVO.isSendEmail() && !userExist) {
            AuthoredUser authoredUser = new AuthoredUser();
            authoredUser.setTenantId(tenant.getId());
            authoredUser.setTenantName(tenant.getName());
            UserAccountPasswordVO userAccountPasswordVO = new UserAccountPasswordVO(userEnterpriseVO, authoredUser);
            userAccountPasswordVO.setType(Boolean.valueOf(false));
            this.messageService.sendUserEnterpriseAccountPassword(userAccountPasswordVO);
        }
        HashMap<String, Object> resul = new HashMap<String, Object>();
        resul.put("userId", user.getId());
        resul.put("apps", authorizationFailureApps);
        return ResponseEntity.ok((Object)StdData.ok(resul));
    }

    @GetMapping(value={""})
    public ResponseEntity<?> getUsers(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestParam(required=false, value="params") String params) {
        UserConditionVO userConditionVO = null;
        if (!StringUtils.isEmpty((Object)params)) {
            try {
                userConditionVO = (UserConditionVO)objectMapper.readValue(params, UserConditionVO.class);
            }
            catch (IOException o) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
            }
        }
        List users = this.bossUserQueryService.getUserInfoWithPage(pageNum, pageSize, userConditionVO);
        PageSerializable pageInfo = new PageSerializable(users);
        return ResponseEntity.ok((Object)pageInfo);
    }

    @GetMapping(value={"/{userSid}"})
    public ResponseEntity<?> getUserInfo(@PathVariable(value="userSid") long userSid) {
        UserInfoVO userInfoVO = this.bossUserQueryService.getUserBasicInfo(userSid);
        return ResponseEntity.ok((Object)userInfoVO);
    }

    @GetMapping(value={"/{userSid}/invitelog"})
    public ResponseEntity<?> queryUserInvitedHistory(@PathVariable(value="userSid") long userSid) {
        User user = (User)this.userCrudService.findBySid(userSid);
        Assert.notNull((Object)user, (String)"\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        List results = this.userInTenantQueryService.queryUserRelatedTenant("all", user, Boolean.valueOf(false));
        return new ResponseEntity((Object)results, HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/{userSid}/agreeInvitation"})
    public ResponseEntity<?> agreeTenantInvitation(@PathVariable(value="userSid") long userSid, @RequestBody RequestParameterVO body) {
        this.bossUserService.agreeTenantInvited(userSid, body.getSid());
        return new ResponseEntity(HttpStatus.OK);
    }

    @GetMapping(value={"/tenant/{tenantSid}/{appId}/authorizedUser"})
    public ResponseEntity<?> queryAuthorizedUser(@PathVariable(value="tenantSid") long tenantSid, @PathVariable(value="appId") String appId) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantSid});
        }
        List userIds = this.cacService.getAuthorizedUserIds(tenant.getId(), appId);
        List users = this.bossUserQueryService.getUsersWhole(tenantSid, userIds);
        return ResponseEntity.ok((Object)users);
    }

    @PostMapping(value={"/check/foremail"})
    public ResponseEntity<?> checkForEmail(@RequestBody UpdateTenantInfoVO updateTenantInfoVO) {
        boolean resule = this.checkUserService.CheckUserForEmail(updateTenantInfoVO);
        return ResponseEntity.ok((Object)StdData.ok((Object)resule));
    }

    @GetMapping(value={"/simple/{tenantSid}"})
    public StdData getUserSimpleByTenant(@PathVariable long tenantSid) {
        return StdData.ok((Object)this.iamUserQueryService.getUserSimpleByTenant(tenantSid));
    }

    @PostMapping(value={"/email/tenants/auth"})
    public StdData getTenantsByEmail(@RequestBody UserConditionVO userConditionVO) {
        if (StringUtils.isEmpty((Object)userConditionVO.getEmail()) && StringUtils.isEmpty((Object)userConditionVO.getTelephone())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_4);
        }
        UserInTenantsWithSysAuthInfo tenants = this.userWholeService.getTenants(userConditionVO);
        return StdData.ok((Object)tenants);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/individual/tenant/register"})
    public StdData registerByEmail(@RequestBody UserConditionVO userConditionVO) {
        if (StringUtils.isEmpty((Object)userConditionVO.getEmail()) && StringUtils.isEmpty((Object)userConditionVO.getTelephone())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_4);
        }
        if (StringUtils.isEmpty((Object)userConditionVO.getAppId())) {
            logger.warn(String.format("\u901a\u8fc7\u90ae\u7bb1%s\u6216\u624b\u673a%s\u6ce8\u518c\u4e2a\u4eba\u79df\u6237\u7684\u5e94\u7528\u4e3a\u7a7a\uff0c\u5c06\u4e0d\u8fdb\u884c\u5e94\u7528\u6388\u6743", userConditionVO.getEmail(), userConditionVO.getTelephone()));
        } else if (StringUtils.isEmpty((Object)userConditionVO.getStrategyCode())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_8, new Object[]{userConditionVO.getAppId()});
        }
        Map tenant = this.tenantRegisterService.registerIndividualTenantWithAuth(userConditionVO);
        return StdData.ok((Object)tenant);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/update/password/force"})
    public ResponseEntity<?> forceUpdatePassword(@RequestBody UpdatePasswordByIdVO body) {
        if (body.getSid() == 0L && Strings.isEmpty((CharSequence)body.getId())) {
            throw new IllegalArgumentException("\u7528\u6237Sid\u548c\u7528\u6237Id\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        User updatePasswordUser = body.getSid() != 0L ? (User)this.userCrudService.findBySid(body.getSid()) : (User)this.userCrudService.findById(body.getId());
        if (updatePasswordUser == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST);
        }
        try {
            if (StringUtils.hasLength((String)body.getNewPasswordHash())) {
                String password = AES.decrypt((String)body.getNewPasswordHash(), (String)KeyConstant.WECHAT_UNION_ID);
                body.setNewPassword(password);
            }
        }
        catch (Exception e) {
            logger.error("\u5bc6\u7801\u89e3\u5bc6\u5f02\u5e38: {}", (Object)e.getMessage());
            throw new BusinessException((ErrorHandler)I18nError.PASSWORD_UPDATE_INCORRECT_ERROR, e.getMessage());
        }
        if (!StringUtils.hasLength((String)body.getNewPassword())) {
            throw new BusinessException((ErrorHandler)I18nError.PASSWORD_UPDATE_NEW_EMPTY_ERROR);
        }
        if (PasswordValidator.validatePassword((String)body.getNewPassword())) {
            throw new BusinessException((ErrorHandler)I18nError.PASSWORD_UPDATE_FORMAT_ERROR);
        }
        this.bossUserService.updatePasswordForce(body);
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/mod"})
    public StdData<?> modUser(@RequestBody @Valid ModUserVO vo) {
        this.bossUserService.modUser(vo);
        return StdData.ok().build();
    }

    @PostMapping(value={"/sids"})
    public StdData getUserList(@RequestBody QueryUserAllInfoVO userAllInfoVO) {
        if (CollectionUtils.isEmpty((Collection)userAllInfoVO.getUserSids()) && CollectionUtils.isEmpty((Collection)userAllInfoVO.getUserIds())) {
            return StdData.ok().build();
        }
        if (userAllInfoVO.getUserSids().size() > 500 || userAllInfoVO.getUserIds().size() > 500) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_QUERY_SIZE_MAX_ERROR);
        }
        return StdData.ok((Object)this.userMapper.findByIdsOrSids(userAllInfoVO.getUserIds(), userAllInfoVO.getUserSids()));
    }

    @PostMapping(value={"/create/ad"})
    public StdData<?> createAd(@RequestBody UserDataVO vo) {
        Assert.hasText((String)vo.getUserId(), (String)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)vo.getUserName(), (String)"\u7528\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        this.bossUserService.createAd(vo.getUserId(), vo.getUserName());
        return StdData.ok().build();
    }

    @GetMapping(value={"/batch/identity"})
    public StdData getUserIdentities(QueryUserAllInfoVO userAllInfoVO) {
        if (CollectionUtils.isEmpty((Collection)userAllInfoVO.getUserIds())) {
            return StdData.ok().build();
        }
        List users = this.userRepository.findByIdIn(userAllInfoVO.getUserIds());
        Map<Long, User> sidToUserMap = users.stream().collect(Collectors.toMap(BaseEntity::getSid, user -> user));
        Map identityMap = this.intellyService.batchGetIdentity(new ArrayList<Long>(sidToUserMap.keySet()), false, Boolean.valueOf(false));
        List responses = identityMap.entrySet().stream().map(entry -> {
            Long sid = (Long)entry.getKey();
            IntellyIdentityVO identity = (IntellyIdentityVO)entry.getValue();
            User user = (User)sidToUserMap.get(sid);
            BatchQueryUserIntellyIdentityResponse response = new BatchQueryUserIntellyIdentityResponse();
            if (identity != null) {
                BeanUtils.copyProperties((Object)identity, (Object)response);
            }
            response.setUserId(user.getId().toString());
            return response;
        }).collect(Collectors.toList());
        return StdData.ok(responses);
    }
}

