/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.api.obselete;

import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntityWithId;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.entity.DevCertificationDO;
import com.digiwin.dap.middleware.iam.entity.IntellyIdentityApplication;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.repository.CertificationRepository;
import com.digiwin.dap.middleware.iam.service.intelly.IntellyIdentityApplicationCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.support.remote.GmcService;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.GoodsVO;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping
public class TempController {
    private static final Logger logger = LoggerFactory.getLogger(TempController.class);
    @Autowired
    private DMC dmcClient;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private CertificationRepository certificationRepository;
    @Autowired
    private IntellyIdentityApplicationCrudService intellyIdentityApplicationCrudService;
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private GmcService gmcService;

    private static boolean isNotFileId(String fileId) {
        try {
            return fileId.length() != 36;
        }
        catch (Exception exception) {
            return true;
        }
    }

    @GetMapping(value={"/api/boss/v1/env/url/upgrade"})
    public StdData<?> urlUpgrade() {
        ArrayList<String> updateSql = new ArrayList<String>();
        ArrayList<String> restoreSql = new ArrayList<String>();
        List iList = this.intellyIdentityApplicationCrudService.findAll();
        for (IntellyIdentityApplication item : iList) {
            String fileId;
            if (StrUtils.isNotEmpty((String)item.getIdFront()) && TempController.isNotFileId((String)item.getIdFront())) {
                fileId = this.extractId(item.getIdFront());
                updateSql.add(String.format("update intelly_identity_application set id_front='%s' where sid=%s;", fileId, item.getSid()));
                restoreSql.add(String.format("update intelly_identity_application set id_front='%s' where sid=%s;", item.getIdFront(), item.getSid()));
            }
            if (!StrUtils.isNotEmpty((String)item.getIdBack()) || !TempController.isNotFileId((String)item.getIdBack())) continue;
            fileId = this.extractId(item.getIdBack());
            updateSql.add(String.format("update intelly_identity_application set id_back='%s' where sid=%s;", fileId, item.getSid()));
            restoreSql.add(String.format("update intelly_identity_application set id_back='%s' where sid=%s;", item.getIdBack(), item.getSid()));
        }
        List cList = this.certificationRepository.findAll();
        for (DevCertificationDO item : cList) {
            String fileId;
            if (StrUtils.isNotEmpty((String)item.getLicenseNumberFrontImageUrl()) && TempController.isNotFileId((String)item.getLicenseNumberFrontImageUrl())) {
                fileId = this.extractId(item.getLicenseNumberFrontImageUrl());
                updateSql.add(String.format("update certification set license_number_front_image_url='%s' where sid=%s;", fileId, item.getSid()));
                restoreSql.add(String.format("update certification set license_number_front_image_url='%s' where sid=%s;", item.getLicenseNumberFrontImageUrl(), item.getSid()));
            }
            if (StrUtils.isNotEmpty((String)item.getLicenseNumberBackImageUrl()) && TempController.isNotFileId((String)item.getLicenseNumberBackImageUrl())) {
                fileId = this.extractId(item.getLicenseNumberBackImageUrl());
                updateSql.add(String.format("update certification set license_number_bank_image_url='%s' where sid=%s;", fileId, item.getSid()));
                restoreSql.add(String.format("update certification set license_number_bank_image_url='%s' where sid=%s;", item.getLicenseNumberBackImageUrl(), item.getSid()));
            }
            if (!StrUtils.isNotEmpty((String)item.getLicenseNumberGroupImageUrl()) || !TempController.isNotFileId((String)item.getLicenseNumberGroupImageUrl())) continue;
            fileId = this.extractId(item.getLicenseNumberGroupImageUrl());
            updateSql.add(String.format("update certification set license_number_group_image_url='%s' where sid=%s;", fileId, item.getSid()));
            restoreSql.add(String.format("update certification set license_number_group_image_url='%s' where sid=%s;", item.getLicenseNumberGroupImageUrl(), item.getSid()));
        }
        this.saveToDb(updateSql);
        this.saveAsFile(restoreSql);
        return StdData.ok(updateSql);
    }

    private void saveToDb(List<String> updateSql) {
        for (String sql : updateSql) {
            this.jdbcTemplate.execute(sql);
        }
    }

    private void saveAsFile(List<String> restoreSql) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(Paths.get("restore.txt", new String[0]), new OpenOption[0]));
            for (String item : restoreSql) {
                writer.write(String.format("%s\n", item));
            }
            ((Writer)writer).close();
        }
        catch (IOException e) {
            logger.error("\u4fdd\u5b58\u5907\u4efdSQL\u5931\u8d25", (Throwable)e);
        }
    }

    private String extractId(String url) {
        if (url == null || url.trim().isEmpty()) {
            return null;
        }
        int queryIndex = url.indexOf(63);
        if (queryIndex >= 0 && queryIndex < url.length() - 1) {
            return url.substring(queryIndex + 1);
        }
        String[] parts = url.split("/");
        for (int i = parts.length - 1; i >= 0; --i) {
            if (parts[i].isEmpty()) continue;
            String fileId = this.getFileId(this.envProperties.getDmcBucketName(), parts[i], this.dmcClient.getToken());
            return fileId == null ? url : fileId;
        }
        return url;
    }

    private String getFileId(String bucket, String extractId, String token) {
        try {
            String url = this.envProperties.getDmcUrl() + String.format("/api/dmc/v2/share/%s/%s", bucket, extractId);
            HttpHeaders headers = new HttpHeaders();
            headers.set("digi-middleware-auth-user", token);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null && ((StdData)response.getBody()).getData() != null) {
                return ((ShareInfo)((StdData)response.getBody()).getData()).getFileId();
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6587\u4ef6\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    @GetMapping(value={"/api/boss/v1/env/sys/update"})
    public StdData updateSysInfo() {
        List sysList = this.sysCrudService.findAll();
        ArrayList addList = new ArrayList();
        if (sysList.stream().anyMatch(s -> ObjectUtils.isEmpty((Object)s.getShowEntry()))) {
            List goodsVOS = this.gmcService.getGoodsCodeDetail(sysList.stream().map(BaseEntityWithId::getId).collect(Collectors.toList()));
            sysList.forEach(s -> {
                GoodsVO goodsVO = goodsVOS.stream().filter(g -> ObjectUtils.nullSafeEquals((Object)g.getCode(), (Object)s.getId())).findFirst().orElse(null);
                if (!(null == goodsVO || ObjectUtils.nullSafeEquals((Object)s.getLinked(), (Object)goodsVO.getLinked()) && ObjectUtils.nullSafeEquals((Object)s.getShowEntry(), (Object)goodsVO.getShowEntry()) && ObjectUtils.nullSafeEquals((Object)s.getShowConsolePolicy(), (Object)goodsVO.getShowConsolePolicy()) && ObjectUtils.nullSafeEquals((Object)s.getActionFilterUrl(), (Object)goodsVO.getActionFilterUrl()))) {
                    s.setLinked(goodsVO.getLinked());
                    s.setShowEntry(goodsVO.getShowEntry());
                    s.setShowConsolePolicy(goodsVO.getShowConsolePolicy());
                    s.setActionFilterUrl(goodsVO.getActionFilterUrl());
                    addList.add(s);
                }
            });
            if (!CollectionUtils.isEmpty(addList)) {
                Lists.partition(addList, (int)200).forEach(arg_0 -> this.processBatch(arg_0));
            }
        }
        return StdData.ok((Object)addList.size());
    }

    private void processBatch(List<Sys> addList) {
        this.sysCrudService.saveAll(addList);
    }
}

