/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.domain.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import com.digiwin.dap.middleware.iam.constant.I18nCode;
import com.digiwin.dap.middleware.iam.support.remote.domain.TenantApplication;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StringUtils;

public class TenantApplicationExcel {
    private static final Map<Boolean, String> expired = new HashMap();
    private static final Map<Integer, String> paymentType;
    @ExcelProperty(value={"\u4ea7\u54c1\u540d\u79f0"}, index=0)
    private String name;
    @ExcelProperty(value={"\u79df\u6237\u540d\u79f0"}, index=1)
    private String tenantName;
    @ExcelProperty(value={"\u6709\u6548\u671f\u9650"}, index=2)
    private String expiredTime;
    @ExcelProperty(value={"\u72b6\u6001"}, index=3)
    private String status;
    @ExcelProperty(value={"\u4ef7\u683c\u5355\u4f4d"}, index=4)
    private String paymentTypeName;
    @ExcelProperty(value={"\u5df2\u4f7f\u7528U\u6570"}, index=5)
    private String uUsed;
    @ExcelProperty(value={"\u6a21\u7ec4\u540d\u79f0"}, index=6)
    private String moduleName;
    @ExcelProperty(value={"\u6709\u6548\u671f\u9650"}, index=7)
    private String moduleExpiredTime;
    @ExcelProperty(value={"\u72b6\u6001"}, index=8)
    private String moduleStatus;

    public TenantApplicationExcel() {
    }

    public TenantApplicationExcel(TenantApplication o) {
        this.setName(o.getName());
        this.setTenantName(o.getTenantName());
        this.setExpiredTime(String.format("%s%s", I18nCode.BOSS_EXCEL_APP_DATETIME_1.getMessage(), o.getExpiredTime()));
        if (o.isAuthOpen()) {
            if (o.isExpired()) {
                this.setStatus(I18nCode.BOSS_EXCEL_APP_STATUE_EXPIRED.getMessage());
            } else {
                this.setStatus(I18nCode.BOSS_EXCEL_APP_STATUE_ACTIVE.getMessage());
            }
            if (o.getModuleStatus() != null) {
                if (o.getModuleStatus().booleanValue()) {
                    this.setModuleStatus(I18nCode.BOSS_EXCEL_APP_STATUE_EXPIRED.getMessage());
                } else {
                    this.setModuleStatus(I18nCode.BOSS_EXCEL_APP_STATUE_ACTIVE.getMessage());
                }
            }
        } else {
            this.setStatus(I18nCode.BOSS_EXCEL_APP_STATUE_NOT_ACTIVE.getMessage());
            this.setModuleStatus(I18nCode.BOSS_EXCEL_APP_STATUE_NOT_ACTIVE.getMessage());
        }
        if (o.getPaymentType().equals(0)) {
            this.setPaymentTypeName(I18nCode.BOSS_EXCEL_APP_PAYMENT_1.getMessage());
            this.setuUsed(String.format("%s/%s %s", o.getRemainingUsage(), o.getTotalUsage(), I18nCode.BOSS_EXCEL_APP_PAYMENT_1.getMessage()));
        } else if (o.getPaymentType().equals(2)) {
            String paymentTypeName = String.format("%s%s", o.getCustomUnit(), I18nCode.BOSS_EXCEL_APP_PAYMENT_3.getMessage());
            if (!StringUtils.isEmpty((Object)o.getCustomUnit())) {
                this.setPaymentTypeName(paymentTypeName);
                this.setuUsed(String.format("%s/%s %s", o.getRemainingUsage(), o.getTotalUsage(), o.getCustomUnit()));
            } else {
                this.setPaymentTypeName(String.format("%s", I18nCode.BOSS_EXCEL_APP_PAYMENT_3.getMessage()));
            }
        } else if (o.getPaymentType().equals(3)) {
            String paymentTypeName = (String)paymentType.get(o.getPaymentType());
            this.setPaymentTypeName(I18nCode.BOSS_EXCEL_APP_PAYMENT_4.getMessage());
            this.setuUsed(String.format("%s/\u221e %s", o.getUserCount(), I18nCode.BOSS_EXCEL_APP_PAYMENT_6.getMessage()));
        } else {
            String paymentTypeName = I18nCode.BOSS_EXCEL_APP_PAYMENT_2.getMessage();
            this.setPaymentTypeName(paymentTypeName);
            if (null != o.getRemainingUsage()) {
                if (o.getTotalUsage().equals(-1)) {
                    this.setuUsed(String.format("%s/\u221e %s", o.getRemainingUsage(), I18nCode.BOSS_EXCEL_APP_PAYMENT_6.getMessage()));
                } else {
                    this.setuUsed(String.format("%s/%s %s", o.getRemainingUsage(), o.getTotalUsage(), I18nCode.BOSS_EXCEL_APP_PAYMENT_6.getMessage()));
                }
            }
        }
        this.setModuleName(o.getModuleName());
        if (!StringUtils.isEmpty((Object)o.getModuleExpiredTime())) {
            this.setModuleExpiredTime(String.format("%s%s", I18nCode.BOSS_EXCEL_APP_DATETIME_1.getMessage(), o.getModuleExpiredTime()));
        }
    }

    public static Map<Boolean, String> getExpired() {
        return expired;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getExpiredTime() {
        return this.expiredTime;
    }

    public void setExpiredTime(String expiredTime) {
        this.expiredTime = expiredTime;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public static Map<Integer, String> getPaymentType() {
        return paymentType;
    }

    public String getuUsed() {
        return this.uUsed;
    }

    public void setuUsed(String uUsed) {
        this.uUsed = uUsed;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getModuleExpiredTime() {
        return this.moduleExpiredTime;
    }

    public void setModuleExpiredTime(String moduleExpiredTime) {
        this.moduleExpiredTime = moduleExpiredTime;
    }

    public String getModuleStatus() {
        return this.moduleStatus;
    }

    public void setModuleStatus(String moduleStatus) {
        this.moduleStatus = moduleStatus;
    }

    public String getPaymentTypeName() {
        return this.paymentTypeName;
    }

    public void setPaymentTypeName(String paymentTypeName) {
        this.paymentTypeName = paymentTypeName;
    }

    static {
        expired.put(false, I18nCode.BOSS_EXCEL_APP_STATUE_ACTIVE.getMessage());
        expired.put(true, I18nCode.BOSS_EXCEL_APP_STATUE_EXPIRED.getMessage());
        paymentType = new HashMap();
        paymentType.put(0, I18nCode.BOSS_EXCEL_APP_PAYMENT_1.getMessage());
        paymentType.put(1, I18nCode.BOSS_EXCEL_APP_PAYMENT_2.getMessage());
        paymentType.put(2, I18nCode.BOSS_EXCEL_APP_PAYMENT_3.getMessage());
        paymentType.put(3, I18nCode.BOSS_EXCEL_APP_PAYMENT_4.getMessage());
        paymentType.put(4, I18nCode.BOSS_EXCEL_APP_PAYMENT_5.getMessage());
    }
}

