/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.service.excel.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.digiwin.dap.middleware.boss.domain.excel.TenantApplicationExcel;
import com.digiwin.dap.middleware.boss.domain.excel.UserExcel;
import com.digiwin.dap.middleware.boss.service.excel.ExcelDataModelService;
import com.digiwin.dap.middleware.boss.util.ExcelFillCellMergeStrategy;
import com.digiwin.dap.middleware.boss.util.TenantApplicationSheetWriteHandler;
import com.digiwin.dap.middleware.iam.domain.user.UserDataVO;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.support.remote.domain.TenantApplicationVO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class ExcelDataModelServiceImpl
implements ExcelDataModelService {
    @Autowired
    private TenantRepository tenantRepository;

    public void getUserExcels(List<UserDataVO> userDataVOS, HttpServletResponse response, long tenantSid) throws IOException {
        ArrayList userExcels = new ArrayList();
        userDataVOS.forEach(o -> userExcels.add(new UserExcel(o)));
        InputStream inputStream = Locale.SIMPLIFIED_CHINESE.equals(LocaleContextHolder.getLocale()) ? this.getClass().getResourceAsStream("/static/templates/user_export_template_CN.xlsx") : (Locale.TRADITIONAL_CHINESE.equals(LocaleContextHolder.getLocale()) ? this.getClass().getResourceAsStream("/static/templates/user_export_template_TW.xlsx") : this.getClass().getResourceAsStream("/static/templates/user_export_template_US.xlsx"));
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        String name = this.tenantRepository.findIdBySid(tenantSid) + "_user_" + LocalDate.now();
        String fileName = URLEncoder.encode(name, "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), UserExcel.class).withTemplate(inputStream).registerWriteHandler((WriteHandler)ExcelFillCellMergeStrategy.getStyleStrategy())).sheet(Integer.valueOf(0)).needHead(Boolean.valueOf(false))).doWrite(userExcels);
    }

    public void getTenantApplicationExcels(List<TenantApplicationExcel> tenantApplicationExcels, HttpServletResponse response, long tenantSid, TenantApplicationVO tenantApplicationVO) throws IOException {
        int[] mergeColumeIndex = new int[]{0, 1, 2, 3, 4, 5};
        int mergeRowIndex = 1;
        InputStream inputStream = Locale.SIMPLIFIED_CHINESE.equals(LocaleContextHolder.getLocale()) ? this.getClass().getResourceAsStream("/static/templates/tenant_application_export_template_CN.xlsx") : (Locale.TRADITIONAL_CHINESE.equals(LocaleContextHolder.getLocale()) ? this.getClass().getResourceAsStream("/static/templates/tenant_application_export_template_TW.xlsx") : this.getClass().getResourceAsStream("/static/templates/tenant_application_export_template_US.xlsx"));
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        String name = this.tenantRepository.findIdBySid(tenantSid) + "_app_" + LocalDate.now();
        String fileName = URLEncoder.encode(name, "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        if (tenantApplicationVO.getBackModules().booleanValue()) {
            ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), TenantApplicationExcel.class).excelType(ExcelTypeEnum.XLSX).autoCloseStream(Boolean.TRUE).registerWriteHandler((WriteHandler)new ExcelFillCellMergeStrategy(mergeRowIndex, mergeColumeIndex))).withTemplate(inputStream).registerWriteHandler((WriteHandler)ExcelFillCellMergeStrategy.getTenantApplicationStyleStrategy())).sheet(Integer.valueOf(0)).needHead(Boolean.valueOf(false))).doWrite(tenantApplicationExcels);
        } else {
            ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), TenantApplicationExcel.class).withTemplate(inputStream).registerWriteHandler((WriteHandler)ExcelFillCellMergeStrategy.getStyleStrategy())).registerWriteHandler((WriteHandler)new TenantApplicationSheetWriteHandler())).sheet(Integer.valueOf(0)).needHead(Boolean.valueOf(false))).doWrite(tenantApplicationExcels);
        }
    }
}

