/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.service.excel.impl;

import com.digiwin.dap.middleware.boss.domain.excel.TenantApplicationExcel;
import com.digiwin.dap.middleware.boss.mapper.BossRoleMapper;
import com.digiwin.dap.middleware.boss.mapper.BossUserMapper;
import com.digiwin.dap.middleware.boss.service.excel.ExcelDataService;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.entity.BaseEntityWithId;
import com.digiwin.dap.middleware.iam.domain.role.QueryRoleResultVO;
import com.digiwin.dap.middleware.iam.domain.user.UserConditionVO;
import com.digiwin.dap.middleware.iam.domain.user.UserDataVO;
import com.digiwin.dap.middleware.iam.entity.Module;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.OrgMapper;
import com.digiwin.dap.middleware.iam.repository.ModuleRepository;
import com.digiwin.dap.middleware.iam.repository.SysRepository;
import com.digiwin.dap.middleware.iam.support.remote.GmcService;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.TenantApplication;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.GoodsLanguage;
import com.digiwin.dap.middleware.language.service.LanguageCrudService;
import com.digiwin.dap.middleware.language.service.LanguageService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExcelDataServiceImpl
implements ExcelDataService {
    @Autowired
    private BossUserMapper bossUserMapper;
    @Autowired
    private BossRoleMapper bossRoleMapper;
    @Autowired
    private OrgMapper orgMapper;
    @Autowired
    private GmcService gmcService;
    @Autowired
    private LanguageService languageService;
    @Autowired
    private LanguageCrudService languageCrudService;
    @Autowired
    private SysRepository sysRepository;
    @Autowired
    private ModuleRepository moduleRepository;

    public List<UserDataVO> getUserData(long tenantSid, UserConditionVO userConditionVO) {
        ArrayList<UserDataVO> userDataVOS = new ArrayList<UserDataVO>();
        List users = this.bossUserMapper.getExcelUsers(tenantSid, userConditionVO);
        List roles = this.bossRoleMapper.getExcelRoles(tenantSid);
        this.languageService.parse(roles, Collections.singletonMap("name", "roleName"), QueryRoleResultVO.class, Role.class);
        List orgs = this.orgMapper.getExcelOrgs(tenantSid);
        Map<Long, List<QueryRoleResultVO>> roleMap = roles.stream().collect(Collectors.groupingBy(QueryRoleResultVO::getUserSid));
        Map<Long, List<QueryRoleResultVO>> orgMap = orgs.stream().collect(Collectors.groupingBy(QueryRoleResultVO::getUserSid));
        for (User user : users) {
            List<QueryRoleResultVO> userOrgs;
            UserDataVO temp = new UserDataVO(user);
            List<QueryRoleResultVO> userRoles = roleMap.get(user.getSid());
            if (CollectionUtils.isNotEmpty(userRoles)) {
                temp.setRoleName(userRoles.stream().map(QueryRoleResultVO::getName).collect(Collectors.joining("/")));
            }
            if (CollectionUtils.isNotEmpty(userOrgs = orgMap.get(user.getSid()))) {
                temp.setOrgName(userOrgs.stream().map(QueryRoleResultVO::getName).collect(Collectors.joining("/")));
            }
            userDataVOS.add(temp);
        }
        return userDataVOS;
    }

    public List<TenantApplicationExcel> getApplicationLanguage(List<TenantApplication> tenantApplications, boolean containModules) {
        List goodsCodes = tenantApplications.stream().map(TenantApplication::getId).collect(Collectors.toList());
        List goodsLanguage = this.gmcService.getGoodsLanguage(goodsCodes);
        Map<String, GoodsLanguage> goodsMap = goodsLanguage.stream().collect(Collectors.toMap(GoodsLanguage::getGoodsCode, a -> a, (k1, k2) -> k1));
        List sysList = this.sysRepository.findByIdIn(goodsCodes);
        Map<String, Long> sysMap = sysList.stream().collect(Collectors.toMap(BaseEntityWithId::getId, BaseEntity::getSid));
        for (TenantApplication tenantApplication : tenantApplications) {
            List moduleIds;
            GoodsLanguage goods;
            long sysSid = sysMap.getOrDefault(tenantApplication.getId(), 0L);
            if ("BOSS".equals(tenantApplication.getId())) {
                String sysName = this.languageCrudService.findContent(sysSid, "sysName");
                tenantApplication.setName(sysName);
            }
            if ((goods = goodsMap.get(tenantApplication.getId())) != null) {
                tenantApplication.setName(goods.getGoodsName());
                tenantApplication.setCustomUnit(goods.getCustomunit());
            }
            if (!containModules || (moduleIds = tenantApplication.getEnabledModules().stream().map(AuthorizationModuleVO::getId).collect(Collectors.toList())).isEmpty()) continue;
            List modules = this.moduleRepository.findByAppSidAndIdIn(sysSid, moduleIds);
            Map<String, Long> moduleMap = modules.stream().collect(Collectors.toMap(Module::getId, BaseEntity::getSid));
            tenantApplication.getEnabledModules().forEach(module -> module.setSid(moduleMap.getOrDefault(module.getId(), 0L)));
            this.languageService.parse(tenantApplication.getEnabledModules(), new ArrayList<Long>(moduleMap.values()), Collections.singletonMap("name", "moduleName"), AuthorizationModuleVO.class);
        }
        ArrayList<TenantApplicationExcel> tenantApplicationExcels = new ArrayList<TenantApplicationExcel>();
        if (containModules) {
            ArrayList<TenantApplication> tenantApplicationModules = new ArrayList<TenantApplication>();
            for (TenantApplication tenantApplication : tenantApplications) {
                if (tenantApplication.getEnabledModules().isEmpty()) {
                    tenantApplicationModules.add(new TenantApplication(tenantApplication));
                    continue;
                }
                for (AuthorizationModuleVO module2 : tenantApplication.getEnabledModules()) {
                    tenantApplicationModules.add(new TenantApplication(tenantApplication, module2));
                }
            }
            tenantApplicationModules.forEach(o -> tenantApplicationExcels.add(new TenantApplicationExcel(o)));
        } else {
            tenantApplications.forEach(o -> tenantApplicationExcels.add(new TenantApplicationExcel(o)));
        }
        return tenantApplicationExcels;
    }
}

