/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.service.metadata.impl;

import com.digiwin.dap.middleware.boss.domain.FieldValueTargetVO;
import com.digiwin.dap.middleware.boss.domain.Page;
import com.digiwin.dap.middleware.boss.service.metadata.SchemaService;
import com.digiwin.dap.middleware.iam.domain.datapolicy.ActionIdEnum;
import com.digiwin.dap.middleware.iam.domain.datapolicy.Item;
import com.digiwin.dap.middleware.iam.domain.enumeration.GoodsCategoryEnum;
import com.digiwin.dap.middleware.iam.service.tenant.TenantQueryService;
import com.digiwin.dap.middleware.iam.support.remote.domain.TenantApplication;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="djcMangService")
public class DjcMangServiceImpl
implements SchemaService {
    private static final String FIELD_APPID = "appId";
    @Autowired
    private TenantQueryService tenantQueryService;

    public boolean support(String actionId) {
        return ActionIdEnum.DJC_MANG_SERVICE.getId().equalsIgnoreCase(actionId);
    }

    public Page getValues(FieldValueTargetVO input) {
        List<Object> items = new ArrayList();
        if (FIELD_APPID.equals(input.getFieldName())) {
            List apps = this.tenantQueryService.getTenantApplicationByTenant(input.getTenantId(), GoodsCategoryEnum.APP.id());
            for (TenantApplication app : apps) {
                items.add(new Item(app.getId(), app.getName()));
            }
        }
        if (!StringUtils.isEmpty((Object)input.getFilter())) {
            String filter = input.getFilter().toLowerCase();
            items = items.stream().filter(o -> o.getId().toLowerCase().contains(filter) || o.getName().toLowerCase().contains(filter)).collect(Collectors.toList());
        }
        List pageItems = items.stream().skip(input.skip()).limit(input.limit()).collect(Collectors.toList());
        return Page.page((Integer)items.size(), pageItems);
    }
}

