/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.service.metadata.impl;

import com.digiwin.dap.middleware.boss.domain.FieldValueTargetVO;
import com.digiwin.dap.middleware.boss.domain.Page;
import com.digiwin.dap.middleware.boss.service.metadata.SchemaService;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.iam.domain.datapolicy.ActionIdEnum;
import com.digiwin.dap.middleware.iam.domain.datapolicy.SchemaFieldVO;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicySchemaService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service(value="defaultSchemaService")
@Primary
public class SchemaServiceImpl
implements SchemaService {
    private static final Logger logger = LoggerFactory.getLogger(SchemaServiceImpl.class);
    private static final ObjectMapper objectMapper = JsonUtils.createObjectMapper();
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private DataPolicySchemaService dataPolicySchemaService;

    public boolean support(String actionId) {
        return !ActionIdEnum.DJC_MANG_SERVICE.getId().equalsIgnoreCase(actionId);
    }

    public Page getValues(FieldValueTargetVO input) {
        SchemaFieldVO schemaField = this.dataPolicySchemaService.getSchemaField(input.getActionId(), input.getTableName(), input.getFieldName());
        if (schemaField.getDataSource() == 0) {
            return this.getValuesByJson(schemaField, input);
        }
        if (schemaField.getDataSource() == 1) {
            return this.getValuesByRemote(schemaField, input);
        }
        return Page.empty();
    }

    private Page getValuesByJson(SchemaFieldVO schemaField, FieldValueTargetVO input) {
        try {
            String language = LocaleContextHolder.getLocale().toLanguageTag();
            Map object = (Map)objectMapper.readValue(schemaField.getValues(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            List items = object.getOrDefault(language, Collections.emptyList());
            if (!StringUtils.isEmpty((Object)input.getFilter())) {
                String filter = input.getFilter().toLowerCase();
                items = items.stream().filter(o -> o.getId().toLowerCase().contains(filter) || o.getName().toLowerCase().contains(filter)).collect(Collectors.toList());
            }
            List pageItems = items.stream().skip(input.skip()).limit(input.limit()).collect(Collectors.toList());
            return Page.page((Integer)items.size(), pageItems);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5b57\u6bb5{}\u503c\u5931\u8d25\u3002\u9519\u8bef\uff1a{}", (Object)schemaField.getId(), (Object)e.getMessage());
            return Page.empty();
        }
    }

    private Page getValuesByRemote(SchemaFieldVO schemaField, FieldValueTargetVO input) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        headers.add("token", UserUtils.getToken());
        HashMap<String, Serializable> requestBody = new HashMap<String, Serializable>(2);
        requestBody.put("pageNum", input.getPageNum());
        requestBody.put("pageSize", input.getPageSize());
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("code", input.getFilter());
        if (ActionIdEnum.ISV_GOODS.getId().equalsIgnoreCase(input.getActionId())) {
            filters.put("servicer", input.getTenantId());
        }
        requestBody.put("filters", filters);
        HttpEntity httpEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        try {
            Page response = (Page)this.restTemplate.postForObject(schemaField.getValues(), (Object)httpEntity, Page.class, new Object[0]);
            if (response != null) {
                return response;
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528{}\uff0c\u83b7\u53d6\u5b57\u6bb5{}\u7684\u503c\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{schemaField.getId(), schemaField.getValues(), e.getMessage()});
        }
        return Page.empty();
    }
}

