/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.service.org.impl;

import com.digiwin.dap.middleware.boss.service.org.OrgTypeUpdateService;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.org.OrgTypePath;
import com.digiwin.dap.middleware.iam.domain.org.OrgTypeVO;
import com.digiwin.dap.middleware.iam.entity.OrgType;
import com.digiwin.dap.middleware.iam.service.org.OrgTypeCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgTypePathService;
import com.digiwin.dap.middleware.iam.support.validate.OrgValidateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgTypeUpdateServiceImpl
implements OrgTypeUpdateService {
    @Autowired
    private OrgTypeCrudService orgTypeCrudService;
    @Autowired
    private OrgTypePathService orgTypePathService;
    @Autowired
    private OrgValidateService orgValidateService;

    public long addOrgType(long tenantSid, OrgTypeVO orgTypeVO) {
        String uri;
        this.orgValidateService.checkOrgType(tenantSid, orgTypeVO);
        if (orgTypeVO.getParentSid() != 0L) {
            OrgTypePath orgTypePath = this.orgTypePathService.getOrgTypePath(Long.valueOf(tenantSid), orgTypeVO.getParentSid().longValue());
            uri = orgTypePath.getOrgTypeUri() + ":" + orgTypeVO.getId();
        } else {
            uri = "drn:iam:orgtype:" + orgTypeVO.getOrgCatalogId() + ":" + orgTypeVO.getId();
        }
        OrgType newOrgType = new OrgType();
        newOrgType.setId(orgTypeVO.getId());
        newOrgType.setName(orgTypeVO.getName());
        newOrgType.setTenantSid(tenantSid);
        newOrgType.setParentSid(orgTypeVO.getParentSid().longValue());
        newOrgType.setOrgCatalogSid(orgTypeVO.getOrgCatalogSid());
        newOrgType.setUri(uri);
        return this.orgTypeCrudService.create((BaseEntity)newOrgType);
    }

    public void updateOrgType(long tenantSid, OrgTypeVO orgTypeVO) {
        if (orgTypeVO == null) {
            throw new IllegalArgumentException("bossOrgTypeVO is null");
        }
        OrgType type = this.orgTypeCrudService.findByUnionKey(tenantSid, orgTypeVO.getOrgCatalogSid(), orgTypeVO.getId());
        if (type == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_TYPE_NOT_EXISTED);
        }
        if (orgTypeVO.getName() != null) {
            type.setName(orgTypeVO.getName());
        }
        this.orgTypeCrudService.update((BaseEntity)type);
    }
}

