/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.service.org.impl;

import com.digiwin.dap.middleware.boss.service.org.OrgUpdateService;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.org.OrgPath;
import com.digiwin.dap.middleware.iam.domain.org.OrgVO;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgPathService;
import com.digiwin.dap.middleware.iam.support.validate.OrgValidateService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgUpdateServiceImpl
implements OrgUpdateService {
    @Autowired
    private OrgCrudService orgCrudService;
    @Autowired
    private OrgPathService orgPathService;
    @Autowired
    private OrgValidateService orgValidateService;

    public long addOrg(long tenantSid, OrgVO orgVO) {
        String uri;
        this.orgValidateService.checkOrg(tenantSid, orgVO);
        if (orgVO.getParentSid() != 0L) {
            OrgPath orgPath = this.orgPathService.getOrgPath(orgVO.getParentSid().longValue());
            uri = orgPath.getOrgUri() + ":" + orgVO.getId();
        } else {
            uri = "drn:iam:org:" + orgVO.getOrgCatalogId() + ":" + orgVO.getOrgTypeId() + ":" + orgVO.getId();
        }
        Org org = new Org();
        BeanUtils.copyProperties((Object)orgVO, (Object)org);
        org.setUri(uri);
        org.setTenantSid(tenantSid);
        return this.orgCrudService.create((BaseEntity)org);
    }

    public void updateOrg(long tenantSid, OrgVO orgVO) {
        if (orgVO == null) {
            throw new IllegalArgumentException("bossOrgVO is null");
        }
        Org org = (Org)this.orgCrudService.findByUnionKey(new Object[]{tenantSid, orgVO.getOrgAspectSid(), orgVO.getId(), orgVO.getParentSid()});
        if (org == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_NOT_EXIST);
        }
        if (org.getUri() != null) {
            String[] orgId = org.getUri().split(":");
            String uri = org.getUri().replace(orgId[orgId.length - 1], orgVO.getId());
            org.setUri(uri);
        }
        org.setName(orgVO.getName());
        org.setOrgAspectSid(orgVO.getOrgAspectSid());
        org.setOrgTypeSid(orgVO.getOrgTypeSid());
        org.setParentSid(orgVO.getParentSid().longValue());
        if (orgVO.getChargeSid() != 0L) {
            org.setChargeSid(orgVO.getChargeSid());
        }
        this.orgCrudService.update((BaseEntity)org);
    }
}

