/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.service.permission.impl;

import com.digiwin.dap.middleware.boss.domain.PermissionField;
import com.digiwin.dap.middleware.boss.service.permission.PermissionService;
import com.digiwin.dap.middleware.iam.domain.role.QueryRoleResultVO;
import com.digiwin.dap.middleware.iam.entity.DataPolicy;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.mapper.SysMapper;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicyCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleQueryService;
import com.digiwin.dap.middleware.iam.support.obsolete.service.FieldValueCrudService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionServiceImpl
implements PermissionService {
    @Autowired
    private SysMapper sysMapper;
    @Autowired
    private DataPolicyCrudService dataPolicyCrudService;
    @Autowired
    private FieldValueCrudService fieldValueCrudService;
    @Autowired
    private UserInRoleQueryService userInRoleQueryService;

    public PermissionField getUserFieldPermission(long tenantSid, long userSid, String sysId) {
        PermissionField permissionField = null;
        Sys sys = this.sysMapper.findByTenantSidAndId(tenantSid, sysId);
        if (null == sys) {
            return null;
        }
        permissionField = new PermissionField();
        permissionField.setSid(Long.valueOf(sys.getSid()));
        permissionField.setId(sys.getId());
        permissionField.setName(sys.getName());
        permissionField.setHasAll(Boolean.valueOf(false));
        List roles = this.userInRoleQueryService.queryUserInRoleByUser(tenantSid, userSid);
        if (roles.size() == 0) {
            return permissionField;
        }
        if (roles.stream().anyMatch(o -> "superadmin".equals(o.getId()))) {
            permissionField.setHasAll(Boolean.valueOf(true));
            return permissionField;
        }
        ArrayList fields = new ArrayList();
        for (QueryRoleResultVO role : roles) {
            List fieldValues;
            DataPolicy dataPolicy = this.getDataPolicy(tenantSid, role.getId(), sysId);
            if (null == dataPolicy || (fieldValues = this.fieldValueCrudService.findByTargetSid(dataPolicy.getSid())).size() <= 0) continue;
            HashMap fieldValue = new HashMap();
            fieldValues.forEach(o -> {
                if (null == o.getType() || "".equals(o.getType()) || "multiple".equals(o.getType()) || "single".equals(o.getType())) {
                    fieldValue.put(o.getKey(), new HashSet<String>(Arrays.asList(o.getValue().split(","))));
                } else if ("int".equals(o.getType())) {
                    fieldValue.put(o.getKey(), Long.parseLong(o.getValue()));
                } else if ("boolean".equals(o.getType())) {
                    fieldValue.put(o.getKey(), "1".equals(o.getValue()));
                } else {
                    fieldValue.put(o.getKey(), o.getValue());
                }
            });
            fields.add(fieldValue);
        }
        if (fields.size() > 0) {
            permissionField.setFields(fields);
        }
        return permissionField;
    }

    private DataPolicy getDataPolicy(long tenantSid, String roleId, String sysId) {
        String policyId = "role_" + roleId + "_" + sysId;
        return (DataPolicy)this.dataPolicyCrudService.findByTenantSidAndId(tenantSid, policyId);
    }
}

