/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.service.role.impl;

import com.digiwin.dap.middleware.boss.domain.RoleVO;
import com.digiwin.dap.middleware.boss.service.role.RoleUpdateService;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.RoleCatalog;
import com.digiwin.dap.middleware.iam.service.role.RoleCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RoleUpdateServiceImpl
implements RoleUpdateService {
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private RoleCatalogCrudService roleCatalogCrudService;

    public long addRole(long tenantSid, RoleVO roleVO) {
        if (tenantSid == 0L) {
            throw new IllegalArgumentException("tenantSid is 0");
        }
        if (roleVO == null) {
            throw new IllegalArgumentException("bossRoleVO is null");
        }
        Role oldRole = this.roleCrudService.findByTenantSidAndId(tenantSid, roleVO.getId());
        if (oldRole != null) {
            throw new BusinessException((ErrorHandler)I18nError.ROLE_EXISTED, new Object[]{roleVO.getId()});
        }
        RoleCatalog roleCatalog = this.roleCatalogCrudService.findByTenantSidAndSid(Long.valueOf(tenantSid), Long.valueOf(roleVO.getRoleCatalogSid()));
        if (roleCatalog == null) {
            throw new BusinessException((ErrorHandler)I18nError.ROLE_CATALOG_NOT_EXISTED, new Object[]{roleVO.getRoleCatalogSid()});
        }
        Role role = new Role();
        role.setId(roleVO.getId());
        role.setName(roleVO.getName());
        role.setTenantSid(tenantSid);
        role.setRoleCatalogSid(roleVO.getRoleCatalogSid());
        return this.roleCrudService.create((BaseEntity)role);
    }

    public void updateRole(long tenantSid, RoleVO roleVO) {
        if (tenantSid == 0L) {
            throw new IllegalArgumentException("tenantSid is 0");
        }
        if (roleVO == null) {
            throw new IllegalArgumentException("bossRoleVO is null");
        }
        Role role = this.roleCrudService.findByTenantSidAndId(tenantSid, roleVO.getId());
        if (role == null) {
            throw new BusinessException((ErrorHandler)I18nError.ROLE_DELETE, new Object[]{roleVO.getId()});
        }
        RoleCatalog roleCatalog = this.roleCatalogCrudService.findByTenantSidAndSid(Long.valueOf(tenantSid), Long.valueOf(roleVO.getRoleCatalogSid()));
        if (roleCatalog == null) {
            throw new BusinessException((ErrorHandler)I18nError.ROLE_CATALOG_NOT_EXISTED, new Object[]{roleVO.getRoleCatalogSid()});
        }
        role.setName(roleVO.getName());
        this.roleCrudService.update((BaseEntity)role);
    }
}

