/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.service.role.impl;

import com.digiwin.dap.middleware.boss.domain.UserInRoleExpiredTimeVO;
import com.digiwin.dap.middleware.boss.service.role.UserInRoleUpdateService;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.entity.Association;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleCrudService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserInRoleUpdateServiceImpl
implements UserInRoleUpdateService {
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private UserInRoleCrudService userInRoleCrudService;

    public void updateUserInRole(UserInRoleExpiredTimeVO userInRoleExpiredTimeVO, long tenantSid) {
        if (userInRoleExpiredTimeVO == null) {
            throw new IllegalArgumentException("userInRoleExpiredTimeVO is null");
        }
        User user = (User)this.userCrudService.findById(userInRoleExpiredTimeVO.getUserId());
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{userInRoleExpiredTimeVO.getUserId()});
        }
        Role role = this.roleCrudService.findByTenantSidAndId(tenantSid, userInRoleExpiredTimeVO.getRoleId());
        if (role == null) {
            throw new BusinessException((ErrorHandler)I18nError.ROLE_NOT_EXIST, new Object[]{userInRoleExpiredTimeVO.getRoleId()});
        }
        Association oldAssociation = this.userInRoleCrudService.findByUnionKey(role.getTenantSid(), user.getSid(), role.getSid());
        if (oldAssociation == null) {
            Association association = new Association();
            association.setTenantSid(role.getTenantSid());
            association.setUserSid(user.getSid());
            association.setRoleSid(role.getSid());
            association.setStatus(true);
            association.setExpiredTime(userInRoleExpiredTimeVO.getExpiredTime());
            this.userInRoleCrudService.create((BaseEntity)association);
        } else {
            oldAssociation.setExpiredTime(userInRoleExpiredTimeVO.getExpiredTime());
            this.userInRoleCrudService.update((BaseEntity)oldAssociation);
        }
    }
}

