/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.service.sys.impl;

import com.digiwin.dap.middleware.boss.service.sys.SysInAuthorService;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.app.SysQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.enumeration.GoodsCategoryEnum;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.service.sys.SysInTenantQueryService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationResultVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.TenantApplication;
import com.digiwin.dap.middleware.iam.support.remote.domain.TenantApplicationVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SysAuthorServiceImpl
implements SysInAuthorService {
    @Autowired
    CacService cacService;
    @Autowired
    TenantCrudService tenantCrudService;
    @Autowired
    SysInTenantQueryService sysInTenantQueryService;
    @Autowired
    TenantRepository tenantRepository;

    public List<TenantApplication> getTenantApplicationByTenant(long tenantSid, String userToken, TenantApplicationVO condition, Boolean isExport, Integer pageSize, Integer pageNum) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantSid});
        }
        List<Object> tenantApplications = new ArrayList<TenantApplication>();
        List authorizationResultVOS = isExport != false ? this.cacService.queryAuthorizationExcludePolicy(tenant.getId(), userToken, pageSize, pageNum) : this.cacService.queryAuthorization(tenant.getId(), userToken, Boolean.valueOf(true), pageSize, pageNum);
        for (AuthorizationResultVO authorizationResultVO : authorizationResultVOS) {
            if (!GoodsCategoryEnum.isApp((String)authorizationResultVO.getCategoryId())) continue;
            tenantApplications.add(new TenantApplication(tenant, authorizationResultVO, Boolean.valueOf(false)));
        }
        List sysInTenants = this.sysInTenantQueryService.getSysVOByTenantSid(tenant.getSid());
        for (SysQueryResultVO current : sysInTenants) {
            if (current.isInside() && current.isHasPermission() && tenantApplications.stream().noneMatch(tenantApplication -> tenantApplication.getId().equals(current.getId()))) {
                tenantApplications.add((TenantApplication)((Object)new TenantApplication(tenant, current)));
            }
            if (tenant.isIsv() && "ISV".equals(current.getId())) {
                tenantApplications.add((TenantApplication)((Object)new TenantApplication(tenant, current)));
            }
            if ("dev".equals(current.getId())) {
                tenantApplications.add((TenantApplication)((Object)new TenantApplication(tenant, current)));
            }
            tenantApplications.stream().filter(cacApp -> cacApp.getId().equals(current.getId())).forEach(cacApp -> {
                cacApp.setSecretKey(current.getSecretKey());
                cacApp.setBackUri(current.getBackUri());
            });
        }
        if (condition != null) {
            if (!CollectionUtils.isEmpty((Collection)condition.getIds())) {
                tenantApplications = tenantApplications.stream().filter(o -> condition.getIds().contains(o.getId())).collect(Collectors.toList());
            }
            if (null != condition.getExpired()) {
                tenantApplications = tenantApplications.stream().filter(o -> condition.getExpired().equals(o.isExpired())).collect(Collectors.toList());
            }
            if (null != condition.getAuthOpen()) {
                tenantApplications = tenantApplications.stream().filter(o -> condition.getAuthOpen().equals(o.isAuthOpen())).collect(Collectors.toList());
            }
            if (StringUtils.hasLength((String)condition.getBundleContent())) {
                tenantApplications = tenantApplications.stream().filter(o -> StringUtils.hasLength((String)o.getBundleCode()) && o.getBundleCode().contains(condition.getBundleContent()) || StringUtils.hasLength((String)o.getBundleName()) && o.getBundleName().contains(condition.getBundleContent())).collect(Collectors.toList());
            }
            if (condition.getCategoryId() != null) {
                tenantApplications = tenantApplications.stream().filter(o -> GoodsCategoryEnum.getCategoryIds((String)condition.getCategoryId()).contains(o.getCategoryId())).collect(Collectors.toList());
            }
        }
        return tenantApplications;
    }
}

