/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.service.tenant.impl;

import com.digiwin.dap.middleware.boss.domain.TenantResultVO;
import com.digiwin.dap.middleware.boss.domain.tenant.TenantCertificationInfoVO;
import com.digiwin.dap.middleware.boss.domain.tenant.TenantConditionVO;
import com.digiwin.dap.middleware.boss.domain.tenant.TenantInfoVO;
import com.digiwin.dap.middleware.boss.domain.tenant.TenantVO;
import com.digiwin.dap.middleware.boss.domain.tenant.UserCertificationInfoVO;
import com.digiwin.dap.middleware.boss.mapper.BossTenantMapper;
import com.digiwin.dap.middleware.boss.service.tenant.BossTenantQueryService;
import com.digiwin.dap.middleware.boss.service.user.UserEmailService;
import com.digiwin.dap.middleware.boss.util.Levenshtein;
import com.digiwin.dap.middleware.domain.ComeFromEnum;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.enums.TenantEnterpriseTypeEnum;
import com.digiwin.dap.middleware.iam.domain.org.OrgCatalogCascadeVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.TenantCertification;
import com.digiwin.dap.middleware.iam.entity.UserCertification;
import com.digiwin.dap.middleware.iam.service.authentication.TenantAuthenticationService;
import com.digiwin.dap.middleware.iam.service.authentication.TenantCertificationCrudService;
import com.digiwin.dap.middleware.iam.service.authentication.UserCertificationCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCatalogQueryService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataCrudService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.github.pagehelper.PageSerializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BossTenantQueryServiceImpl
implements BossTenantQueryService {
    private static final Logger logger = LoggerFactory.getLogger(BossTenantQueryServiceImpl.class);
    @Autowired
    private BossTenantMapper bossTenantMapper;
    @Autowired
    private OrgCatalogQueryService orgCatalogQueryService;
    @Autowired
    private TenantAuthenticationService tenantAuthenticationService;
    @Autowired
    private UserCertificationCrudService userCertificationCrudService;
    @Autowired
    private TenantCertificationCrudService tenantCertificationCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private UserEmailService userEmailService;
    @Autowired
    private TenantMetadataCrudService tenantMetadataCrudService;
    @Autowired
    private CacService cacService;

    public List<TenantVO> getBossTenantQueryVos(TenantConditionVO params, int pageNum, int pageSize, String orderBy) {
        return this.bossTenantMapper.getTenantWithPage(params, pageNum, pageSize, orderBy);
    }

    public List<OrgCatalogCascadeVO> getAspectByTenantSid(long tenantSid) {
        if (tenantSid == 0L) {
            throw new IllegalArgumentException("tenantSid is 0");
        }
        return this.orgCatalogQueryService.getOrgCatalogCascades(tenantSid);
    }

    public TenantInfoVO getTenantInfoBySid(long tenantSid) {
        if (tenantSid == 0L) {
            throw new IllegalArgumentException("tenantSid is 0");
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        if (tenant == null) {
            throw new BusinessException("\u6c92\u6709\u6b64\u79df\u6237" + tenantSid);
        }
        TenantInfoVO tenantInfoVO = this.bossTenantMapper.getTenantInfo(tenantSid);
        if (TenantEnterpriseTypeEnum.ENTERPRISE_TENANT.getValue().equals(tenantInfoVO.getEnterpriseType())) {
            TenantCertificationInfoVO tenantCertificationInfoVO = new TenantCertificationInfoVO();
            TenantCertification tenantCertification = this.tenantCertificationCrudService.findByTenantSid(tenantSid);
            if (tenantCertification != null) {
                tenantCertificationInfoVO.setName(StringUtils.isEmpty((Object)tenantCertification.getName()) ? "" : tenantCertification.getName());
                tenantCertificationInfoVO.setBusinessAccountingNo(StringUtils.isEmpty((Object)tenantCertification.getBusinessAccountingNo()) ? "" : tenantCertification.getBusinessAccountingNo());
                tenantCertificationInfoVO.setCertType(StringUtils.isEmpty((Object)tenantCertification.getCertType()) ? "" : tenantCertification.getCertType());
                tenantCertificationInfoVO.setCertNo(this.buildIDNumber(tenantCertification.getCertNo()));
                tenantCertificationInfoVO.setLegalCertNo(this.buildIDNumber(tenantCertification.getLegalCertNo()));
                tenantCertificationInfoVO.setLegalCertNo(StringUtils.isEmpty((Object)tenantCertification.getLegalCertNo()) ? "" : tenantCertification.getLegalCertNo());
                tenantCertificationInfoVO.setLegalName(StringUtils.isEmpty((Object)tenantCertification.getLegalName()) ? "" : tenantCertification.getLegalName());
                tenantCertificationInfoVO.setLegalCertType(StringUtils.isEmpty((Object)tenantCertification.getLegalCertType()) ? "" : tenantCertification.getLegalCertType());
                tenantCertificationInfoVO.setRealnameType(StringUtils.isEmpty((Object)tenantCertification.getRealnameType()) ? "" : tenantCertification.getRealnameType());
                tenantCertificationInfoVO.setLegalMobile(StringUtils.isEmpty((Object)tenantCertification.getLegalMobile()) ? "" : tenantCertification.getLegalMobile());
                tenantCertificationInfoVO.setAccountName(StringUtils.isEmpty((Object)tenantCertification.getAccountName()) ? "" : tenantCertification.getAccountName());
                tenantCertificationInfoVO.setAccountNo(StringUtils.isEmpty((Object)tenantCertification.getAccountNo()) ? "" : tenantCertification.getAccountNo());
                tenantCertificationInfoVO.setBank(StringUtils.isEmpty((Object)tenantCertification.getBank()) ? "" : tenantCertification.getBank());
                tenantCertificationInfoVO.setSubbranch(StringUtils.isEmpty((Object)tenantCertification.getSubbranch()) ? "" : tenantCertification.getSubbranch());
                tenantCertificationInfoVO.setProvince(StringUtils.isEmpty((Object)tenantCertification.getProvince()) ? "" : tenantCertification.getProvince());
                tenantCertificationInfoVO.setPassed(Boolean.valueOf(tenantCertification.isPassed()));
                tenantInfoVO.setTenantCertification(tenantCertificationInfoVO);
            } else {
                UserCertificationInfoVO userCertificationInfoVO = new UserCertificationInfoVO();
                UserCertification userCertification = this.userCertificationCrudService.findByUserSid(tenant.getOwnerUserSid());
                if (userCertification != null) {
                    userCertificationInfoVO.setName(StringUtils.isEmpty((Object)userCertification.getName()) ? "" : userCertification.getName());
                    userCertificationInfoVO.setCertType(StringUtils.isEmpty((Object)userCertification.getCertType()) ? "" : userCertification.getCertType());
                    userCertificationInfoVO.setEmail(StringUtils.isEmpty((Object)userCertification.getEmail()) ? "" : userCertification.getEmail());
                    userCertificationInfoVO.setIdno(this.buildIDNumber(userCertification.getIdno()));
                    userCertificationInfoVO.setMobile(StringUtils.isEmpty((Object)userCertification.getMobile()) ? "" : userCertification.getMobile());
                    userCertificationInfoVO.setRealnameType(StringUtils.isEmpty((Object)userCertification.getRealnameType()) ? "" : userCertification.getRealnameType());
                    userCertificationInfoVO.setPassed(Boolean.valueOf(userCertification.isPassed()));
                    tenantInfoVO.setUserCertification(userCertificationInfoVO);
                }
            }
        }
        String defaultLanguage = this.tenantMetadataCrudService.getTenantMetadataValue(tenantInfoVO.getSid().longValue(), "basic", "defaultLanguage");
        tenantInfoVO.setDefaultLanguage(defaultLanguage);
        String corpId = this.tenantMetadataCrudService.getTenantMetadataValue(tenantSid, "contact", "corpId");
        tenantInfoVO.setCorpId(corpId);
        tenantInfoVO.setPasswordSpan(this.tenantMetadataCrudService.getTenantMetadataValue(tenantSid, "basic", "passwordSpan"));
        tenantInfoVO.setAutoEOC(this.tenantMetadataCrudService.getTenantMetadataValue(tenantSid, "basic", "autoEOC"));
        tenantInfoVO.setEocEntrance(this.tenantMetadataCrudService.getTenantMetadataValue(tenantSid, "basic", "eocEntrance"));
        tenantInfoVO.setDingTalkCorpId(this.tenantMetadataCrudService.getTenantMetadataValue(tenantSid, "corpId", ComeFromEnum.DINGDING.getId()));
        tenantInfoVO.setPasswordAttempts(this.tenantMetadataCrudService.getTenantMetadataValue(tenantSid, "basic", "passwordAttempts"));
        tenantInfoVO.setPasswordMinLength(this.tenantMetadataCrudService.getTenantMetadataValue(tenantSid, "basic", "pwMinLength"));
        return tenantInfoVO;
    }

    private String buildIDNumber(String number) {
        if (!StringUtils.isEmpty((Object)number)) {
            StringBuilder builder = new StringBuilder(number);
            if (number.length() <= 4) {
                number = "****";
            }
            if (number.length() > 4 && number.length() < 9) {
                number = builder.replace(4, number.length(), "****").toString();
            }
            if (number.length() > 9) {
                number = builder.replace(4, number.length() - 4, "**********").toString();
            }
            return number;
        }
        return "";
    }

    public List<TenantInfoVO> getTenantVos(String tenantName, String customerId) {
        List<TenantInfoVO> tenants = this.bossTenantMapper.getTenantInfos(customerId);
        tenants.forEach(o -> o.setSimilarity(Integer.valueOf(Levenshtein.editDistanceSimilarity((String)tenantName, (String)o.getName()))));
        tenants = tenants.stream().sorted(Comparator.comparing(TenantInfoVO::getSimilarity).reversed()).limit(10L).collect(Collectors.toList());
        return tenants;
    }

    public PageSerializable getBossTenantByAppId(String tenantConditionVO, String appId, int pageNum, int pageSize, boolean excludeExpiredTenant, Long strategySid) {
        List authTenantIdValid = new ArrayList();
        if ((excludeExpiredTenant || strategySid != null) && CollectionUtils.isEmpty(authTenantIdValid = this.cacService.findAuthTenantIdValid(appId, excludeExpiredTenant, strategySid))) {
            return new PageSerializable(new ArrayList());
        }
        List tenantResultVOS = this.bossTenantMapper.getTenantByAppIdWithPage(tenantConditionVO, appId, pageNum, pageSize, authTenantIdValid);
        PageSerializable pageSerializable = new PageSerializable(tenantResultVOS);
        for (TenantResultVO tenantResultVO : tenantResultVOS) {
            List emails = this.userEmailService.getSuperAdminEmail(tenantResultVO.getTenantId());
            tenantResultVO.setEmails(emails);
        }
        return pageSerializable;
    }
}

