/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.service.tenant.impl;

import com.digiwin.dap.middleware.boss.service.tenant.MultiTenantsService;
import com.digiwin.dap.middleware.boss.support.remote.BossMessageService;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.auth.AuthDataDO;
import com.digiwin.dap.middleware.iam.domain.enumeration.ChangeTypeEnum;
import com.digiwin.dap.middleware.iam.domain.invoiceinfo.InvoiceInfoVO;
import com.digiwin.dap.middleware.iam.domain.tenant.CopyAppAuthVO;
import com.digiwin.dap.middleware.iam.domain.tenant.MultiTenantsVO;
import com.digiwin.dap.middleware.iam.domain.tenant.SubTenantVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantApplicationVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantInfoVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantSimpleVO;
import com.digiwin.dap.middleware.iam.entity.InvoiceInfo;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.SysInTenant;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.TenantCertification;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.mapper.SysMapper;
import com.digiwin.dap.middleware.iam.mapper.TenantMapper;
import com.digiwin.dap.middleware.iam.repository.SysInTenantRepository;
import com.digiwin.dap.middleware.iam.repository.TenantCertificationRepository;
import com.digiwin.dap.middleware.iam.service.authentication.TenantCertificationCrudService;
import com.digiwin.dap.middleware.iam.service.invoiceinfo.InvoiceInfoCrudService;
import com.digiwin.dap.middleware.iam.service.invoiceinfo.InvoiceInfoService;
import com.digiwin.dap.middleware.iam.service.invoiceinfo.InvoiceReceiversCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.support.initialize.TenantInitializeService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.OmcService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationResultVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.CacAuth;
import com.digiwin.dap.middleware.iam.util.SecretKeyUtil;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class MultiTenantsServiceImpl
implements MultiTenantsService {
    private static final Logger logger = LoggerFactory.getLogger(MultiTenantsServiceImpl.class);
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private RemoteEocService remoteEocService;
    @Autowired
    private TenantCertificationRepository tenantCertificationRepository;
    @Autowired
    private InvoiceInfoService invoiceInfoService;
    @Autowired
    private TenantInitializeService tenantInitializeService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private InvoiceInfoCrudService invoiceInfoCrudService;
    @Autowired
    private InvoiceReceiversCrudService invoiceReceiversCrudService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private TenantCertificationCrudService tenantCertificationCrudService;
    @Autowired
    private SysInTenantRepository sysInTenantRepository;
    @Autowired
    private SysMapper sysMapper;
    @Autowired
    private CacService cacService;
    @Autowired
    private BossMessageService bossMessageService;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private SysInTenantCrudService sysInTenantCrudService;
    @Autowired
    private OmcService omcService;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private ChangeLogService changeLogService;

    @Transactional(rollbackFor={Exception.class})
    public void creatSubTenantsBySource(Tenant sourceTenant, User user, MultiTenantsVO multiTenantsVO) {
        List subs = multiTenantsVO.getSubTenant();
        if (multiTenantsVO.getCreateSubTenant().booleanValue()) {
            TenantCertification sourceTenantCertification = this.tenantCertificationRepository.findByTenantSid(sourceTenant.getSid());
            InvoiceInfoVO invoiceInfoVO = this.invoiceInfoService.getInvoiceInfoContainReceiver(sourceTenant.getSid());
            subs.forEach(subTenant -> {
                Tenant tenant = this.createSubTenant(subTenant, sourceTenant, user);
                this.createOtherInfo(invoiceInfoVO, tenant, sourceTenantCertification);
                subTenant.setSid(Long.valueOf(tenant.getSid()));
                subTenant.setCustomerServiceCode(tenant.getCustomerId());
                subTenant.setPotentialCustomerId(tenant.getPotentialCustomerId());
            });
            this.createSysAuth(multiTenantsVO, user);
        } else {
            if (subs.isEmpty()) {
                return;
            }
            List tenantSimpleVOS = this.tenantMapper.getTenantSidsByTenantIds(subs.stream().map(SubTenantVO::getId).collect(Collectors.toList()));
            subs.forEach(subTenant -> {
                TenantSimpleVO tenantSimpleVO = tenantSimpleVOS.stream().filter(t -> t.getTenantId().equals(subTenant.getId())).findFirst().orElse(null);
                if (null == tenantSimpleVO) {
                    return;
                }
                subTenant.setSid(tenantSimpleVO.getTenantSid());
                subTenant.setCustomerServiceCode(tenantSimpleVO.getCustomerId());
                subTenant.setPotentialCustomerId(tenantSimpleVO.getPotentialCustomerId());
            });
            this.createSysAuth(multiTenantsVO, user);
        }
        this.copyRoleForServiceCloud(sourceTenant, multiTenantsVO);
    }

    public void checkMissingPlatform(Tenant sourceTenant, User user, MultiTenantsVO multiTenantsVO) {
        if (CollectionUtils.isEmpty((Collection)multiTenantsVO.getGoodsVO())) {
            return;
        }
        List allRelation = this.sysMapper.findPlatformBySysIds(multiTenantsVO.getAppId());
        Map sysIdToPlatformId = allRelation.stream().filter(Objects::nonNull).flatMap(item -> {
            List sysPlatForms = item.getPlatformVOS();
            String key = item.getId();
            return sysPlatForms.stream().filter(Objects::nonNull).map(value -> new AbstractMap.SimpleEntry<String, String>(key, (String)value));
        }).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        if (!CollectionUtils.isEmpty((Collection)allRelation)) {
            List platformAuths = this.cacService.queryAllAuthorization(sourceTenant.getId());
            ArrayList<TenantApplicationVO> platFormApplicationVos = new ArrayList<TenantApplicationVO>();
            for (TenantApplicationVO good : multiTenantsVO.getGoodsVO()) {
                if (!sysIdToPlatformId.containsKey(good.getId())) continue;
                List platformIds = sysIdToPlatformId.get(good.getId());
                for (String platformId : platformIds) {
                    if (multiTenantsVO.getAppId().contains(platformId)) continue;
                    platFormApplicationVos.add(this.addPlatform(good, platformId, platformAuths));
                    multiTenantsVO.getAppId().add(platformId);
                }
            }
            multiTenantsVO.getGoodsVO().addAll(platFormApplicationVos);
        }
    }

    private TenantApplicationVO addPlatform(TenantApplicationVO good, String platformId, List<AuthorizationResultVO> platformAuths) {
        AuthorizationResultVO platformAuth = platformAuths.stream().filter(p -> platformId.equalsIgnoreCase(p.getId())).findFirst().orElse(null);
        TenantApplicationVO platform = new TenantApplicationVO();
        platform.setId(platformId);
        platform.setTenantId(good.getTenantId());
        platform.setExpiredTime(good.getExpiredTime());
        platform.setEffectiveTime(good.getEffectiveTime());
        platform.setPlatform(Boolean.valueOf(true));
        if (platformAuth != null) {
            platform.setStrategySid(Long.valueOf(platformAuth.getLastStrategyId()));
            platform.setTotalUsage(String.valueOf(platformAuth.getTotalUsage()));
            for (AuthorizationModuleVO enabledModule : platformAuth.getEnabledModules()) {
                AuthorizationModuleVO module = new AuthorizationModuleVO();
                module.setId(enabledModule.getId());
                module.setName(enabledModule.getName());
                module.setExpiredTime(enabledModule.getExpiredTime());
                module.setTotalUsage(enabledModule.getTotalUsage());
                platform.getModules().add(module);
            }
        }
        return platform;
    }

    private void copyRoleForServiceCloud(Tenant sourceTenant, MultiTenantsVO multiTenantsVO) {
        List sysList = this.sysMapper.findByTenantSid(multiTenantsVO.getSid().longValue());
        if (!CollectionUtils.isEmpty((Collection)sysList) && sysList.stream().anyMatch(a -> "ServiceCloud".equals(a.getId()))) {
            ArrayList<String> roleIdFilter = new ArrayList<String>(Arrays.asList("mis", "endUser", "superUser"));
            for (SubTenantVO subTenantVO : multiTenantsVO.getSubTenant()) {
                this.tenantService.copyRole(Long.valueOf(sourceTenant.getSid()), subTenantVO.getSid(), null, null, roleIdFilter, false, false);
            }
        }
    }

    public Integer getMaxSubTenantNumber(Long sourceTenantSid) {
        int max = 0;
        List subtenantList = this.tenantCrudService.findBySourceTenantSid(sourceTenantSid.longValue());
        if (null != subtenantList && subtenantList.size() > 0) {
            for (Tenant t : subtenantList) {
                try {
                    int temp;
                    String subtenantId = t.getId();
                    if (subtenantId.length() <= 4) continue;
                    String interval = subtenantId.substring(subtenantId.length() - 4, subtenantId.length() - 3);
                    subtenantId = subtenantId.substring(subtenantId.length() - 3);
                    if (!"_".equals(interval) || (temp = Integer.parseInt(subtenantId)) <= max) continue;
                    max = temp;
                }
                catch (NumberFormatException e) {
                    throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
                }
            }
        }
        return max + 1;
    }

    private Tenant createSubTenant(SubTenantVO tenantVO, Tenant sourceTenant, User user) {
        Tenant tenant = new Tenant();
        BeanUtils.copyProperties((Object)sourceTenant, (Object)tenant);
        String tenantId = tenantVO.getId();
        if (StringUtils.isEmpty((Object)tenantId)) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_NOT_NULL);
        }
        tenant.setId(tenantId);
        tenant.setName(tenantVO.getName());
        tenant.setSourceTenantSid(sourceTenant.getSid());
        tenant.setSid(SnowFlake.getInstance().newId());
        tenant.setTestTenant(true);
        long tenantSid = this.tenantCrudService.create((BaseEntity)tenant);
        this.tenantInitializeService.initDefaultTenant(tenantId, tenantSid, user.getId(), user.getSid());
        if (this.userInTenantCrudService.findByUnionKey(tenantSid, user.getSid()) == null) {
            UserInTenant userInTenant = new UserInTenant();
            userInTenant.setTenantSid(tenantSid);
            userInTenant.setUserSid(user.getSid());
            this.userInTenantCrudService.create((BaseEntity)userInTenant);
            this.changeLogService.createChangeLog(ChangeTypeEnum.USER_DISABLE_UPDATE.getName(), (Object)userInTenant, "sid", String.valueOf(userInTenant.getSid()));
        }
        if (sourceTenant.isEoc()) {
            TenantInfoVO tenantInfoVO = new TenantInfoVO();
            tenantInfoVO.setSid(Long.valueOf(tenant.getSid()));
            tenantInfoVO.setId(tenant.getId());
            tenantInfoVO.setName(tenant.getName());
            this.remoteEocService.initialize(tenantInfoVO);
        }
        return tenant;
    }

    private void createOtherInfo(InvoiceInfoVO sourceInvoiceInfo, Tenant tenant, TenantCertification sourceTenantCertification) {
        if (sourceInvoiceInfo != null) {
            InvoiceInfo invoiceInfo = sourceInvoiceInfo.generateInvoiceInfo();
            invoiceInfo.setTenantSid(Long.valueOf(tenant.getSid()));
            List invoiceReceiversVOList = sourceInvoiceInfo.getReceivers();
            invoiceInfo.setSid(SnowFlake.getInstance().newId());
            this.invoiceInfoCrudService.create((BaseEntity)invoiceInfo);
            invoiceReceiversVOList.forEach(invoiceReceivers -> {
                invoiceReceivers.setSid(Long.valueOf(SnowFlake.getInstance().newId()));
                invoiceReceivers.setInvoiceSid(Long.valueOf(invoiceInfo.getSid()));
                this.invoiceReceiversCrudService.create((BaseEntity)invoiceReceivers.generateInvoiceReceivers());
            });
        }
        if (sourceTenantCertification != null && "TW".equals(this.envProperties.getCountry())) {
            TenantCertification tenantCertification = new TenantCertification();
            BeanUtils.copyProperties((Object)sourceTenantCertification, (Object)tenantCertification);
            tenantCertification.setTenantSid(tenant.getSid());
            tenantCertification.setSid(SnowFlake.getInstance().newId());
            this.tenantCertificationCrudService.create((BaseEntity)tenantCertification);
        }
    }

    private void createSysAuth(MultiTenantsVO multiTenantsVO, User user) {
        if (multiTenantsVO.getAppId().isEmpty()) {
            logger.warn("\u591a\u79df\u6237\u6388\u6743\u65f6\u6388\u6743\u7684\u5e94\u7528\u4e3a\u7a7a");
            return;
        }
        List sysList = this.sysMapper.findByTenantSid(multiTenantsVO.getSid().longValue());
        ArrayList sysInTenantList = new ArrayList();
        multiTenantsVO.getSubTenant().forEach(t -> multiTenantsVO.getAppId().forEach(o -> {
            Sys sys = sysList.stream().filter(s -> o.equals(s.getId())).findFirst().orElse(null);
            if (null == sys) {
                logger.error(String.format("\u5e94\u7528%s\u4e0d\u5b58\u5728", o));
                return;
            }
            if (!this.sysInTenantCrudService.existsByUnionKey(t.getSid().longValue(), sys.getSid())) {
                SysInTenant sysInTenant = new SysInTenant();
                String secretKey = SecretKeyUtil.getSecretKey((String)t.getId(), (String)o, (String)user.getId());
                sysInTenant.setSecretKey(secretKey);
                sysInTenant.setSysSid(sys.getSid());
                sysInTenant.setTenantSid(t.getSid().longValue());
                EntityUtils.setCreateFields((BaseEntity)sysInTenant);
                sysInTenantList.add(sysInTenant);
            }
        }));
        this.sysInTenantRepository.saveAll(sysInTenantList);
    }

    public void copyAppAuth(Tenant sourceTenant, User user, MultiTenantsVO multiTenantsVO) {
        CopyAppAuthVO copyAppAuthVO = new CopyAppAuthVO();
        copyAppAuthVO.setSourceTenantId(sourceTenant.getId());
        copyAppAuthVO.setAppIds(multiTenantsVO.getAppId());
        copyAppAuthVO.setCustomers(multiTenantsVO.getSubTenant());
        List cacAuths = this.cacService.getTenantsAndApps(copyAppAuthVO.getCustomers().stream().map(SubTenantVO::getId).collect(Collectors.toList()), copyAppAuthVO.getAppIds());
        if (0 == multiTenantsVO.getType()) {
            copyAppAuthVO.setSourceId("MultiTenantAuthorization");
            this.cacService.copyAppAuth(copyAppAuthVO);
            copyAppAuthVO.setCustomerId(sourceTenant.getCustomerId());
            copyAppAuthVO.setPotentialCustomerId(sourceTenant.getPotentialCustomerId());
            copyAppAuthVO.setType(Integer.valueOf(0));
            multiTenantsVO.getGoodsVO().forEach(a -> {
                a.setTotalUsage(null);
                SubTenantVO tenantVO = copyAppAuthVO.getCustomers().stream().filter(t -> t.getId().equals(a.getTenantId())).findFirst().orElse(null);
                a.setTenantSid(tenantVO.getSid());
                a.setCustomerServiceCode(tenantVO.getCustomerServiceCode());
                a.setPotentialCustomerId(tenantVO.getPotentialCustomerId());
                CacAuth cacAuth = cacAuths.stream().filter(c -> c.getTenantId().equals(a.getTenantId())).findFirst().orElse(null);
                if (cacAuth != null) {
                    AuthDataDO authDataDO = cacAuth.getApps().stream().filter(p -> p.getAppId().equals(a.getId())).findFirst().orElse(null);
                    a.setOldAuthInfo(authDataDO);
                }
            });
            copyAppAuthVO.setAuthorizations(multiTenantsVO.getGoodsVO());
            this.omcService.batchInitializeApps(copyAppAuthVO);
            this.bossMessageService.sendMultiTenantsAuthorizationToPM(copyAppAuthVO, multiTenantsVO.getGoodsVO(), sourceTenant, user.getName(), multiTenantsVO.getCreateSubTenant());
        } else {
            copyAppAuthVO.setSourceId("TestTenantAuthorization");
            copyAppAuthVO.setCustomerId(sourceTenant.getCustomerId());
            copyAppAuthVO.setPotentialCustomerId(sourceTenant.getPotentialCustomerId());
            copyAppAuthVO.setSourceCode(multiTenantsVO.getSourceCode());
            multiTenantsVO.getGoodsVO().forEach(a -> {
                SubTenantVO tenantVO = copyAppAuthVO.getCustomers().stream().filter(t -> t.getId().equals(a.getTenantId())).findFirst().orElse(null);
                a.setTenantSid(tenantVO.getSid());
                a.setCustomerServiceCode(tenantVO.getCustomerServiceCode());
                a.setPotentialCustomerId(tenantVO.getPotentialCustomerId());
                CacAuth cacAuth = cacAuths.stream().filter(c -> c.getTenantId().equals(a.getTenantId())).findFirst().orElse(null);
                if (cacAuth != null) {
                    AuthDataDO authDataDO = cacAuth.getApps().stream().filter(p -> p.getAppId().equals(a.getId())).findFirst().orElse(null);
                    a.setOldAuthInfo(authDataDO);
                }
            });
            copyAppAuthVO.setAuthorizations(multiTenantsVO.getGoodsVO());
            copyAppAuthVO.setType(Integer.valueOf(1));
            this.cacService.copyAppAuth(copyAppAuthVO);
            this.omcService.batchInitializeApps(copyAppAuthVO);
        }
    }

    public void createPendingPreOrders(Tenant sourceTenant, User user, MultiTenantsVO multiTenantsVO) {
        List goodsVOs = multiTenantsVO.getGoodsVO();
        List pendingPreOrders = goodsVOs.stream().filter(a -> a.getAuthorization() != null && a.getAuthorization() == 0).collect(Collectors.toList());
        if (pendingPreOrders.isEmpty()) {
            logger.info("\u6ca1\u6709\u5f85\u5f00\u901a\u5355");
            return;
        }
        MultiTenantsVO input = new MultiTenantsVO();
        input.setGoodsVO(pendingPreOrders);
        input.setSubTenant(multiTenantsVO.getSubTenant());
        this.omcService.copySubTenantPreOrders(input);
    }
}

