/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.service.user.impl;

import com.digiwin.dap.middleware.boss.domain.UserAssociatedInfoVO;
import com.digiwin.dap.middleware.boss.domain.UserInfoVO;
import com.digiwin.dap.middleware.boss.mapper.BossUserMapper;
import com.digiwin.dap.middleware.boss.service.user.BossUserQueryService;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.entity.BaseEntityWithId;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.form.IntellyIdentityVO;
import com.digiwin.dap.middleware.iam.domain.role.QueryRoleResultVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryUserInOrgResultVO;
import com.digiwin.dap.middleware.iam.domain.user.UserBasicInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.UserConditionVO;
import com.digiwin.dap.middleware.iam.domain.user.UserMetadataVO;
import com.digiwin.dap.middleware.iam.domain.usermapping.UserMappingQueryResultVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.mapper.UserInRoleMapper;
import com.digiwin.dap.middleware.iam.mapper.UserWholeMapper;
import com.digiwin.dap.middleware.iam.service.intelly.IntellyService;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataQueryService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInOrgQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BossUserQueryServiceImpl
implements BossUserQueryService {
    private Logger logger = LoggerFactory.getLogger(BossUserQueryServiceImpl.class);
    @Autowired
    private BossUserMapper bossUserMapper;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private UserInOrgQueryService userInOrgQueryService;
    @Autowired
    private UserInRoleMapper userInRoleMapper;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private MetadataQueryService metadataQueryService;
    @Autowired
    private UserWholeMapper userWholeMapper;
    @Autowired
    private IntellyService intellyService;

    public List<User> getUserInfoWithPage(int pageNum, int pageSize, UserConditionVO userConditionVO) {
        List users = this.bossUserMapper.getUsersWithPage(userConditionVO, pageNum, pageSize);
        Map identity = this.intellyService.batchGetIdentity(users.stream().map(BaseEntity::getSid).collect(Collectors.toList()), false, Boolean.valueOf(true));
        users.forEach(a -> a.setIdentity((IntellyIdentityVO)identity.get(a.getSid())));
        return users;
    }

    public UserInfoVO getUserBasicInfo(long userSid) {
        if (userSid == 0L) {
            throw new IllegalArgumentException("userSid is 0");
        }
        User user = (User)this.userCrudService.findBySid(userSid);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{userSid});
        }
        UserInfoVO userInfoVO = new UserInfoVO();
        userInfoVO.setUser(user);
        List userMetadata = this.metadataQueryService.queryUserMetadataByTenantSidAndUserSid(Long.valueOf(0L), Long.valueOf(userSid));
        userInfoVO.setMetadata(userMetadata);
        List userInTenants = this.userInTenantCrudService.queryUserJoinedTenant(userSid);
        if (userInTenants != null && userInTenants.size() > 0) {
            ArrayList<UserAssociatedInfoVO> userAssociatedInfoVOS = new ArrayList<UserAssociatedInfoVO>();
            for (UserInTenant userInTenant : userInTenants) {
                UserAssociatedInfoVO userAssociatedInfoVO = new UserAssociatedInfoVO();
                Tenant tenant = (Tenant)this.tenantCrudService.findBySid(userInTenant.getTenantSid());
                if (tenant == null) continue;
                this.logger.info("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\uff0c\u5b58\u5728\u79df\u6237\u5173\u8054\uff0c\u79df\u6237\u4e3a\u7a7a\uff0cuserSid\uff1a" + user.getSid() + "tenantSid:" + userInTenant.getTenantSid());
                List orgVOS = this.userInOrgQueryService.queryUserInOrgByUser(tenant.getSid(), user.getSid());
                List roleVOS = this.userInRoleMapper.queryUserInRoleByUser(tenant.getSid(), user.getSid());
                userAssociatedInfoVO.setTenant(tenant);
                userAssociatedInfoVO.setRole(roleVOS);
                userAssociatedInfoVO.setUserInOrg(orgVOS);
                userAssociatedInfoVOS.add(userAssociatedInfoVO);
            }
            userInfoVO.setUserAssociatedInfoVOS(userAssociatedInfoVOS);
        }
        Map identity = this.intellyService.batchGetIdentity(Collections.singletonList(userSid));
        userInfoVO.setIdentity((IntellyIdentityVO)identity.get(userSid));
        return userInfoVO;
    }

    public List<UserBasicInfoVO> getUsersWhole(long tenantSid, List<String> userIds) {
        if (userIds.isEmpty()) {
            return Collections.emptyList();
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        List users = this.userWholeMapper.findUsers(Long.valueOf(tenantSid), userIds);
        ArrayList<UserBasicInfoVO> userBasics = new ArrayList<UserBasicInfoVO>();
        if (users.isEmpty()) {
            userIds.forEach(userId -> {
                UserBasicInfoVO userBasic = new UserBasicInfoVO();
                User user = new User();
                user.setId(userId);
                userBasic.setUser(user);
                userBasic.setEffective(false);
                userBasics.add(userBasic);
            });
        } else {
            List userSids = users.stream().map(BaseEntity::getSid).collect(Collectors.toList());
            List userRoles = this.userWholeMapper.findUsersRole(Long.valueOf(tenantSid), userSids);
            List userOrgs = this.userWholeMapper.findUsersOrg(Long.valueOf(tenantSid), userSids);
            List userMetadatas = this.userWholeMapper.findUsersMetadata(Long.valueOf(tenantSid), userSids);
            List userMappings = this.userWholeMapper.findUsersMapping(Long.valueOf(tenantSid), userSids);
            List userInTenants = this.userWholeMapper.findUsersInTenant(Long.valueOf(tenantSid), userSids);
            Map<String, User> userMap = users.stream().collect(Collectors.toMap(BaseEntityWithId::getId, Function.identity(), BinaryOperator.maxBy(Comparator.comparingLong(BaseEntity::getSid))));
            Map<Long, List<QueryRoleResultVO>> roles = userRoles.stream().collect(Collectors.groupingBy(QueryRoleResultVO::getUserSid));
            Map<Long, List<QueryUserInOrgResultVO>> orgs = userOrgs.stream().collect(Collectors.groupingBy(QueryUserInOrgResultVO::getUserSid));
            Map<Long, List<UserMetadataVO>> metadatas = userMetadatas.stream().collect(Collectors.groupingBy(UserMetadataVO::getUserSid));
            Map<Long, List<UserMappingQueryResultVO>> mappings = userMappings.stream().collect(Collectors.groupingBy(UserMappingQueryResultVO::getUserSid));
            Map<Long, Boolean> tenants = userInTenants.stream().collect(Collectors.toMap(UserInTenant::getUserSid, BaseEntity::isDisabled));
            userIds.forEach(userId -> {
                UserBasicInfoVO userBasic = new UserBasicInfoVO();
                if (userMap.containsKey(userId)) {
                    User user = (User)userMap.get(userId);
                    if (tenant.getOwnerUserSid() == user.getSid()) {
                        user.setReadonly(true);
                    }
                    userBasic.setEffective(true);
                    userBasic.setEnabled(tenants.getOrDefault(user.getSid(), false) == false);
                    userBasic.setUser(user);
                    userBasic.setRole(roles.getOrDefault(user.getSid(), Collections.emptyList()));
                    userBasic.setUserInOrg(orgs.getOrDefault(user.getSid(), Collections.emptyList()));
                    userBasic.setMetadata(metadatas.getOrDefault(user.getSid(), Collections.emptyList()));
                    userBasic.setMapping(mappings.getOrDefault(user.getSid(), Collections.emptyList()));
                    userBasic.setUserInTag(Collections.emptyList());
                    userBasic.setDefaultOrg(Collections.emptyList());
                } else {
                    User user = new User();
                    user.setId(userId);
                    userBasic.setUser(user);
                    userBasic.setEffective(false);
                }
                userBasics.add(userBasic);
            });
        }
        return userBasics;
    }
}

