/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.service.user.impl;

import com.digiwin.dap.middleware.boss.service.user.CheckUserService;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.tenant.UpdateTenantInfoVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class CheckUserServiceImpl
implements CheckUserService {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;

    public boolean CheckUserForEmail(UpdateTenantInfoVO updateTenantInfoVO) {
        Assert.notNull((Object)updateTenantInfoVO.getEmail(), (String)"email is null");
        User user = this.userRepository.findFirstByEmailAndType(updateTenantInfoVO.getEmail(), Integer.valueOf(0));
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(updateTenantInfoVO.getSid());
        if (user == null || tenant == null) {
            return false;
        }
        if (user.getSid() == tenant.getOwnerUserSid()) {
            throw new BusinessException((ErrorHandler)I18nError.EMAIL_CREATOR_ERROR, new Object[]{updateTenantInfoVO.getEmail()});
        }
        UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenant.getSid(), user.getSid());
        if (userInTenant != null && userInTenant.isDisabled()) {
            throw new BusinessException((ErrorHandler)I18nError.EMAIL_USER_IS_DISABLE, new Object[]{updateTenantInfoVO.getEmail(), user.getId()});
        }
        if (userInTenant != null && userInTenant.isUserType()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_TYPE_ERROR);
        }
        return true;
    }
}

