/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.support.aspect;

import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.boss.domain.PermissionField;
import com.digiwin.dap.middleware.boss.service.permission.PermissionService;
import com.github.pagehelper.util.ExecutorUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class DataPolicyInterceptor
implements Interceptor {
    public static final String DATA_POLICY_QUERY = "findSysVOByTenantSid";
    private static final Logger logger = LoggerFactory.getLogger(DataPolicyInterceptor.class);
    private static final int PARAM_COUNT = 4;
    @Lazy
    @Autowired
    private PermissionService permissionService;

    public Object intercept(Invocation invocation) throws Throwable {
        CacheKey cacheKey;
        BoundSql boundSql;
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        Object parameter = args[1];
        RowBounds rowBounds = (RowBounds)args[2];
        ResultHandler resultHandler = (ResultHandler)args[3];
        Executor executor = (Executor)invocation.getTarget();
        if (args.length == 4) {
            boundSql = ms.getBoundSql(parameter);
            cacheKey = executor.createCacheKey(ms, parameter, rowBounds, boundSql);
        } else {
            cacheKey = (CacheKey)args[4];
            boundSql = (BoundSql)args[5];
        }
        String dataPolicySql = boundSql.getSql();
        if (ms.getId().endsWith(DATA_POLICY_QUERY)) {
            dataPolicySql = this.getSql(dataPolicySql);
        }
        BoundSql dataBoundSql = new BoundSql(ms.getConfiguration(), dataPolicySql, boundSql.getParameterMappings(), parameter);
        Map additionalParameters = ExecutorUtil.getAdditionalParameter((BoundSql)boundSql);
        for (String key : additionalParameters.keySet()) {
            dataBoundSql.setAdditionalParameter(key, additionalParameters.get(key));
        }
        return executor.query(ms, parameter, rowBounds, resultHandler, cacheKey, dataBoundSql);
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private String getSql(String sql) {
        StringBuilder dataSql = new StringBuilder();
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        String sys_sid_condition = " and sys.SID=0";
        if (null != authoredUser) {
            PermissionField permissionField = this.permissionService.getUserFieldPermission(authoredUser.getTenantSid(), authoredUser.getSid(), "BOSS");
            if (permissionField == null) {
                dataSql.append(sys_sid_condition);
                dataSql.insert(0, sql);
                return dataSql.toString();
            }
            if (permissionField.getHasAll().booleanValue()) {
                return sql;
            }
            List maps = permissionField.getFields();
            HashSet categoryList = new HashSet();
            HashSet goodsCodeList = new HashSet();
            if (permissionField.getFields() != null && !permissionField.getFields().isEmpty()) {
                for (Map map : maps) {
                    if (map.get("goodsCode") != null) {
                        Set goodsCodes = (Set)map.get("goodsCode");
                        goodsCodeList.addAll(goodsCodes);
                    }
                    if (map.get("categoryId") == null) continue;
                    Set categories = (Set)map.get("categoryId");
                    categoryList.addAll(categories);
                }
                if (!categoryList.contains("app") && (categoryList.contains("service") || categoryList.contains("course "))) {
                    dataSql.append(sys_sid_condition);
                } else if (!goodsCodeList.isEmpty()) {
                    dataSql.append(String.format(" and sys.ID in %s ", this.getSql(goodsCodeList)));
                }
                dataSql.insert(0, sql);
            } else {
                dataSql.append(sys_sid_condition);
                dataSql.insert(0, sql);
            }
        }
        return dataSql.toString();
    }

    private String getSql(Set<String> values) {
        StringBuilder sql = new StringBuilder("(");
        for (String value : values) {
            sql.append("'").append(value).append("',");
        }
        sql = new StringBuilder(sql.substring(0, sql.length() - 1) + ")");
        return sql.toString();
    }
}

