/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.support.auth;

import com.digiwin.dap.middle.support.DefaultDapSecuritySupport;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.mapper.SysMapper;
import com.digiwin.dap.middleware.iam.service.WhiteListService;
import com.digiwin.dap.middleware.iam.service.login.AuthoredUserService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class BossSecuritySupport
extends DefaultDapSecuritySupport {
    @Autowired
    private SysMapper sysMapper;
    @Autowired
    private WhiteListService whiteListService;
    @Autowired
    private AuthoredUserService authoredUserService;
    @Autowired
    private EnvProperties envProperties;

    public String[] getWhiteList() {
        return new String[]{"/webjars/**", "/swagger-resources/**", "/api/iam/v2/identity/login", "/api/iam/v2/identity/login/**", "/api/iam/v2/identity/token/refresh/app", "/api/iam/v2/identity/token/refresh/tenant", "/api/iam/v2/identity/token/refresh/user", "/api/iam/v2/identity/token/expired/user", "/api/iam/v2/identity/token/grant/ota", "/api/iam/v2/identity/token/grant/access", "/api/iam/v2/oauth/fii/**", "/v2/api-docs", "/swagger-resources", "/swagger-resources/**", "/configuration/ui", "/configuration/security", "/swagger-ui.html", "/webjars/**", "/api/boss/**/env/**", "/api/boss/v1/identity/**", "/api/boss/v1/health", "/api/permission/data/field", "/api/permission/data/schemas", "/api/permission/data/values", "/api/boss/v1/tenants/matching", "/api/boss/v1/contact/emails", "/api/boss/v1/contact/emails/superadmin", "/api/boss/v1/contact/emails/tenant/**", "/api/boss/v1/env/**", "/api/notice/emails", "/api/boss/v1/excel/**", "/api/boss/v1/white/list"};
    }

    public AuthoredSys getLoginSys(HttpServletRequest request, String appId) {
        Sys sys = this.sysMapper.findById(appId);
        return Sys.loginSys((Sys)sys);
    }

    public AuthoredUser getLoginUser(HttpServletRequest request, String token) {
        AuthoredUser authoredUser = super.getLoginUser(request, token);
        List whiteList = this.whiteListService.getWhiteList("WHITE_BOSS_API_URIS");
        if (whiteList.contains(request.getRequestURI())) {
            return authoredUser;
        }
        List bossAccessSys = this.whiteListService.getWhiteList("BOSS_ACCESS_SYS");
        String appId = AuthoredSys.obtainAppId((String)request.getHeader(GlobalConstants.HTTP_HEADER_APP_TOKEN_KEY));
        if ("DIGIWINIAPP".equals(authoredUser.getTenantId())) {
            if (appId == null) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_APPLICATION_CAN_NOT_ACCESS);
            }
            if ("DOC".equals(appId)) {
                return authoredUser;
            }
        } else {
            if (appId != null && bossAccessSys.contains(appId)) {
                return authoredUser;
            }
            if (!this.envProperties.getManagerTenant().equals(authoredUser.getTenantId())) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_USER_CAN_NOT_ACCESS);
            }
        }
        return authoredUser;
    }
}

