/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.support.remote.impl;

import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middle.stream.producer.ProducerService;
import com.digiwin.dap.middleware.boss.support.remote.BossMessageService;
import com.digiwin.dap.middleware.iam.domain.tenant.CopyAppAuthVO;
import com.digiwin.dap.middleware.iam.domain.tenant.MultiTenantMailVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantApplicationVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BossMessageServiceImpl
implements BossMessageService {
    private static final Logger logger = LoggerFactory.getLogger(BossMessageServiceImpl.class);
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private ProducerService producerService;

    public void sendMultiTenantsAuthorizationToPM(CopyAppAuthVO copyAppAuthVO, List<TenantApplicationVO> goodsVO, Tenant sourceTenant, String ownUserName, Boolean createSubTenant) {
        try {
            HashMap map = new HashMap();
            String createUserName = UserUtils.getUserName();
            String createUserId = UserUtils.getUserId();
            if (!createSubTenant.booleanValue()) {
                copyAppAuthVO.getAppIds().forEach(j -> {
                    ArrayList multiTenantMailVOS = new ArrayList();
                    goodsVO.forEach(k -> {
                        if (j.equals(k.getId())) {
                            MultiTenantMailVO multiTenantMailVO = new MultiTenantMailVO();
                            multiTenantMailVO.setGoodsName(k.getName());
                            multiTenantMailVO.setTotalUsage(k.getTotalUsage());
                            multiTenantMailVO.setExpireTime(k.getExpiredTime());
                            map.put("code", k.getId());
                            multiTenantMailVO.setSubTenantName(k.getTenantName());
                            multiTenantMailVO.setSubTenantId(k.getTenantId());
                            Tenant tenant = (Tenant)this.tenantCrudService.findById(k.getTenantId());
                            multiTenantMailVO.setCreateUserName(createUserName);
                            multiTenantMailVO.setCreateUserId(createUserId);
                            multiTenantMailVO.setSourceTenantName(sourceTenant.getName());
                            multiTenantMailVO.setSourceTenantId(sourceTenant.getId());
                            multiTenantMailVO.setCreateDate(LocalDateTime.now());
                            multiTenantMailVO.setOwnUserName(ownUserName);
                            multiTenantMailVO.setCreateDate(tenant.getCreateDate());
                            multiTenantMailVOS.add(multiTenantMailVO);
                        }
                        map.put("multiTenantMailVOS", multiTenantMailVOS);
                    });
                    MessageBody bossMessage = new MessageBody();
                    bossMessage.setOpType("BOSS_TENANTS_SUCCESS_PM");
                    bossMessage.setData((Object)map);
                    this.producerService.msg(bossMessage);
                });
            } else {
                for (TenantApplicationVO i : goodsVO) {
                    copyAppAuthVO.getAppIds().forEach(j -> {
                        ArrayList multiTenantMailVOS = new ArrayList();
                        copyAppAuthVO.getCustomers().forEach(o -> {
                            MultiTenantMailVO multiTenantMailVO = new MultiTenantMailVO();
                            multiTenantMailVO.setGoodsName(i.getName());
                            multiTenantMailVO.setTotalUsage(i.getTotalUsage());
                            multiTenantMailVO.setExpireTime(i.getExpiredTime());
                            map.put("code", i.getId());
                            multiTenantMailVO.setSubTenantName(o.getName());
                            multiTenantMailVO.setSubTenantId(o.getId());
                            Tenant tenant = (Tenant)this.tenantCrudService.findById(o.getId());
                            multiTenantMailVO.setCreateUserName(createUserName);
                            multiTenantMailVO.setCreateUserId(createUserId);
                            multiTenantMailVO.setSourceTenantName(sourceTenant.getName());
                            multiTenantMailVO.setSourceTenantId(sourceTenant.getId());
                            multiTenantMailVO.setCreateDate(LocalDateTime.now());
                            multiTenantMailVO.setOwnUserName(ownUserName);
                            multiTenantMailVO.setCreateDate(tenant.getCreateDate());
                            multiTenantMailVOS.add(multiTenantMailVO);
                        });
                        map.put("multiTenantMailVOS", multiTenantMailVOS);
                    });
                    MessageBody bossMessage = new MessageBody();
                    bossMessage.setOpType("BOSS_TENANTS_SUCCESS_PM");
                    bossMessage.setData(map);
                    this.producerService.msg(bossMessage);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u591a\u79df\u6237\u6388\u6743\u6210\u529f\u90ae\u4ef6\u81f3\u4ea7\u54c1\u7ecf\u7406\u5931\u8d25:" + e);
        }
    }
}

