/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.support.upgrade;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.entity.DataPolicySchema;
import com.digiwin.dap.middleware.iam.entity.DataPolicySchemaField;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.repository.DataPolicySchemaFieldRepository;
import com.digiwin.dap.middleware.iam.repository.SysRepository;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicySchemaCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Order(value=41800)
@Service
public class UpgradeDatabaseV417ToV418Service
extends AbstractUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV417ToV418Service.class);
    @Autowired
    private DataPolicySchemaCrudService dataPolicySchemaCrudService;
    @Autowired
    private DataPolicySchemaFieldRepository dataPolicySchemaFieldRepository;
    @Autowired
    private SysRepository sysRepository;
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private EnvProperties envProperties;

    public String version() {
        return "4.18.0.0";
    }

    @Transactional(rollbackFor={Exception.class})
    public void update() {
        logger.info("418\u6570\u636e\u5347\u7ea7\u5f00\u59cb {}", (Object)LocalDateTime.now());
        DataPolicySchema schema = new DataPolicySchema();
        schema.setActionId("logger-settings-app");
        schema.setTableId("AppSetting");
        schema.setTableName("\u65e5\u5fd7\u5e94\u7528\u8bbe\u7f6e");
        schema.setTableNameUS("Log configuration");
        schema.setTableNameTW("\u65e5\u8a8c\u61c9\u7528\u8a2d\u5b9a");
        logger.info("\u63d2\u5165schema...");
        long sid = this.dataPolicySchemaCrudService.create((BaseEntity)schema);
        DataPolicySchemaField field = new DataPolicySchemaField();
        field.setSchemaSid(sid);
        field.setDataSource(Integer.valueOf(1));
        field.setDataType("STRING");
        field.setFilterType("in");
        field.setId("appId");
        field.setName("\u5e94\u7528id");
        field.setNameUS("app id");
        field.setNameTW("\u61c9\u7528id");
        field.setValueParams(this.envProperties.getLmcUri() + "/api/lmc/v1/app/id/item");
        EntityUtils.setCreateFields((BaseEntity)field);
        logger.info("\u63d2\u5165field...");
        this.dataPolicySchemaFieldRepository.save((Object)field);
        Sys boss = (Sys)this.sysRepository.findById("BOSS");
        Sys mmc = (Sys)this.sysRepository.findById("MMC");
        if (boss != null && mmc != null) {
            mmc.setBackUri(boss.getBackUri());
            logger.info("\u66f4\u65b0 mmc backUri\uff1a{}", (Object)mmc.getBackUri());
            this.sysCrudService.update((BaseEntity)mmc);
        }
        logger.info("418\u6570\u636e\u5347\u7ea7\u7ed3\u675f {}", (Object)LocalDateTime.now());
    }
}

