/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.boss.util;

import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class Levenshtein {
    public static int editDistanceSimilarity(String left, String right) {
        double similarity;
        double distance;
        if (StringUtils.isEmpty((Object)left)) {
            left = "";
        }
        if (StringUtils.isEmpty((Object)right)) {
            left = "";
        }
        int maxLength = Math.max(left.length(), right.length());
        if (right.indexOf(left) > -1) {
            distance = Math.min(left.length(), right.length());
            similarity = distance / (double)maxLength;
        } else {
            distance = Levenshtein.editDistance((CharSequence)left, (CharSequence)right);
            similarity = 1.0 - distance / (double)maxLength;
        }
        int sim = (int)(similarity * 100.0);
        return sim;
    }

    public static int editDistance(CharSequence lhs, CharSequence rhs) {
        int len0 = lhs.length() + 1;
        int len1 = rhs.length() + 1;
        int[] cost = new int[len0];
        int[] newcost = new int[len0];
        for (int i = 0; i < len0; ++i) {
            cost[i] = i;
        }
        for (int j = 1; j < len1; ++j) {
            newcost[0] = j;
            for (int i = 1; i < len0; ++i) {
                int match = lhs.charAt(i - 1) == rhs.charAt(j - 1) ? 0 : 1;
                int cost_replace = cost[i - 1] + match;
                int cost_insert = cost[i] + 1;
                int cost_delete = newcost[i - 1] + 1;
                newcost[i] = Math.min(Math.min(cost_insert, cost_delete), cost_replace);
            }
            int[] swap = cost;
            cost = newcost;
            newcost = swap;
        }
        return cost[len0 - 1];
    }
}

