/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.api;

import com.alibaba.excel.EasyExcel;
import com.digiwin.dap.middleware.cac.domain.excel.StatByLineExcel;
import com.digiwin.dap.middleware.cac.domain.excel.StatByProductExcel;
import com.digiwin.dap.middleware.cac.domain.excel.StatDetailExcel;
import com.digiwin.dap.middleware.cac.domain.remote.AuthStatPageResultVO;
import com.digiwin.dap.middleware.cac.domain.remote.AuthStatVO;
import com.digiwin.dap.middleware.cac.mapper.StatMapper;
import com.digiwin.dap.middleware.domain.StdData;
import com.github.pagehelper.PageSerializable;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cac/v1/stat"})
public class AuthStatController {
    public static final String DEFAULT_LINE_ORDER_BY = "r.month,r.product_code";
    public static final String DEFAULT_PRODUCT_ORDER_BY = "r.month,r.product_code,r.goods_code";
    @Autowired
    private StatMapper statMapper;

    @PostMapping(value={"/by/product"})
    public StdData<?> getProduct(@RequestBody AuthStatVO vo) {
        vo.setOrderBy(Optional.ofNullable(vo.getOrderBy()).orElse(DEFAULT_PRODUCT_ORDER_BY));
        List result = this.statMapper.findByProduct(vo);
        return StdData.ok((Object)new PageSerializable(result));
    }

    @PostMapping(value={"/by/line"})
    public StdData<?> getLine(@RequestBody AuthStatVO vo) {
        vo.setOrderBy(Optional.ofNullable(vo.getOrderBy()).orElse(DEFAULT_LINE_ORDER_BY));
        List result = this.statMapper.findByLine(vo);
        return StdData.ok((Object)new PageSerializable(result));
    }

    @PostMapping(value={"/by/product/export"})
    public void exportProduct(@RequestBody AuthStatVO vo, HttpServletResponse response) throws Exception {
        vo.setOrderBy(Optional.ofNullable(vo.getOrderBy()).orElse(DEFAULT_PRODUCT_ORDER_BY));
        List result = this.statMapper.findByProduct(vo);
        List accountOrders = result.stream().map(StatByProductExcel::new).collect(Collectors.toList());
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        String fileName = URLEncoder.encode("\u5e94\u7528\u7edf\u8ba1", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        EasyExcel.write((OutputStream)response.getOutputStream(), StatByProductExcel.class).sheet("Sheet1").doWrite(accountOrders);
    }

    @PostMapping(value={"/by/line/export"})
    public void exportLine(@RequestBody AuthStatVO vo, HttpServletResponse response) throws Exception {
        vo.setOrderBy(Optional.ofNullable(vo.getOrderBy()).orElse(DEFAULT_LINE_ORDER_BY));
        List result = this.statMapper.findByLine(vo);
        List accountOrders = result.stream().map(StatByLineExcel::new).collect(Collectors.toList());
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        String fileName = URLEncoder.encode("\u7c7b\u522b\u7edf\u8ba1", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        EasyExcel.write((OutputStream)response.getOutputStream(), StatByLineExcel.class).sheet("Sheet1").doWrite(accountOrders);
    }

    @PostMapping(value={"/detail/export"})
    public void exportDetail(@RequestBody AuthStatVO vo, HttpServletResponse response) throws Exception {
        Set filter;
        List pageResult;
        vo.setPageNum(Integer.valueOf(1));
        vo.setPageSize(Integer.valueOf(999999));
        vo.setOrderBy(Optional.ofNullable(vo.getOrderBy()).orElse(DEFAULT_LINE_ORDER_BY));
        List result = this.statMapper.findDetail(vo);
        if ("product".equals(vo.getTab())) {
            vo.setOrderBy(Optional.ofNullable(vo.getOrderBy()).orElse(DEFAULT_PRODUCT_ORDER_BY));
            pageResult = this.statMapper.findByProduct(vo);
            filter = pageResult.stream().map(AuthStatPageResultVO::getGoodsCode).collect(Collectors.toSet());
            result.removeIf(a -> !filter.contains(a.getGoodsCode()));
        } else if ("line".equals(vo.getTab())) {
            pageResult = this.statMapper.findByLine(vo);
            filter = pageResult.stream().map(AuthStatPageResultVO::getProductCode).collect(Collectors.toSet());
            result.removeIf(a -> !filter.contains(a.getProductCode()));
        }
        List accountOrders = result.stream().map(StatDetailExcel::new).collect(Collectors.toList());
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        String fileName = URLEncoder.encode("\u660e\u7ec6", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        EasyExcel.write((OutputStream)response.getOutputStream(), StatDetailExcel.class).sheet("Sheet1").doWrite(accountOrders);
    }
}

