/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.api;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.cac.constant.I18nError;
import com.digiwin.dap.middleware.cac.constant.ResourceCategoryEnum;
import com.digiwin.dap.middleware.cac.domain.AuthorizationCheckRequest;
import com.digiwin.dap.middleware.cac.domain.AuthorizationCheckedVO;
import com.digiwin.dap.middleware.cac.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.cac.domain.AuthorizationModuleWithPurchaseVO;
import com.digiwin.dap.middleware.cac.domain.AuthorizationResult;
import com.digiwin.dap.middleware.cac.domain.AuthorizationVO;
import com.digiwin.dap.middleware.cac.domain.BatchCodeQueryRequest;
import com.digiwin.dap.middleware.cac.domain.CalcExpire;
import com.digiwin.dap.middleware.cac.domain.CancelAuth;
import com.digiwin.dap.middleware.cac.domain.CloudPurchaseDTO;
import com.digiwin.dap.middleware.cac.domain.CopyAppAuthVO;
import com.digiwin.dap.middleware.cac.domain.CustomAttributeByGoodsVO;
import com.digiwin.dap.middleware.cac.domain.CustomAttributeWithPurchaseVO;
import com.digiwin.dap.middleware.cac.domain.CustomQueryCondition;
import com.digiwin.dap.middleware.cac.domain.EditParamVO;
import com.digiwin.dap.middleware.cac.domain.InPackCheckResponse;
import com.digiwin.dap.middleware.cac.domain.MigrateAppVO;
import com.digiwin.dap.middleware.cac.domain.ObsoleteTenantAuthInfo;
import com.digiwin.dap.middleware.cac.domain.PackAuthExcel;
import com.digiwin.dap.middleware.cac.domain.PackRenewCheckResponse;
import com.digiwin.dap.middleware.cac.domain.ProductTypeVO;
import com.digiwin.dap.middleware.cac.domain.PurchaseModuleVO;
import com.digiwin.dap.middleware.cac.domain.PurchaseVO;
import com.digiwin.dap.middleware.cac.domain.QueryPageTenantVO;
import com.digiwin.dap.middleware.cac.domain.SearchParamVO;
import com.digiwin.dap.middleware.cac.domain.TenantPurchaseDTO;
import com.digiwin.dap.middleware.cac.domain.TenantPurchaseParameterVO;
import com.digiwin.dap.middleware.cac.domain.TenantPurchaseVO;
import com.digiwin.dap.middleware.cac.domain.UserAuthorizationInfoVO;
import com.digiwin.dap.middleware.cac.domain.enumeration.GoodsCategoryEnum;
import com.digiwin.dap.middleware.cac.domain.remote.GoodsVO;
import com.digiwin.dap.middleware.cac.domain.request.ResourceGoodsCheckRequest;
import com.digiwin.dap.middleware.cac.entity.Purchase;
import com.digiwin.dap.middleware.cac.entity.PurchaseCount;
import com.digiwin.dap.middleware.cac.entity.PurchaseModule;
import com.digiwin.dap.middleware.cac.mapper.PurchaseMapper;
import com.digiwin.dap.middleware.cac.service.basic.ApiGoodsCrudService;
import com.digiwin.dap.middleware.cac.service.basic.GoodsResourceCrudService;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCountCrudService;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCrudService;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseModuleCrudService;
import com.digiwin.dap.middleware.cac.service.business.AuthorizeArchiveService;
import com.digiwin.dap.middleware.cac.service.business.AuthorizeOtherService;
import com.digiwin.dap.middleware.cac.service.business.AuthorizeQueryService;
import com.digiwin.dap.middleware.cac.service.business.AuthorizeRegistrarService;
import com.digiwin.dap.middleware.cac.service.excel.ExcelService;
import com.digiwin.dap.middleware.cac.service.paymenttype.CalcUtil;
import com.digiwin.dap.middleware.cac.service.paymenttype.PaymentTypeContext;
import com.digiwin.dap.middleware.cac.support.remote.GmcService;
import com.digiwin.dap.middleware.cac.support.remote.IamService;
import com.digiwin.dap.middleware.cac.support.validate.AuthorizeValidationService;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.ErrorType;
import com.digiwin.dap.middleware.domain.Page;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.exception.StdError;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageSerializable;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.Transactional;
import javax.validation.Valid;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cac/v4/authorizations"})
public class AuthorizationsController {
    @Autowired
    private IamService iamService;
    @Autowired
    private GmcService gmcService;
    @Autowired
    private PurchaseMapper purchaseMapper;
    @Autowired
    private PurchaseCrudService purchaseCrudService;
    @Autowired
    private PaymentTypeContext paymentTypeContext;
    @Autowired
    private AuthorizeQueryService authorizeQueryService;
    @Autowired
    private AuthorizeOtherService authorizeOtherService;
    @Autowired
    private AuthorizeArchiveService authorizeArchiveService;
    @Autowired
    private AuthorizeRegistrarService authorizeRegistrarService;
    @Autowired
    private AuthorizeValidationService authorizeValidationService;
    @Autowired
    private PurchaseCountCrudService purchaseCountCrudService;
    @Autowired
    private GoodsResourceCrudService goodsResourceCrudService;
    @Autowired
    private PurchaseModuleCrudService purchaseModuleCrudService;
    @Autowired
    private ApiGoodsCrudService apiGoodsCrudService;
    @Autowired
    private ExcelService excelService;

    @Transactional(rollbackOn={Exception.class})
    @DeleteMapping
    public StdData<?> deletePurchase(@RequestBody List<CancelAuth> body) {
        body.forEach(o -> this.paymentTypeContext.deleteAuthorization(o));
        return StdData.ok().build();
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={""})
    public ResponseEntity<?> purchaseAuthorizations(@RequestBody List<PurchaseVO> body, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        TenantPurchaseVO tenantPurchaseVO = new TenantPurchaseVO(authoredUser.getTenantId(), authoredUser.getTenantName(), body);
        this.authorizeValidationService.checkTenantPurchaseVO(tenantPurchaseVO);
        this.authorizeArchiveService.purchaseAuthorization(tenantPurchaseVO);
        return ResponseEntity.ok((Object)HttpStatus.CREATED);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/calculate"})
    public StdData<?> calculateAuthorizations(@RequestBody PurchaseVO body, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        TenantPurchaseVO tenantPurchaseVO = new TenantPurchaseVO(authoredUser.getTenantId(), authoredUser.getTenantName(), body);
        this.authorizeValidationService.checkTenantPurchaseVO(tenantPurchaseVO);
        List results = this.authorizeArchiveService.calculateAuthorization(tenantPurchaseVO);
        if (results.size() > 0) {
            return StdData.ok(results.get(0));
        }
        return StdData.ok((Object)new CloudPurchaseDTO());
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/update"})
    public ResponseEntity<?> updateAuthorizations(@RequestBody EditParamVO body) {
        this.authorizeArchiveService.updatePurchaseAuthorization(body);
        return ResponseEntity.ok((Object)HttpStatus.CREATED);
    }

    @PostMapping(value={"/bufferperiod/update"})
    public StdData<?> updateAuthorizationsBufferPeriod(@RequestBody EditParamVO body) throws CloneNotSupportedException {
        Assert.hasText((String)body.getTenantId(), (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)body.getProductCode(), (String)"\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)body.getAuthorizationDays(), (String)"\u6388\u6743\u5929\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        this.authorizeArchiveService.updateAuthorizationsBufferPeriod(body);
        return StdData.ok().build();
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/batchupdate"})
    public ResponseEntity<?> batchUpdateAuthorizations(@RequestBody @Valid TenantPurchaseParameterVO body) {
        if (body.getModules().size() == 0) {
            throw new IllegalArgumentException(I18nError.ERROR_10021.getErrorMessage());
        }
        if (body.getAllChecked().booleanValue()) {
            List tenantIds = this.iamService.getTenantIdsByAppId(body.getAppId());
            body.setTenantIds(tenantIds);
        }
        if (body.getTenantIds() == null || body.getTenantIds().size() <= 0) {
            throw new IllegalArgumentException(I18nError.ERROR_10011.getErrorMessage());
        }
        this.authorizeArchiveService.batchUpdatePurchaseAuthorization(body);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @PostMapping(value={"/add/bundle"})
    public StdData<?> batchAddBundleChildren(@RequestBody @Valid TenantPurchaseParameterVO body) {
        this.authorizeArchiveService.batchAddBundleChildren(body);
        return StdData.ok().build();
    }

    @GetMapping(value={""})
    public ResponseEntity<?> getAuthorizations() {
        return ResponseEntity.ok((Object)this.authorizeQueryService.getAuthorizationInfos());
    }

    @GetMapping(value={"/category/{categoryId}"})
    public ResponseEntity<?> getAuthorizationsByCategoryId(@PathVariable(value="categoryId") String categoryId, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="createDateTime desc") String orderBy, @RequestParam(name="params", required=false) String params) {
        SearchParamVO searchParamVO = SearchParamVO.getSelf((String)params);
        GoodsCategoryEnum.getCategoryIds((String)categoryId);
        searchParamVO.flushCategoryIds(categoryId);
        PageSerializable authorizations = this.authorizeArchiveService.getAuthorizationByPage(searchParamVO, pageNum.intValue(), pageSize.intValue(), orderBy, Boolean.TRUE.booleanValue());
        return ResponseEntity.ok((Object)authorizations);
    }

    @GetMapping(value={"/info/export"})
    public void exportAuthorizations(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="99999") Integer pageSize, @RequestParam(name="orderBy", defaultValue="createDateTime desc") String orderBy, SearchParamVO searchParamVO, HttpServletResponse response) {
        searchParamVO.flushCategoryIds("app");
        this.excelService.exportAuthorizationInfo(searchParamVO, pageNum.intValue(), pageSize.intValue(), orderBy, response);
    }

    @GetMapping(value={"/category/{categoryId}/exclude/policy"})
    public ResponseEntity<?> getAuthorizationsExcludePolicy(@PathVariable(value="categoryId") String categoryId, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="createDateTime desc") String orderBy, @RequestParam(name="params", required=false) String params) {
        SearchParamVO searchParamVO = SearchParamVO.getSelf((String)params);
        searchParamVO.flushCategoryIds(categoryId);
        PageSerializable authorizations = this.authorizeArchiveService.getAuthorizationByPage(searchParamVO, pageNum.intValue(), pageSize.intValue(), orderBy, Boolean.FALSE.booleanValue());
        return ResponseEntity.ok((Object)authorizations);
    }

    @GetMapping(value={"/category/{categoryId}/servicer"})
    public ResponseEntity<?> getServicerAuthorizationsExcludePolicy(@PathVariable(value="categoryId") String categoryId, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="createDateTime desc") String orderBy, @RequestParam(name="params", required=false) String params, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        Assert.hasText((String)authoredUser.getTenantId(), (String)String.format("\u7528\u6237[%s]\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a", authoredUser.getUserId()));
        SearchParamVO searchParamVO = SearchParamVO.getSelf((String)params);
        searchParamVO.flushCategoryIds(categoryId);
        List servicerGoods = this.gmcService.getCurrentServicerGoods();
        if (CollectionUtils.isEmpty((Collection)servicerGoods)) {
            return ResponseEntity.ok((Object)new PageSerializable());
        }
        searchParamVO.setGoodsCodes(servicerGoods);
        PageSerializable authorizations = this.authorizeArchiveService.getAuthorizationByPage(searchParamVO, pageNum.intValue(), pageSize.intValue(), orderBy, Boolean.FALSE.booleanValue());
        return ResponseEntity.ok((Object)authorizations);
    }

    @GetMapping(value={"/tenants/{tenantId:.+}"})
    public ResponseEntity<?> getAuthorizationsByTenantId(@PathVariable(value="tenantId") String tenantId, @RequestParam(required=false) Boolean checkShelve, @RequestParam(required=false) Boolean countApiInvoke) {
        List authorizations = this.authorizeQueryService.getAuthorizations(tenantId, countApiInvoke);
        if (Boolean.TRUE.equals(checkShelve)) {
            Map goodsByGoodsIds = this.gmcService.getGoodsByGoodsIds(authorizations.stream().map(AuthorizationVO::getCode).collect(Collectors.toList()));
            for (AuthorizationVO authorization : authorizations) {
                authorization.setOnShelve(goodsByGoodsIds.getOrDefault(authorization.getCode(), new GoodsVO()).getOnSale());
            }
        }
        return ResponseEntity.ok((Object)authorizations);
    }

    @GetMapping(value={"/tenants/{tenantId:.+}/goods/{goodsCode}"})
    public ResponseEntity<?> getAuthorizationsByTenantIdAndGoodCode(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="goodsCode") String goodsCode) {
        return ResponseEntity.ok((Object)this.authorizeQueryService.getAuthorization(tenantId, goodsCode));
    }

    @GetMapping(value={"/tenants/{tenantId:.+}/goods/{goodsCode}/modules/unexpired"})
    public ResponseEntity<?> getAuthorizationsAndModulesUnexpiredByTenantIdAndGoodCode(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="goodsCode") String goodsCode) {
        return ResponseEntity.ok((Object)this.authorizeQueryService.getAuthorization(tenantId, goodsCode, Boolean.FALSE.booleanValue()));
    }

    @GetMapping(value={"/tenants/{tenantId:.+}/goods/{goodsCode}/modules"})
    public ResponseEntity<?> getModulesByTenantIdAndGoodsCode(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="goodsCode") String goodsCode) {
        AuthorizationModuleWithPurchaseVO authorizationModule = this.authorizeArchiveService.getAuthorizationModule(tenantId, goodsCode);
        return ResponseEntity.ok((Object)authorizationModule);
    }

    @GetMapping(value={"/tenants/{tenantId:.+}/goods/{goodsCode}/modules/ids"})
    public ResponseEntity<?> getModules(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="goodsCode") String goodsCode) {
        List modules = this.purchaseMapper.findModulesByTenantIdAndGoodsCode(tenantId, goodsCode);
        List moduleIds = modules.stream().filter(o -> LocalDateTime.now().isBefore(o.getExpiredDateTime())).map(PurchaseModuleVO::getModuleId).collect(Collectors.toList());
        return ResponseEntity.ok(moduleIds);
    }

    @Deprecated
    @GetMapping(value={"/tenants/{tenantId:.+}/goods/{goodsCode}/customAttributes"})
    public ResponseEntity<?> getAttributesByTenantIdAndGoodsCode(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="goodsCode") String goodsCode) {
        CustomAttributeWithPurchaseVO customAttributeWithPurchaseVO = this.authorizeArchiveService.getAuthorizationCustomAttribute(tenantId, goodsCode);
        return new ResponseEntity((Object)customAttributeWithPurchaseVO, HttpStatus.OK);
    }

    @Deprecated
    @PostMapping(value={"/update/tenants/{tenantId:.+}/goods/{goodsCode}/customAttributes"})
    public ResponseEntity<?> updateAttributesByTenantIdAndGoodsCode(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="goodsCode") String goodsCode, @RequestBody CustomAttributeByGoodsVO customAttribute) {
        return ResponseEntity.ok(Collections.singletonMap("status", "success"));
    }

    @GetMapping(value={"/tenants/{tenantId:.+}/users/{userId:.+}/enabled"})
    public ResponseEntity<?> getGoodsCodeByTenantIdAndUserId(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="userId") String userId) {
        return ResponseEntity.ok((Object)this.authorizeOtherService.findGoodsCode(tenantId, userId));
    }

    @GetMapping(value={"/tenants/{tenantId:.+}/users/{userId:.+}/goodCode/enabled"})
    public ResponseEntity<?> getRandomGoodsCodeByTenantIdAndUserId(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="userId") String userId) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        List goodsCodes = this.authorizeOtherService.findGoodsCode(tenantId, userId);
        resultMap.put("tenantId", tenantId);
        resultMap.put("userId", userId);
        resultMap.put("goodsCode", goodsCodes.isEmpty() ? "" : goodsCodes.get(0));
        return ResponseEntity.ok(resultMap);
    }

    @GetMapping(value={"/tenants/{tenantId:.+}/users/{userId:.+}/goods/{goodsCode}"})
    public ResponseEntity<?> checkGoodsAuthorization(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="userId") String userId, @PathVariable(value="goodsCode") String goodsCode) {
        AuthorizationCheckedVO authorizationChecked = this.authorizeArchiveService.checkUserCanUseProduct(tenantId, goodsCode, userId, Boolean.valueOf(true));
        return ResponseEntity.ok((Object)authorizationChecked);
    }

    @GetMapping(value={"/tenants/{tenantId:.+}/users/{userId:.+}/goods/{goodsCode}/isAuthorization"})
    public ResponseEntity<?> checkGoodsIsAuthorization(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="userId") String userId, @PathVariable(value="goodsCode") String goodsCode) {
        AuthorizationCheckedVO authorizationChecked = this.authorizeArchiveService.checkUserProductAuthorization(tenantId, goodsCode, userId);
        return ResponseEntity.ok((Object)authorizationChecked);
    }

    @GetMapping(value={"/{tenantId:.+}/{userId:.+}/{cloud}"})
    public ResponseEntity<?> getGoodsAuthorizations(@PathVariable String tenantId, @PathVariable String userId, @PathVariable Boolean cloud) {
        List authorizations = cloud != false ? this.authorizeQueryService.getAuthorizations(tenantId, userId) : this.authorizeQueryService.getAuthorizations(tenantId);
        return ResponseEntity.ok((Object)authorizations);
    }

    @GetMapping(value={"/tenants/{tenantId:.+}/users/{userId:.+}/goods/{goodsCode}/module/{moduleId}"})
    public ResponseEntity<?> checkModuleAuthorization(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="userId") String userId, @PathVariable(value="goodsCode") String goodsCode, @PathVariable(value="moduleId") String moduleId) {
        AuthorizationCheckedVO authorizationCheckedVO = this.authorizeArchiveService.checkUserCanUseModule(tenantId, goodsCode, moduleId, userId);
        return ResponseEntity.ok((Object)authorizationCheckedVO);
    }

    @GetMapping(value={"/tenants/{tenantId:.+}/users/{userId:.+}/goods/{goodsCode}/modules"})
    public ResponseEntity<?> checkModulesAuthorization(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="userId") String userId, @PathVariable(value="goodsCode") String goodsCode) {
        List moduleCheckedVOList = this.authorizeArchiveService.checkUserCanUseModules(tenantId, goodsCode, userId);
        return ResponseEntity.ok((Object)moduleCheckedVOList);
    }

    @GetMapping(value={"/tenants/goods/{goodsCode}"})
    public ResponseEntity<?> getTenantsByGoodsCode(@PathVariable(value="goodsCode") String goodsCode, @RequestParam(defaultValue="false") Boolean excludeName) {
        return ResponseEntity.ok((Object)this.authorizeOtherService.findTenants(goodsCode, excludeName.booleanValue()));
    }

    @GetMapping(value={"/tenants/goods/search"})
    public StdData<?> getPageTenantsByGoodsCode(Page page, QueryPageTenantVO queryPageTenantVO) {
        if (!StringUtils.hasText((String)queryPageTenantVO.getGoodsCode())) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.VALIDATION);
        }
        PageSerializable list = this.authorizeOtherService.findTenants(page, queryPageTenantVO);
        return StdData.ok((Object)list);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/tenants/goods/expire"})
    public ResponseEntity<?> updateExpiredDateTime(@RequestBody ProductTypeVO productType) {
        this.authorizeRegistrarService.updateExpiredDateTime(productType);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/tenants/goods/module/expire"})
    public ResponseEntity<?> updateGoodsAndModuleExpiredDateTime(@RequestBody ProductTypeVO productType) {
        this.authorizeRegistrarService.updateGoodsAndModuleExpiredDateTime(productType);
        return ResponseEntity.ok().build();
    }

    @Transactional(rollbackOn={Exception.class})
    @DeleteMapping(value={"/tenants/{tenantId:.+}"})
    public ResponseEntity<?> deleteTenantAuth(@PathVariable(value="tenantId") String tenantId) {
        this.authorizeRegistrarService.deletePurchaseByTenantId(tenantId);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/willexpired/apps"})
    public ResponseEntity<?> getWillExpiredApps(@RequestBody SearchParamVO dto) {
        List purchases = this.purchaseMapper.findPurchaseDetail(Collections.singletonList("app"), dto.getBeginTime(), dto.getEndTime());
        return ResponseEntity.ok((Object)purchases);
    }

    @PostMapping(value={"/willexpired"})
    public ResponseEntity<?> getWillExpired(@RequestBody SearchParamVO dto) {
        List purchases = this.purchaseMapper.findPurchaseDetail(dto.getProductTypes(), dto.getBeginTime(), dto.getEndTime());
        return ResponseEntity.ok((Object)purchases);
    }

    @PostMapping(value={"/willexpired/apps/query"})
    public ResponseEntity<?> queryWillExpiredApps(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="expiredTime") String orderBy, @RequestParam(name="params", required=false) String params) {
        SearchParamVO searchParamVO = SearchParamVO.getSelf((String)params);
        PageSerializable getPurchaseDetailVOs = this.authorizeArchiveService.queryAuthExpireGoods(searchParamVO, pageNum.intValue(), pageSize.intValue(), orderBy);
        return ResponseEntity.ok((Object)getPurchaseDetailVOs);
    }

    @PostMapping(value={"/willexpired/apps/query/new"})
    public ResponseEntity<?> queryWillExpiredApps2(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="expiredTime") String orderBy, @RequestBody SearchParamVO searchParamVO) {
        PageSerializable getPurchaseDetailVOs = this.authorizeArchiveService.queryAuthExpireGoods(searchParamVO, pageNum.intValue(), pageSize.intValue(), orderBy);
        return ResponseEntity.ok((Object)getPurchaseDetailVOs);
    }

    @PostMapping(value={"/tenants/{tenantId:.+}/goods/{goodscode}/appcansetauthtime"})
    public ResponseEntity<?> getAppCanSetAuthTime(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="goodscode") String goodsCode) {
        CloudPurchaseDTO cloudPurchaseDTO = this.authorizeQueryService.getCloudPurchase(tenantId, goodsCode);
        HashMap<String, Boolean> responseMap = new HashMap<String, Boolean>();
        if (cloudPurchaseDTO == null) {
            responseMap.put("setAuthEffectiveTime", true);
        } else {
            responseMap.put("setAuthEffectiveTime", false);
        }
        return ResponseEntity.ok(responseMap);
    }

    @PostMapping(value={"/tenants/{tenantId:.+}/goods/{goodscode}/getauthusernumber"})
    public ResponseEntity<?> getAppAuthUserNumber(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="goodscode") String goodsCode) {
        CloudPurchaseDTO cloudPurchaseDTO = this.authorizeQueryService.getCloudPurchase(tenantId, goodsCode);
        HashMap<String, Integer> responseMap = new HashMap<String, Integer>();
        if (cloudPurchaseDTO == null) {
            responseMap.put("authUserNumber", 0);
            responseMap.put("userCount", 0);
            return new ResponseEntity(responseMap, HttpStatus.OK);
        }
        responseMap.put("authUserNumber", cloudPurchaseDTO.getTotalCount());
        responseMap.put("userCount", cloudPurchaseDTO.getUserCount());
        return ResponseEntity.ok(responseMap);
    }

    @PostMapping(value={"copyappauth"})
    @Transactional(rollbackOn={Exception.class})
    public ResponseEntity<?> copyAppAuth(@RequestBody CopyAppAuthVO copyAppAuthVO) {
        this.authorizeValidationService.checkCopyAuthorization(copyAppAuthVO);
        this.authorizeArchiveService.copyAppAuthToChildTenants(copyAppAuthVO);
        return ResponseEntity.ok((Object)StdData.ok().build());
    }

    @PostMapping(value={"/obsolete/appauth"})
    @Transactional(rollbackOn={Exception.class})
    public ResponseEntity<?> obsoleteAppAuth(@RequestBody List<ObsoleteTenantAuthInfo> tenantAuthInfos) {
        this.authorizeValidationService.checkObsoleteAuthorization(tenantAuthInfos);
        return ResponseEntity.ok((Object)this.authorizeArchiveService.obsoleteAuthorization(tenantAuthInfos));
    }

    @PostMapping(value={"/copy/auth/source/app"})
    @Transactional(rollbackOn={Exception.class})
    public ResponseEntity<?> copyAuthFromSourceApp(@RequestBody CopyAppAuthVO copyAppAuthVO) {
        this.authorizeValidationService.checkCopySourceAppAuthorization(copyAppAuthVO);
        this.authorizeArchiveService.copyAuthFromSourceApp(copyAppAuthVO);
        return ResponseEntity.ok((Object)StdData.ok().build());
    }

    @PostMapping(value={"copyappauth/compareresult"})
    public ResponseEntity<?> getCompareResult(@Validated @RequestBody CopyAppAuthVO copyAppAuthVO) {
        List authCompareResultVOS = this.authorizeArchiveService.getCompareResult(copyAppAuthVO);
        return ResponseEntity.ok((Object)StdData.ok((Object)authCompareResultVOS));
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/remove/tenant/goods"})
    public StdData<?> removeTenantGoods(@Validated @RequestBody CancelAuth body) {
        Purchase purchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(body.getTenantId(), body.getGoodsCode());
        return StdData.ok((Object)this.purchaseCrudService.deletePurchase(purchase));
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/remove/goods"})
    public StdData<?> removeGoods(@Validated @RequestBody CancelAuth body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        List whiteList = this.iamService.getWhiteList("GOODS_OPERATION_ADMINS");
        if (!whiteList.contains(authoredUser.getUserId())) {
            return StdData.of((int)401, (String)String.format("\u7528\u6237[%s]\u7981\u6b62\u64cd\u4f5c", authoredUser.getUserId()));
        }
        List purchases = this.purchaseCrudService.findByGoodsCode(body.getGoodsCode());
        return StdData.ok((Object)this.purchaseCrudService.deletePurchase(purchases));
    }

    @PostMapping(value={"/tenant/user/goods/check"})
    public ResponseEntity<?> checkGoodsAuthorization(@RequestBody AuthorizationCheckRequest body) {
        AuthorizationCheckedVO authorizationCheckedVO = this.authorizeArchiveService.checkUserCanUsePlatformProduct(body.getTenantId(), body.getGoodsCode(), body.getUserId(), body.getApps(), body.getTenants(), body.getCheckUserAuth());
        authorizationCheckedVO.setPlatformIds(body.getPlatformApps());
        return ResponseEntity.ok((Object)authorizationCheckedVO);
    }

    @PostMapping(value={"/tenant/goods/check"})
    public StdData<?> checkGoods(@RequestBody AuthorizationCheckRequest body) {
        AuthorizationResult result = this.getAuthorizationResult(body);
        return StdData.ok((Object)result);
    }

    @NotNull
    private AuthorizationResult getAuthorizationResult(AuthorizationCheckRequest body) {
        Purchase purchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(body.getTenantId(), body.getGoodsCode());
        if (purchase == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10012, new Object[]{body.getTenantId(), body.getGoodsCode()});
        }
        PurchaseCount purchaseCount = this.purchaseCountCrudService.findByPurchaseId(purchase.getId());
        List purchaseModules = this.purchaseModuleCrudService.findByPurchaseId(purchase.getId());
        AuthorizationResult result = this.buildAuthResult(purchase, purchaseCount, purchaseModules);
        result.setApiGoods(this.apiGoodsCrudService.list(body.getGoodsCode()));
        return result;
    }

    @PostMapping(value={"/tenant/resource/goods/check"})
    public Object checkResourceGoods(@RequestBody ResourceGoodsCheckRequest body) {
        AuthorizationResult result;
        if (Objects.equals(ResourceCategoryEnum.OTHER.getCategory(), body.getResourceCategory()) && !StringUtils.hasLength((String)body.getGoodsCode())) {
            throw new BusinessException((ErrorHandler)I18nError.CAC_PARAM_EMPTY, new Object[]{"goodsCode"});
        }
        if (StrUtils.isNotEmpty((String)body.getGoodsCode())) {
            result = this.getAuthorizationResult(body.check());
        } else {
            Purchase purchase = this.goodsResourceCrudService.findByCodeAndResourceCategory(body.getTenantId(), body.getMainCode(), body.getResourceCategory());
            if (purchase == null) {
                throw new BusinessException(String.format("\u79df\u6237(%s)\u6ca1\u6709\u8d2d\u4e70\u4e3b\u5546\u54c1(%s)\u7684\u8ba1\u91cf\u5546\u54c1(%s)", body.getTenantId(), body.getMainCode(), body.getResourceCategory()));
            }
            PurchaseCount purchaseCount = this.purchaseCountCrudService.findByPurchaseId(purchase.getId());
            result = this.buildAuthResult(purchase, purchaseCount, new ArrayList());
        }
        if (result.getRemainUsage() != null && result.getRemainUsage() <= 0) {
            StdError stdError = StdError.of((String)"CAC", (String)ErrorType.Business.name(), (ErrorHandler)I18nError.CAC_TENANT_RESOURCE_USAGE_EXHAUSTED_ERROR, null);
            stdError.setCode(Integer.valueOf(500));
            stdError.setMessage("\u7528\u91cf\u5df2\u8017\u5c3d");
            stdError.setSuccess(Boolean.valueOf(false));
            return stdError;
        }
        return StdData.ok((Object)result);
    }

    private AuthorizationResult buildAuthResult(Purchase purchase, PurchaseCount purchaseCount, List<PurchaseModule> purchaseModules) {
        AuthorizationResult result = new AuthorizationResult();
        result.setTenantId(purchase.getCustomerId());
        result.setGoodsCode(purchase.getProductCode());
        result.setPaymentType(Integer.valueOf(purchaseCount.getPaymentType()));
        result.setTotalUsage(Integer.valueOf(purchaseCount.getTotalUsageBound()));
        result.setRemainUsage(Integer.valueOf(purchaseCount.getRemainUsageBound()));
        result.setModules(purchaseModules.stream().map(AuthorizationModuleVO::new).collect(Collectors.toList()));
        return result;
    }

    @PostMapping(value={"/tenant/app/willexpired"})
    public StdData getWillExpiredByTenant(@RequestBody Map<String, Object> objectMap) {
        List tenantIds = null;
        List appIds = null;
        String beginTime = null;
        String endTime = null;
        if (objectMap.containsKey("tenantIds")) {
            tenantIds = (List)objectMap.get("tenantIds");
        }
        if (objectMap.containsKey("appIds")) {
            appIds = (List)objectMap.get("appIds");
        }
        if (objectMap.containsKey("beginTime")) {
            beginTime = (String)objectMap.get("beginTime");
        }
        if (objectMap.containsKey("endTime")) {
            endTime = (String)objectMap.get("endTime");
        }
        Boolean showDetail = false;
        if (objectMap.containsKey("showDetail")) {
            showDetail = (Boolean)objectMap.get("showDetail");
        }
        if (showDetail.booleanValue()) {
            List authorizationVOS = this.purchaseMapper.findAuthsInTenants(tenantIds, appIds);
            authorizationVOS.forEach(a -> a.updateTotalUsage());
            return StdData.ok((Object)authorizationVOS);
        }
        List appAuthUserVOS = this.purchaseMapper.findAppsByParams(tenantIds, appIds, beginTime, endTime);
        return StdData.ok((Object)appAuthUserVOS);
    }

    @PostMapping(value={"/app/tenant/user/auth/check"})
    public ResponseEntity<?> checkAuth(@RequestBody TenantPurchaseParameterVO parameterVO) {
        if (StringUtils.isEmpty((Object)parameterVO.getAppId())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10009);
        }
        if (StringUtils.isEmpty((Object)parameterVO.getUserId())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10010);
        }
        if (parameterVO.getTenantIds().isEmpty()) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10011);
        }
        List appAuthUserVOS = this.authorizeArchiveService.checkAuthResult(parameterVO.getAppId(), parameterVO.getUserId(), parameterVO.getTenantIds());
        return ResponseEntity.ok((Object)appAuthUserVOS);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/app/tenant/user/auth"})
    public ResponseEntity<?> addAuth(@RequestBody TenantPurchaseVO purchaseVO) {
        this.authorizeValidationService.checkTenantPurchaseVO(purchaseVO);
        if (purchaseVO.isAuthUser() && StringUtils.isEmpty((Object)purchaseVO.getUserId())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10010);
        }
        this.authorizeArchiveService.purchaseAuthorizationWithCountUser(purchaseVO);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @GetMapping(value={"/tenants/goods/module"})
    public StdData<?> getGoodsAndTenantAuthorizationByModule(@RequestParam String moduleId, @RequestParam(required=false) Boolean test) {
        return StdData.ok((Object)this.authorizeQueryService.getAuthorizationInfoByModuleId(moduleId, test));
    }

    @PostMapping(value={"/tenants/goods/calc/expire"})
    public ResponseEntity<?> calcExpire(@RequestBody CalcExpire body) {
        body.afterPropertiesSet();
        Purchase purchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(body.getTenantId(), body.getGoodsCode());
        if (purchase == null) {
            CalcUtil.calcNewPurchaseExpiredTime((CalcExpire)body);
        } else {
            body.setPurchaseActualDate(purchase.getExpiredDateTime());
            CalcUtil.calcUpdatePurchaseExpiredTime((CalcExpire)body);
        }
        return ResponseEntity.ok((Object)body);
    }

    @PostMapping(value={"/tenants/auth/date"})
    public StdData<?> calcExpire(@RequestBody SearchParamVO searchParamVO) {
        return StdData.ok((Object)this.authorizeQueryService.findByDate(searchParamVO.getBeginTime(), searchParamVO.getEndTime()));
    }

    @PostMapping(value={"/tenant/goods/initialize/update"})
    public StdData updateInitializeState(@RequestBody AuthorizationVO authorizationVO) {
        this.purchaseCrudService.updateInitializeState(authorizationVO.getTenantId(), authorizationVO.getCode(), authorizationVO.getInitialize());
        return StdData.ok().build();
    }

    @PostMapping(value={"/custom/query"})
    public ResponseEntity<?> customQueryAuthorization(@RequestBody @Valid CustomQueryCondition queryCondition) {
        return ResponseEntity.ok((Object)this.authorizeQueryService.findByCondition(queryCondition));
    }

    @GetMapping(value={"/isv/tenants"})
    public StdData getIsvAppAuthorization(@RequestParam(value="tenantId") String tenantId, @RequestParam(value="pageSize", required=false, defaultValue="500") Integer pageSize) {
        if (StringUtils.isEmpty((Object)tenantId)) {
            if (StringUtils.isEmpty((Object)UserUtils.getTenantId())) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_10019);
            }
            tenantId = UserUtils.getTenantId();
        }
        List authTenants = this.authorizeOtherService.findTenantsByIsvApps(tenantId);
        return StdData.ok((Object)authTenants);
    }

    @PostMapping(value={"/tenant/apps/users"})
    public StdData<?> getAppAuthorizationUsers(@RequestBody UserAuthorizationInfoVO tenantAuthInfo) {
        Assert.hasText((String)tenantAuthInfo.getTenantId(), (String)"\u79df\u6237Id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Collection)tenantAuthInfo.getAppIds(), (String)"\u5e94\u7528\u6e05\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        return StdData.ok((Object)this.authorizeOtherService.findAuthUsersInApps(tenantAuthInfo.getTenantId(), tenantAuthInfo.getAppIds()));
    }

    @PostMapping(value={"/bundle/unbundle"})
    public StdData<?> getAppAuthorizationUsers(@RequestBody AuthorizationVO vo) {
        this.authorizeOtherService.unbundle(vo.getPurchaseId());
        return StdData.ok().build();
    }

    @PostMapping(value={"/current/strategy"})
    public StdData<?> getCurrentStrategy(@RequestBody(required=false) AuthorizationVO vo) {
        String appId = Optional.ofNullable(vo).map(AuthorizationVO::getCode).orElse(UserUtils.getSysId());
        if (ObjectUtils.isEmpty((Object)appId)) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10009);
        }
        return StdData.ok((Object)this.authorizeOtherService.getCurrentStrategy(appId, UserUtils.getTenantId()));
    }

    @PostMapping(value={"/tenants/goods/simple"})
    public StdData<?> getTenantsByGoodsCode(@RequestBody AuthorizationCheckRequest vo) {
        return StdData.ok((Object)this.authorizeOtherService.findTenantAuth(vo.getGoodsCode()));
    }

    @PostMapping(value={"/remove/dev"})
    public StdData<?> removeDev(@Validated @RequestBody CancelAuth body) {
        Assert.hasText((String)body.getTenantId(), (String)"TenantId:\u79df\u6237id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        ArrayList purchases = new ArrayList();
        if (StringUtils.hasLength((String)body.getGoodsCode())) {
            purchases.addAll(this.purchaseCrudService.findByGoodsCode(body.getGoodsCode()));
        } else if (Boolean.TRUE.equals(body.getDevGoods())) {
            List devGoods = this.iamService.getDevSys(body.getTenantId());
            if (!devGoods.isEmpty()) {
                purchases.addAll(this.purchaseCrudService.findByGoodsCodeIn(devGoods));
            }
        } else {
            purchases.addAll(this.purchaseCrudService.findByTenantId(body.getTenantId()));
        }
        return StdData.ok((Object)this.purchaseCrudService.deletePurchase(purchases));
    }

    @PostMapping(value={"/tenants/expire/modules"})
    public StdData<?> expireCertainModules(@RequestBody MigrateAppVO vo) {
        Assert.hasText((String)vo.getTargetAppId(), (String)"\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Collection)vo.getOldModuleIds(), (String)"oldModuleIds\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        this.authorizeOtherService.expireModules(vo);
        return StdData.ok().build();
    }

    @GetMapping(value={"/tenants/app/updateerp"})
    public StdData<?> findUpdateErpTenant(TenantPurchaseDTO dto) {
        return StdData.ok((Object)this.authorizeQueryService.findUpdateErpTenant(dto));
    }

    @GetMapping(value={"/batch/detail"})
    public StdData<?> findBatchDetail(BatchCodeQueryRequest input) {
        List result = this.authorizeQueryService.findBatchDetail(input);
        return StdData.ok((Object)result);
    }

    @GetMapping(value={"/pack/renew/check"})
    public StdData<?> checkPackRenew(@RequestParam String batchCode) {
        PackRenewCheckResponse result = this.authorizeQueryService.checkPackRenew(batchCode);
        return StdData.ok((Object)result);
    }

    @GetMapping(value={"/pack/export"})
    public void exportAccountOrders(Page page, SearchParamVO condition, HttpServletResponse response) throws Exception {
        condition.flushCategoryIds(condition.getCategoryId());
        List orders = this.purchaseMapper.findPurchases(condition, page.getPageNum().intValue(), page.getPageSize().intValue(), page.getOrderBy());
        ArrayList accountOrders = new ArrayList();
        orders.forEach(o -> accountOrders.add(new PackAuthExcel(o)));
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        String fileName = URLEncoder.encode("pack", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), PackAuthExcel.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet("Sheet1").doWrite(accountOrders);
    }

    @GetMapping(value={"/pack/check"})
    public StdData<?> checkInPack(@RequestParam(required=false) String goodsCode, @RequestParam(required=false) String batchCode, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        InPackCheckResponse result = this.authorizeQueryService.checkInPack(goodsCode, authoredUser.getTenantId(), batchCode);
        return StdData.ok((Object)result);
    }
}

