/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.cac.constant.I18nError;
import com.digiwin.dap.middleware.cac.domain.AuthCompareResultVO;
import com.digiwin.dap.middleware.cac.domain.AuthorizationCheckedVO;
import com.digiwin.dap.middleware.cac.domain.AuthorizationModuleWithPurchaseVO;
import com.digiwin.dap.middleware.cac.domain.AuthorizationVO;
import com.digiwin.dap.middleware.cac.domain.BatchCodeQueryRequest;
import com.digiwin.dap.middleware.cac.domain.CurrentTenantQueryDTO;
import com.digiwin.dap.middleware.cac.domain.CustomAttributeWithPurchaseVO;
import com.digiwin.dap.middleware.cac.domain.SearchParamVO;
import com.digiwin.dap.middleware.cac.domain.request.UpdateUsageAlertInfoRequest;
import com.digiwin.dap.middleware.cac.entity.Purchase;
import com.digiwin.dap.middleware.cac.entity.PurchaseCount;
import com.digiwin.dap.middleware.cac.service.basic.CustomerCrudService;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCountCrudService;
import com.digiwin.dap.middleware.cac.service.basic.PurchaseCrudService;
import com.digiwin.dap.middleware.cac.service.business.AuthorizeArchiveService;
import com.digiwin.dap.middleware.cac.service.business.AuthorizeOtherService;
import com.digiwin.dap.middleware.cac.service.business.AuthorizeQueryService;
import com.digiwin.dap.middleware.cac.support.remote.IamService;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.Page;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.StringUtils;
import com.github.pagehelper.PageSerializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cac/v4/authorizations"})
public class AuthorizationsTenantController {
    @Autowired
    private CustomerCrudService customerCrudService;
    @Autowired
    private AuthorizeQueryService authorizeQueryService;
    @Autowired
    private AuthorizeOtherService authorizeOtherService;
    @Autowired
    private AuthorizeArchiveService authorizeArchiveService;
    @Autowired
    private IamService iamService;
    @Autowired
    private PurchaseCrudService purchaseCrudService;
    @Autowired
    private PurchaseCountCrudService purchaseCountCrudService;

    @GetMapping(value={"/currentTenant"})
    public ResponseEntity<?> getAuthorizationByCurrent(@RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        return ResponseEntity.ok((Object)this.authorizeQueryService.getAuthorizationInfo(authoredUser.getTenantId()));
    }

    @GetMapping(value={"/currentTenant/goods/{goodsCode}"})
    public ResponseEntity<?> getAuthorizationByCurrentAndGoodCode(@PathVariable(value="goodsCode") String goodsCode, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        return ResponseEntity.ok((Object)this.authorizeQueryService.getAuthorization(authoredUser.getTenantId(), goodsCode));
    }

    @GetMapping(value={"/currentTenant/goods/{goodsCode}/modules"})
    public ResponseEntity<?> getModulesByCurrentAndGoodsCode(@PathVariable(value="goodsCode") String goodsCode, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        AuthorizationModuleWithPurchaseVO authorizationModuleWithPurchaseVO = this.authorizeArchiveService.getAuthorizationModule(authoredUser.getTenantId(), goodsCode);
        return new ResponseEntity((Object)authorizationModuleWithPurchaseVO, HttpStatus.OK);
    }

    @Deprecated
    @GetMapping(value={"/currentTenant/goods/{goodsCode}/customAttributes"})
    public ResponseEntity<?> getAttributesByCurrentAndGoodsCode(@PathVariable(value="goodsCode") String goodsCode, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        CustomAttributeWithPurchaseVO customAttributeWithPurchaseVO = this.authorizeArchiveService.getAuthorizationCustomAttribute(authoredUser.getTenantId(), goodsCode);
        return new ResponseEntity((Object)customAttributeWithPurchaseVO, HttpStatus.OK);
    }

    @GetMapping(value={"/currentTenant/users/{userId:.+}/enabled"})
    public ResponseEntity<?> getGoodsCodeByCurrentAndUserId(@PathVariable(value="userId") String userId, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        return ResponseEntity.ok((Object)this.authorizeOtherService.findGoodsCode(authoredUser.getTenantId(), userId));
    }

    @GetMapping(value={"/currentTenant/users/{userId:.+}/goods/{goodsCode}/byUser"})
    public ResponseEntity<?> checkGoodsAuthorization(@PathVariable(value="userId") String userId, @PathVariable(value="goodsCode") String goodsCode, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        AuthorizationCheckedVO authorizationCheckedVO = this.authorizeArchiveService.checkUserCanUseProduct(authoredUser.getTenantId(), goodsCode, userId, Boolean.valueOf(true));
        return new ResponseEntity((Object)authorizationCheckedVO, HttpStatus.OK);
    }

    @GetMapping(value={"/currentTenant/users/{userId:.+}/goods/{goodsCode}/module/{moduleId}/byUser"})
    public ResponseEntity<?> checkModuleAuthorizationByCurrent(@PathVariable(value="userId") String userId, @PathVariable(value="goodsCode") String goodsCode, @PathVariable(value="moduleId") String moduleId, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        AuthorizationCheckedVO authorizationCheckedVO = this.authorizeArchiveService.checkUserCanUseModule(authoredUser.getTenantId(), goodsCode, moduleId, userId);
        return new ResponseEntity((Object)authorizationCheckedVO, HttpStatus.OK);
    }

    @GetMapping(value={"/currentTenant/users/{userId:.+}/goods/{goodsCode}/modules/byUser"})
    public ResponseEntity<?> checkModulesAuthorizationByCurrent(@PathVariable(value="userId") String userId, @PathVariable(value="goodsCode") String goodsCode, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        List moduleCheckedVOList = this.authorizeArchiveService.checkUserCanUseModules(authoredUser.getTenantId(), goodsCode, userId);
        return new ResponseEntity((Object)moduleCheckedVOList, HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/copy/all"})
    public StdData<?> copyTenantAuth(@RequestBody @Valid AuthCompareResultVO body) {
        if (this.customerCrudService.existsById(body.getTenantId())) {
            return StdData.ok((Object)String.format("\u76ee\u6807\u79df\u6237%s\u5df2\u7ecf\u5b58\u5728\u6388\u6743\u4fe1\u606f\uff0c\u4e0d\u80fd\u590d\u5236\u6765\u6e90\u79df\u6237%s\u7684\u6388\u6743", body.getTenantId(), body.getSourceTenantId()));
        }
        this.authorizeArchiveService.copyTenantAuth(body.getSourceId(), body.getSourceTenantId(), body.getTenantId(), body.getTenantName());
        return StdData.ok((Object)String.format("\u590d\u5236\u6765\u6e90\u79df\u6237%s\u5230\u76ee\u6807\u79df\u6237%s\u6388\u6743\u4fe1\u606f\u6210\u529f", body.getSourceTenantId(), body.getTenantId()));
    }

    @GetMapping(value={"/current/user/apps"})
    public StdData<?> getUserAuthApps(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestParam(required=false) String userId) {
        if (!StringUtils.hasText((String)userId)) {
            userId = authoredUser.getUserId();
        } else if (!userId.equalsIgnoreCase(authoredUser.getUserId()) && !this.iamService.checkAccessPermission("GET", "/api/cac/v4/authorizations/current/user/apps", "Sys").booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.CAC_USER_PERMISSION_ERROR);
        }
        return StdData.ok((Object)this.authorizeOtherService.findGoodsInfo(authoredUser.getTenantId(), userId));
    }

    @PostMapping(value={"/current/simple"})
    public StdData<?> getAuthorizationsSimple(@RequestBody CurrentTenantQueryDTO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        return StdData.ok((Object)this.authorizeQueryService.getAuthorizationsSimple(authoredUser.getTenantId(), body));
    }

    @PostMapping(value={"/tenants/apps"})
    public StdData<?> batchQueryTenantByApp(@RequestBody SearchParamVO searchParamVO) {
        Assert.notEmpty((Collection)searchParamVO.getGoodsCodes(), (String)"goodsCodes\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        List byGoodsCodeIn = this.purchaseCrudService.findByGoodsCodeIn(searchParamVO.getGoodsCodes());
        return StdData.ok(byGoodsCodeIn.stream().filter(a -> a.getExpiredDateTime().isAfter(LocalDateTime.now())).map(AuthorizationVO::innerQuery).collect(Collectors.toList()));
    }

    @PostMapping(value={"/currentTenant/countingAlert"})
    public StdData<?> updateCountingAlertInfo(@RequestBody UpdateUsageAlertInfoRequest request, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        request.valid();
        Purchase purchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(authoredUser.getTenantId(), request.getGoodsCode());
        if (purchase == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10012, new Object[]{authoredUser.getTenantId(), request.getGoodsCode()});
        }
        PurchaseCount purchaseCount = this.purchaseCountCrudService.findByPurchaseId(purchase.getId());
        if (purchaseCount == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10031, new Object[]{authoredUser.getTenantId(), request.getGoodsCode()});
        }
        purchaseCount.setUsageAlert(request.getUsageAlert());
        if (Boolean.TRUE.equals(request.getUsageAlert())) {
            purchaseCount.setAlertThreshold(request.getAlertThreshold());
        }
        this.purchaseCountCrudService.update((BaseEntity)purchaseCount);
        return StdData.ok().build();
    }

    @GetMapping(value={"/currentTenant/countingAlert"})
    public StdData<?> getCountingAlertInfo(@RequestParam(value="goodsCode") String goodsCode, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Purchase purchase = this.purchaseCrudService.findByTenantIdAndGoodsCode(authoredUser.getTenantId(), goodsCode);
        if (purchase == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10012, new Object[]{authoredUser.getTenantId(), goodsCode});
        }
        PurchaseCount purchaseCount = this.purchaseCountCrudService.findByPurchaseId(purchase.getId());
        if (purchaseCount == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10031, new Object[]{authoredUser.getTenantId(), goodsCode});
        }
        HashMap<String, Comparable<Boolean>> result = new HashMap<String, Comparable<Boolean>>();
        result.put("usageAlert", purchaseCount.getUsageAlert());
        result.put("alertThreshold", purchaseCount.getAlertThreshold());
        return StdData.ok(result);
    }

    @GetMapping(value={"/current/category/exclude/policy"})
    public ResponseEntity<?> getAuthorizationsExcludePolicy(Page page, SearchParamVO searchParamVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        searchParamVO.flushCategoryIds(searchParamVO.getCategoryId());
        searchParamVO.setCustomerId(authoredUser.getTenantId());
        PageSerializable authorizations = this.authorizeArchiveService.getAuthorizationByPage(searchParamVO, page.getPageNum().intValue(), page.getPageSize().intValue(), page.getOrderBy(), Boolean.FALSE.booleanValue());
        return ResponseEntity.ok((Object)authorizations);
    }

    @GetMapping(value={"/current/batch/detail"})
    public StdData<?> findBatchDetail(BatchCodeQueryRequest input, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        input.setTenantId(authoredUser.getTenantId());
        List result = this.authorizeQueryService.findBatchDetail(input);
        return StdData.ok((Object)result);
    }
}

