/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.cac.api;

import com.digiwin.dap.middleware.cac.constant.I18nCode;
import com.digiwin.dap.middleware.cac.constant.I18nError;
import com.digiwin.dap.middleware.cac.domain.AppAuthUserDTO;
import com.digiwin.dap.middleware.cac.domain.AuthorizationInfoVO;
import com.digiwin.dap.middleware.cac.domain.AuthorizationVO;
import com.digiwin.dap.middleware.cac.domain.CloudPurchaseDTO;
import com.digiwin.dap.middleware.cac.domain.CountResultVO;
import com.digiwin.dap.middleware.cac.domain.OrderInfoVO;
import com.digiwin.dap.middleware.cac.domain.UsageCountResultVO;
import com.digiwin.dap.middleware.cac.domain.UserAuthorizationInfoVO;
import com.digiwin.dap.middleware.cac.domain.UserInCountingConditionVO;
import com.digiwin.dap.middleware.cac.domain.enumeration.CountPattern;
import com.digiwin.dap.middleware.cac.mapper.UserInCountingMapper;
import com.digiwin.dap.middleware.cac.service.business.AuthorizeQueryService;
import com.digiwin.dap.middleware.cac.service.business.UseCountService;
import com.digiwin.dap.middleware.cac.service.business.UserCountService;
import com.digiwin.dap.middleware.cac.support.validate.AuthorizeValidationService;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cac/v4/counting"})
public class CountingController {
    @Autowired
    private UserCountService userCountService;
    @Autowired
    private UseCountService useCountService;
    @Autowired
    private UserInCountingMapper userInCountingMapper;
    @Autowired
    private AuthorizeQueryService authorizeQueryService;
    @Autowired
    private AuthorizeValidationService authorizeValidationService;

    @GetMapping(value={"/query/{tenantId:.+}/{goodsCode}/{moduleId}"})
    public ResponseEntity<?> getCounting(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="goodsCode") String goodsCode, @PathVariable(value="moduleId") String moduleId) {
        UsageCountResultVO usageCountResultVO = this.useCountService.getAuthorizationCountingResult(tenantId, goodsCode, moduleId);
        return new ResponseEntity((Object)usageCountResultVO, HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/decrease"})
    public ResponseEntity<?> decreaseCounting(@RequestBody OrderInfoVO orderInfoVO) {
        this.authorizeValidationService.checkOrderInfoVO3(orderInfoVO);
        UsageCountResultVO usageCountResultVO = this.useCountService.decreaseAuthorizationCounting(orderInfoVO.getTenantId(), orderInfoVO.getGoodsCode(), orderInfoVO.getDecreaseCount());
        return ResponseEntity.ok((Object)usageCountResultVO);
    }

    @GetMapping(value={"/{tenantId:.+}/{goodsCode}"})
    public ResponseEntity<?> getUsersAuthorization(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="goodsCode") String goodsCode) {
        return ResponseEntity.ok((Object)this.userCountService.getUserInCounting(tenantId, goodsCode));
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/user/add"})
    public ResponseEntity<?> addUserInCounting(@RequestBody OrderInfoVO orderInfoVO) {
        this.authorizeValidationService.checkOrderInfoVO2(orderInfoVO);
        CountResultVO countResult = this.userCountService.addUser(orderInfoVO.getTenantId(), orderInfoVO.getCountingId(), orderInfoVO.getUserId());
        return ResponseEntity.ok((Object)countResult);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/user/remove"})
    public ResponseEntity<?> removeUserInCounting(@RequestBody OrderInfoVO orderInfoVO) {
        this.authorizeValidationService.checkOrderInfoVO2(orderInfoVO);
        CountResultVO countResult = this.userCountService.removeUser(orderInfoVO.getTenantId(), orderInfoVO.getCountingId(), orderInfoVO.getUserId());
        return new ResponseEntity((Object)countResult, HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/user/update"})
    public ResponseEntity<?> updateUserInCounting(@RequestBody OrderInfoVO body) {
        this.authorizeValidationService.checkOrderInfoVO1(body);
        CountResultVO countResult = this.userCountService.batchUpdateUser(body.getTenantId(), body.getCountingId(), body.getUsers());
        return ResponseEntity.ok((Object)countResult);
    }

    @PostMapping(value={"/user/update/incremental"})
    public StdData<?> batchAddUserInCounting(@RequestBody OrderInfoVO body) {
        String tenantId = StringUtils.hasLength((String)body.getTenantId()) ? body.getTenantId() : UserUtils.getTenantId();
        CountResultVO countResult = this.userCountService.batchAddUser(tenantId, body.getGoodsCode(), body.getUsers());
        return StdData.ok((Object)countResult);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/update/customunit"})
    public ResponseEntity<?> updateGoodsCustomUnit(@RequestBody Map<String, String> customUnitMap) {
        Assert.hasText((String)customUnitMap.get("goodsCode"), (String)"\u53c3\u6578\u932f\u8aa4: goodsCode");
        Assert.hasText((String)customUnitMap.get("customUnit"), (String)"\u53c3\u6578\u932f\u8aa4: customUnit");
        this.useCountService.updateCustomUnit(customUnitMap.get("goodsCode"), customUnitMap.get("customUnit"));
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional
    @PostMapping(value={"/user/canused"})
    public StdData<?> canAddUserInCounting(@RequestBody UserAuthorizationInfoVO userAuthorizationInfoVO) {
        Assert.hasText((String)userAuthorizationInfoVO.getTenantId(), (String)"TenantId:\u79df\u6237id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Assert.hasText((String)userAuthorizationInfoVO.getAppId(), (String)"\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a");
        CloudPurchaseDTO cloudPurchaseDTO = this.authorizeQueryService.getCloudPurchase(userAuthorizationInfoVO.getTenantId(), userAuthorizationInfoVO.getAppId());
        if (cloudPurchaseDTO != null) {
            if (CountPattern.Traditional.name().equals(cloudPurchaseDTO.getCountType()) && cloudPurchaseDTO.getUserCount() > cloudPurchaseDTO.getTotalCount()) {
                return StdData.of((boolean)false).build();
            }
        } else {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10012, new Object[]{userAuthorizationInfoVO.getTenantId(), userAuthorizationInfoVO.getAppId()});
        }
        return StdData.of((boolean)true).build();
    }

    @Transactional
    @PostMapping(value={"/user/batch/update"})
    public StdData<?> batchUpdateUserInCounting(@RequestBody UserAuthorizationInfoVO userAuthorizationInfoVO) {
        this.authorizeValidationService.checkAuthorization(userAuthorizationInfoVO);
        String tenantId = userAuthorizationInfoVO.getTenantId();
        String userId = userAuthorizationInfoVO.getUserId();
        userAuthorizationInfoVO.getDeleteAppIds().forEach(deleteAppId -> this.userCountService.removeUser(tenantId, deleteAppId, userId));
        if (!userAuthorizationInfoVO.getAddAppIds().isEmpty()) {
            AuthorizationInfoVO authorizationInfoVO = this.authorizeQueryService.getAuthorizationInfo(tenantId);
            List tenantApps = authorizationInfoVO.getAuthorizations().stream().map(AuthorizationVO::getCode).collect(Collectors.toList());
            ArrayList notExistedApps = new ArrayList();
            userAuthorizationInfoVO.getAddAppIds().forEach(appId -> {
                if (!tenantApps.contains(appId)) {
                    notExistedApps.add(appId);
                }
            });
            if (notExistedApps.size() > 0) {
                return StdData.of((int)500, (String)String.format(I18nCode.ADD_AUTHORIZATION_ERROR.getMessage(), tenantId, String.join((CharSequence)";", notExistedApps)));
            }
            ArrayList disableApps = new ArrayList();
            userAuthorizationInfoVO.getAddAppIds().forEach(addAppId -> {
                CountResultVO countResultVO = this.userCountService.addUser(tenantId, addAppId, userId);
                if (!countResultVO.getSuccess().booleanValue()) {
                    disableApps.add(addAppId);
                }
            });
            if (disableApps.size() > 0) {
                return StdData.of((int)500, (String)String.format(I18nCode.ADD_AUTHORIZATION_ERROR1.getMessage(), String.join((CharSequence)";", disableApps)));
            }
        }
        return StdData.ok().build();
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/user/remove/all"})
    public ResponseEntity<?> batchRemoveUserInCounting(@RequestBody OrderInfoVO orderInfoVO) {
        Assert.hasText((String)orderInfoVO.getUserId(), (String)"UserId:\u7528\u6237id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        CountResultVO countResult = this.userCountService.batchRemoveUser(orderInfoVO.getUserId());
        return ResponseEntity.ok((Object)countResult);
    }

    @PostMapping(value={"/app/authusers"})
    public StdData<?> getAuthUsers(@RequestBody AppAuthUserDTO body) {
        return StdData.ok((Object)this.userInCountingMapper.getAppAuthUsers(body));
    }

    @PostMapping(value={"/app"})
    public StdData<?> getAuthUsersByApp(@RequestBody AppAuthUserDTO body) {
        return StdData.ok((Object)this.userCountService.getAuthUsersByApp(body));
    }

    @PostMapping(value={"/authed"})
    public StdData<?> getAuthUsersByApp(@RequestBody OrderInfoVO body) {
        return StdData.ok((Object)this.userCountService.getAuthedUserIds(body));
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/user/remove/batch"})
    public StdData<?> batchRemoveUserFromPurchase(@RequestBody OrderInfoVO orderInfoVO) {
        Assert.hasText((String)orderInfoVO.getGoodsCode(), (String)"goodsCode:\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        String tenantId = StringUtils.hasLength((String)orderInfoVO.getTenantId()) ? orderInfoVO.getTenantId() : UserUtils.getTenantId();
        CountResultVO countResult = this.userCountService.batchRemoveUserFromPurchase(tenantId, orderInfoVO.getGoodsCode(), orderInfoVO.getUsers());
        return StdData.ok((Object)countResult);
    }

    @GetMapping(value={"/info"})
    public StdData<?> getUsersAuthorization(UserInCountingConditionVO conditionVO) {
        return StdData.ok((Object)this.userCountService.getUserInCountingVO(conditionVO));
    }
}

